/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.Nullable;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.FastFilterRewriteHelper;
import org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

class DateHistogramAggregator
extends BucketsAggregator
implements SizedBucketAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;
    private final FastFilterRewriteHelper.FastFilterContext fastFilterContext;

    DateHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = preparedRounding;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), cardinality);
        this.fastFilterContext = new FastFilterRewriteHelper.FastFilterContext(this.context, new DateHistogramAggregationType(valuesSourceConfig.fieldType(), valuesSourceConfig.missing() != null, valuesSourceConfig.script() != null, hardBounds));
        if (this.fastFilterContext.isRewriteable(parent, this.subAggregators.length)) {
            this.fastFilterContext.buildRanges(Objects.requireNonNull(valuesSourceConfig.fieldType()));
        }
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        boolean optimized = this.fastFilterContext.tryFastFilterAggregation(ctx, this::incrementBucketDocCount, key -> this.bucketOrds.add(0L, this.preparedRounding.round((Long)key)));
        if (optimized) {
            throw new CollectionTerminatedException();
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = DateHistogramAggregator.this.preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        if (DateHistogramAggregator.this.hardBounds == null || DateHistogramAggregator.this.hardBounds.contain(rounded)) {
                            long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(owningBucketOrd, rounded);
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                DateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                DateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
        if (this.fastFilterContext.optimizedSegments > 0) {
            add.accept("optimized_segments", this.fastFilterContext.optimizedSegments);
            add.accept("unoptimized_segments", this.fastFilterContext.segments - this.fastFilterContext.optimizedSegments);
            add.accept("leaf_visited", this.fastFilterContext.leaf);
            add.accept("inner_visited", this.fastFilterContext.inner);
        }
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(this.bucketOrds.get(bucket), unitSize);
        }
        return 1.0;
    }

    private class DateHistogramAggregationType
    extends FastFilterRewriteHelper.AbstractDateHistogramAggregationType {
        public DateHistogramAggregationType(MappedFieldType fieldType, boolean missing, boolean hasScript, LongBounds hardBounds) {
            super(fieldType, missing, hasScript, hardBounds);
        }

        @Override
        protected Rounding getRounding(long low, long high) {
            return DateHistogramAggregator.this.rounding;
        }

        @Override
        protected Rounding.Prepared getRoundingPrepared() {
            return DateHistogramAggregator.this.preparedRounding;
        }
    }
}

