/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.compress.NoneCompressor;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.repositories.blobstore.BaseBlobStoreFormat;

public class ConfigBlobStoreFormat<T extends ToXContent>
extends BaseBlobStoreFormat<T> {
    public ConfigBlobStoreFormat(String blobNameFormat) {
        super(blobNameFormat, true);
    }

    public void writeAsyncWithUrgentPriority(T obj, BlobContainer blobContainer, String name, ActionListener<Void> listener) throws IOException {
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, (Compressor)new NoneCompressor(), ToXContent.EMPTY_PARAMS, XContentType.JSON, null, null);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytesReference = this.serialize(obj, blobName, (Compressor)new NoneCompressor(), ToXContent.EMPTY_PARAMS, XContentType.JSON, null, null);
        String resourceDescription = "BlobStoreFormat.writeAsyncWithPriority(blob=\"" + blobName + "\")";
        byte[] bytes = BytesReference.toBytes((BytesReference)bytesReference);
        try (RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length, true, WritePriority.URGENT, (size, position) -> new OffsetRangeIndexInputStream(new ByteArrayIndexInput(resourceDescription, bytes), size, position), null, false);){
            ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
        }
    }
}

