/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils;

import org.apache.lucene.store.IOContext;
import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public class BlockIOContext
extends IOContext {
    private long blockStart;
    private long blockSize;

    public BlockIOContext(IOContext ctx, long blockStart, long blockSize) {
        super(ctx.context);
        this.verifyBlockStartAndSize(blockStart, blockSize);
        this.blockStart = blockStart;
        this.blockSize = blockSize;
    }

    public long getBlockStart() {
        return this.blockStart;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    private void verifyBlockStartAndSize(long blockStart, long blockSize) {
        if (blockStart < 0L) {
            throw new IllegalArgumentException("blockStart must be greater than or equal to 0");
        }
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("blockSize must be greater than 0");
        }
    }
}

