/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;

public class PrivilegesEvaluatorResponse {
    boolean allowed = false;
    Set<String> missingPrivileges = new HashSet<String>();
    Set<String> missingSecurityRoles = new HashSet<String>();
    Set<String> resolvedSecurityRoles = new HashSet<String>();
    PrivilegesEvaluatorResponseState state = PrivilegesEvaluatorResponseState.PENDING;
    CreateIndexRequestBuilder createIndexRequestBuilder;

    public boolean isAllowed() {
        return this.allowed;
    }

    public Set<String> getMissingPrivileges() {
        return new HashSet<String>(this.missingPrivileges);
    }

    public Set<String> getMissingSecurityRoles() {
        return new HashSet<String>(this.missingSecurityRoles);
    }

    public Set<String> getResolvedSecurityRoles() {
        return new HashSet<String>(this.resolvedSecurityRoles);
    }

    public CreateIndexRequestBuilder getCreateIndexRequestBuilder() {
        return this.createIndexRequestBuilder;
    }

    public PrivilegesEvaluatorResponse markComplete() {
        this.state = PrivilegesEvaluatorResponseState.COMPLETE;
        return this;
    }

    public PrivilegesEvaluatorResponse markPending() {
        this.state = PrivilegesEvaluatorResponseState.PENDING;
        return this;
    }

    public boolean isComplete() {
        return this.state == PrivilegesEvaluatorResponseState.COMPLETE;
    }

    public boolean isPending() {
        return this.state == PrivilegesEvaluatorResponseState.PENDING;
    }

    public String toString() {
        return "PrivEvalResponse [allowed=" + this.allowed + ", missingPrivileges=" + String.valueOf(this.missingPrivileges) + "]";
    }

    public static enum PrivilegesEvaluatorResponseState {
        PENDING,
        COMPLETE;

    }
}

