/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.event_process.EventDispatcher;
import org.opensearch.performanceanalyzer.commons.event_process.EventLog;
import org.opensearch.performanceanalyzer.commons.event_process.EventLogFileHandler;
import org.opensearch.performanceanalyzer.commons.event_process.EventProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesApplier;
import org.opensearch.performanceanalyzer.core.Util;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.reader.AdmissionControlProcessor;
import org.opensearch.performanceanalyzer.reader.AdmissionControlSnapshot;
import org.opensearch.performanceanalyzer.reader.ClusterDetailsEventProcessor;
import org.opensearch.performanceanalyzer.reader.ClusterManagerEventMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ClusterManagerMetricsEventProcessor;
import org.opensearch.performanceanalyzer.reader.ClusterManagerThrottlingMetricsEventProcessor;
import org.opensearch.performanceanalyzer.reader.ClusterManagerThrottlingMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.FaultDetectionMetricsProcessor;
import org.opensearch.performanceanalyzer.reader.FaultDetectionMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.GarbageCollectorInfoProcessor;
import org.opensearch.performanceanalyzer.reader.GarbageCollectorInfoSnapshot;
import org.opensearch.performanceanalyzer.reader.HttpRequestEventProcessor;
import org.opensearch.performanceanalyzer.reader.HttpRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.MemoryDBSnapshot;
import org.opensearch.performanceanalyzer.reader.MetricsEmitter;
import org.opensearch.performanceanalyzer.reader.NodeMetricsEventProcessor;
import org.opensearch.performanceanalyzer.reader.OSEventProcessor;
import org.opensearch.performanceanalyzer.reader.OSMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.Removable;
import org.opensearch.performanceanalyzer.reader.RequestEventProcessor;
import org.opensearch.performanceanalyzer.reader.ShardRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ShardStateMetricsProcessor;
import org.opensearch.performanceanalyzer.reader.ShardStateMetricsSnapshot;

public class ReaderMetricsProcessor
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(ReaderMetricsProcessor.class);
    private static final String DB_URL = "jdbc:sqlite:";
    private final Connection conn = DriverManager.getConnection("jdbc:sqlite:");
    private final DSLContext create = DSL.using((Connection)this.conn, (SQLDialect)SQLDialect.SQLITE);
    private NavigableMap<Long, MetricsDB> metricsDBMap = new ConcurrentSkipListMap<Long, MetricsDB>();
    private NavigableMap<Long, OSMetricsSnapshot> osMetricsMap = new TreeMap<Long, OSMetricsSnapshot>();
    private NavigableMap<Long, ShardRequestMetricsSnapshot> shardRqMetricsMap = new TreeMap<Long, ShardRequestMetricsSnapshot>();
    private NavigableMap<Long, HttpRequestMetricsSnapshot> httpRqMetricsMap = new TreeMap<Long, HttpRequestMetricsSnapshot>();
    private NavigableMap<Long, ClusterManagerEventMetricsSnapshot> clusterManagerEventMetricsMap = new TreeMap<Long, ClusterManagerEventMetricsSnapshot>();
    private NavigableMap<Long, GarbageCollectorInfoSnapshot> gcInfoMap;
    private Map<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> nodeMetricsMap;
    private NavigableMap<Long, FaultDetectionMetricsSnapshot> faultDetectionMetricsMap = new TreeMap<Long, FaultDetectionMetricsSnapshot>();
    private NavigableMap<Long, ClusterManagerThrottlingMetricsSnapshot> clusterManagerThrottlingMetricsMap;
    private NavigableMap<Long, ShardStateMetricsSnapshot> shardStateMetricsMap = new TreeMap<Long, ShardStateMetricsSnapshot>();
    private NavigableMap<Long, AdmissionControlSnapshot> admissionControlMetricsMap;
    private static final int MAX_DATABASES = 2;
    private static final int OS_SNAPSHOTS = 4;
    private static final int SHARD_STATE_SNAPSHOTS = 2;
    private static final int RQ_SNAPSHOTS = 4;
    private static final int HTTP_RQ_SNAPSHOTS = 4;
    private static final int CLUSTER_MANAGER_EVENT_SNAPSHOTS = 4;
    private static final int FAULT_DETECTION_SNAPSHOTS = 2;
    private static final int GC_INFO_SNAPSHOTS = 4;
    private static final int CLUSTER_MANAGER_THROTTLING_SNAPSHOTS = 2;
    private static final int AC_SNAPSHOTS = 2;
    private final String rootLocation;
    private final AppContext appContext;
    private final ConfigOverridesApplier configOverridesApplier;
    public static final String BATCH_METRICS_ENABLED_CONF_FILE = "batch_metrics_enabled.conf";
    private boolean batchMetricsEnabled;
    public static final boolean defaultBatchMetricsEnabled = false;
    private ConcurrentSkipListSet<Long> batchMetricsDBSet;
    private final boolean processNewFormat;
    private final EventLogFileHandler eventLogFileHandler;
    private static volatile ReaderMetricsProcessor current = null;

    public static void setCurrentInstance(ReaderMetricsProcessor currentInstance) {
        current = currentInstance;
    }

    public static ReaderMetricsProcessor getInstance() {
        return current;
    }

    public ReaderMetricsProcessor(String rootLocation) throws Exception {
        this(rootLocation, false, null);
    }

    public ReaderMetricsProcessor(String rootLocation, boolean processNewFormat, AppContext appContext) throws Exception {
        this.gcInfoMap = new TreeMap<Long, GarbageCollectorInfoSnapshot>();
        this.clusterManagerThrottlingMetricsMap = new TreeMap<Long, ClusterManagerThrottlingMetricsSnapshot>();
        this.admissionControlMetricsMap = new TreeMap<Long, AdmissionControlSnapshot>();
        this.rootLocation = rootLocation;
        this.configOverridesApplier = new ConfigOverridesApplier();
        AllMetrics.MetricName[] names = AllMetrics.MetricName.values();
        this.nodeMetricsMap = new HashMap<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>>(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.nodeMetricsMap.put(names[i], new TreeMap());
        }
        this.eventLogFileHandler = new EventLogFileHandler(new EventLog(), rootLocation);
        this.processNewFormat = processNewFormat;
        this.appContext = appContext;
        this.batchMetricsEnabled = false;
        this.batchMetricsDBSet = new ConcurrentSkipListSet();
        this.readBatchMetricsEnabledFromConf();
        this.restoreBatchMetricsState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            try {
                try (Statement stmt = this.conn.createStatement();){
                    stmt.executeUpdate("PRAGMA journal_mode = OFF");
                    stmt.executeUpdate("PRAGMA soft_heap_limit = 10000000");
                }
                long runInterval = 2500L;
                while (true) {
                    try (Statement vacuumStmt = this.conn.createStatement();){
                        vacuumStmt.executeUpdate("VACUUM");
                    }
                    this.conn.setAutoCommit(false);
                    startTime = System.currentTimeMillis();
                    this.processMetrics(this.rootLocation, startTime);
                    this.trimOldSnapshots();
                    this.conn.commit();
                    this.conn.setAutoCommit(true);
                    this.trimOldMetricsDBFiles();
                    long duration = System.currentTimeMillis() - startTime;
                    LOG.debug("Total time taken: {}", (Object)duration);
                    if (duration >= runInterval) continue;
                    Thread.sleep(runInterval - duration);
                }
            }
            catch (Throwable e) {
                StatsCollector.instance().logException(StatExceptionCode.READER_METRICS_PROCESSOR_ERROR);
                LOG.error(() -> new ParameterizedMessage("READER PROCESSOR ERROR. NEEDS DEBUGGING: {}", (Object)e.toString()), e);
                try {
                    long duration = System.currentTimeMillis() - startTime;
                    if (duration < 5000L) {
                        Thread.sleep(5000L - duration);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Exception in sleep: {}", new Supplier[]{() -> ex});
                }
                throw new RuntimeException("READER ERROR");
            }
        }
        catch (Throwable throwable) {
            try {
                this.shutdown();
                LOG.error("Connection to the database was closed.");
            }
            catch (Exception e) {
                LOG.error("Unable to close all database connections and shutdown cleanly.");
            }
            throw throwable;
        }
    }

    public void shutdown() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            StatsCollector.instance().logException(StatExceptionCode.IN_MEMORY_DATABASE_CONN_CLOSURE_ERROR);
            LOG.error("Unable to close inmemory database connection.", (Throwable)e);
        }
        for (MetricsDB db : this.metricsDBMap.values()) {
            try {
                db.close();
            }
            catch (Exception e) {
                StatsCollector.instance().logException(StatExceptionCode.METRICS_DB_CLOSURE_ERROR);
                LOG.error("Unable to close database - " + db.getDBFilePath(), (Throwable)e);
            }
        }
    }

    private void restoreBatchMetricsState() {
        Set<Long> recoveredMetricsdbFiles = MetricsDB.listOnDiskFiles();
        boolean shouldCleanup = PluginSettings.instance().shouldCleanupMetricsDBFiles();
        if (this.batchMetricsEnabled) {
            long minTime = System.currentTimeMillis() - PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes() * 60L * 1000L;
            for (Long ts2 : recoveredMetricsdbFiles) {
                if (ts2 >= minTime) {
                    this.batchMetricsDBSet.add(ts2);
                    continue;
                }
                if (!shouldCleanup) continue;
                MetricsDB.deleteOnDiskFile(ts2);
            }
        } else if (shouldCleanup) {
            recoveredMetricsdbFiles.forEach(ts -> MetricsDB.deleteOnDiskFile(ts));
        }
    }

    public void trimOldSnapshots() throws Exception {
        this.trimMap(this.osMetricsMap, 4);
        this.trimMap(this.shardRqMetricsMap, 4);
        this.trimMap(this.httpRqMetricsMap, 4);
        this.trimMap(this.clusterManagerEventMetricsMap, 4);
        this.trimMap(this.faultDetectionMetricsMap, 2);
        this.trimMap(this.shardStateMetricsMap, 2);
        this.trimMap(this.gcInfoMap, 4);
        this.trimMap(this.clusterManagerThrottlingMetricsMap, 2);
        this.trimMap(this.admissionControlMetricsMap, 2);
        for (NavigableMap<Long, MemoryDBSnapshot> snap : this.nodeMetricsMap.values()) {
            this.trimMap(snap, 4);
        }
    }

    public void trimOldMetricsDBFiles() throws Exception {
        boolean deleteDBFiles = PluginSettings.instance().shouldCleanupMetricsDBFiles();
        while (this.metricsDBMap.size() > 2) {
            Map.Entry<Long, MetricsDB> oldestEntry = this.metricsDBMap.pollFirstEntry();
            if (oldestEntry == null) continue;
            Long key = oldestEntry.getKey();
            MetricsDB value = oldestEntry.getValue();
            value.remove();
            if (!deleteDBFiles || this.batchMetricsDBSet.contains(key)) continue;
            value.deleteOnDiskFile();
        }
        if (!this.batchMetricsEnabled && !this.batchMetricsDBSet.isEmpty()) {
            if (deleteDBFiles) {
                for (Long timestamp : this.batchMetricsDBSet) {
                    if (this.metricsDBMap.containsKey(timestamp)) continue;
                    MetricsDB.deleteOnDiskFile(timestamp);
                }
            }
            this.batchMetricsDBSet.clear();
        }
        this.readBatchMetricsEnabledFromConf();
        long maxNumBatchMetricsDBFiles = PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes() * 12L + 1L;
        while ((long)this.batchMetricsDBSet.size() > maxNumBatchMetricsDBFiles) {
            Long timestamp = this.batchMetricsDBSet.pollFirst();
            if (!deleteDBFiles || this.metricsDBMap.containsKey(timestamp)) continue;
            MetricsDB.deleteOnDiskFile(timestamp);
        }
    }

    private void trimMap(NavigableMap<Long, ?> map, int maxSize) throws Exception {
        while (map.size() > maxSize) {
            Map.Entry<Long, ?> lowestEntry = map.firstEntry();
            if (lowestEntry == null) continue;
            Removable value = (Removable)lowestEntry.getValue();
            value.remove();
            map.remove(lowestEntry.getKey());
        }
    }

    private void emitMetrics(long currWindowStartTime) throws Exception {
        long prevWindowStartTime = currWindowStartTime - 5000L;
        if (this.metricsDBMap.get(prevWindowStartTime) != null) {
            LOG.debug("The metrics for this timestamp already exist. Skipping.");
            return;
        }
        long mCurrT = System.currentTimeMillis();
        OSMetricsSnapshot alignedOSSnapHolder = new OSMetricsSnapshot(this.conn, "os_aligned_", currWindowStartTime);
        OSMetricsSnapshot osAlignedSnap = this.alignOSMetrics(prevWindowStartTime, prevWindowStartTime + 5000L, alignedOSSnapHolder);
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for aligning OS Metrics: {}", (Object)(mFinalT - mCurrT));
        ServiceMetrics.READER_METRICS_AGGREGATOR.updateStat((MeasurementSet)ReaderMetrics.READER_OS_METRICS_EMIT_TIME, (Number)(mFinalT - mCurrT));
        mCurrT = System.currentTimeMillis();
        MetricsDB metricsDB = this.createMetricsDB(prevWindowStartTime);
        this.emitGarbageCollectionInfo(prevWindowStartTime, metricsDB);
        this.emitShardRequestMetrics(prevWindowStartTime, alignedOSSnapHolder, osAlignedSnap, metricsDB);
        this.emitHttpRequestMetrics(prevWindowStartTime, metricsDB);
        this.emitNodeMetrics(currWindowStartTime, metricsDB);
        this.emitShardStateMetrics(prevWindowStartTime, metricsDB);
        this.emitFaultDetectionMetrics(prevWindowStartTime, metricsDB);
        this.emitAdmissionControlMetrics(prevWindowStartTime, metricsDB);
        this.emitClusterManagerMetrics(prevWindowStartTime, metricsDB);
        this.emitClusterManagerThrottlingMetrics(prevWindowStartTime, metricsDB);
        metricsDB.commit();
        this.metricsDBMap.put(prevWindowStartTime, metricsDB);
        ServiceMetrics.READER_METRICS_AGGREGATOR.updateStat((MeasurementSet)ReaderMetrics.METRICSDB_FILE_SIZE, (Number)new File(metricsDB.getDBFilePath()).length());
        if (this.batchMetricsEnabled) {
            this.batchMetricsDBSet.add(prevWindowStartTime);
        }
        mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for emitting Metrics: {}", (Object)(mFinalT - mCurrT));
        ServiceMetrics.READER_METRICS_AGGREGATOR.updateStat((MeasurementSet)ReaderMetrics.READER_METRICS_EMIT_TIME, (Number)(mFinalT - mCurrT));
    }

    private void emitGarbageCollectionInfo(long prevWindowStartTime, MetricsDB metricsDB) throws Exception {
        if (this.gcInfoMap.containsKey(prevWindowStartTime)) {
            GarbageCollectorInfoSnapshot prevGcSnap = (GarbageCollectorInfoSnapshot)this.gcInfoMap.get(prevWindowStartTime);
            MetricsEmitter.emitGarbageCollectionInfo(metricsDB, prevGcSnap);
        } else {
            LOG.debug("Garbage collector information snapshot does not exist for the previous window. Not emitting metrics.");
        }
    }

    private void emitShardRequestMetrics(long prevWindowStartTime, OSMetricsSnapshot alignedOSSnapHolder, OSMetricsSnapshot osAlignedSnap, MetricsDB metricsDB) throws Exception {
        if (this.shardRqMetricsMap.containsKey(prevWindowStartTime)) {
            long mCurrT = System.currentTimeMillis();
            ShardRequestMetricsSnapshot preShardRequestMetricsSnapshot = (ShardRequestMetricsSnapshot)this.shardRqMetricsMap.get(prevWindowStartTime);
            LOG.debug("shard emit time {}, {}", (Object)prevWindowStartTime, (Object)preShardRequestMetricsSnapshot.windowStartTime);
            MetricsEmitter.emitWorkloadMetrics(this.create, metricsDB, preShardRequestMetricsSnapshot);
            if (osAlignedSnap != null) {
                MetricsEmitter.emitAggregatedOSMetrics(this.create, metricsDB, osAlignedSnap, preShardRequestMetricsSnapshot);
                MetricsEmitter.emitThreadNameMetrics(this.create, metricsDB, osAlignedSnap);
            } else {
                LOG.debug("OS METRICS NULL");
            }
            alignedOSSnapHolder.remove();
            ServiceMetrics.READER_METRICS_AGGREGATOR.updateStat((MeasurementSet)ReaderMetrics.SHARD_REQUEST_METRICS_EMITTER_EXECUTION_TIME, (Number)(System.currentTimeMillis() - mCurrT));
        } else {
            LOG.debug("Shard request snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    private void emitHttpRequestMetrics(long prevWindowStartTime, MetricsDB metricsDB) throws Exception {
        if (this.httpRqMetricsMap.containsKey(prevWindowStartTime)) {
            HttpRequestMetricsSnapshot prevHttpRqSnap = (HttpRequestMetricsSnapshot)this.httpRqMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitHttpMetrics(this.create, metricsDB, prevHttpRqSnap);
        } else {
            LOG.debug("Http request snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    public void emitNodeMetrics(long currWindowStartTime, MetricsDB metricsDB) throws Exception {
        long prevWindowStartTime = currWindowStartTime - 5000L;
        for (Map.Entry<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> entry : this.nodeMetricsMap.entrySet()) {
            AllMetrics.MetricName metricName = entry.getKey();
            NavigableMap<Long, MemoryDBSnapshot> metricMap = entry.getValue();
            long mCurrT = System.currentTimeMillis();
            MemoryDBSnapshot alignedSnapshotHolder = new MemoryDBSnapshot(this.getConnection(), metricName, currWindowStartTime, true);
            MemoryDBSnapshot alignedSnapshot = this.alignNodeMetrics(metricName, metricMap, prevWindowStartTime, currWindowStartTime, alignedSnapshotHolder);
            long mFinalT = System.currentTimeMillis();
            LOG.debug("Total time taken for aligning {} Metrics: {}", (Object)metricName, (Object)(mFinalT - mCurrT));
            if (alignedSnapshot == null) {
                alignedSnapshotHolder.remove();
                LOG.debug("{} snapshot for the previous window does not exist. Not emitting metrics.", (Object)metricName);
                continue;
            }
            mCurrT = System.currentTimeMillis();
            MetricsEmitter.emitNodeMetrics(this.create, metricsDB, alignedSnapshot);
            alignedSnapshotHolder.remove();
            mFinalT = System.currentTimeMillis();
            LOG.debug("Total time taken for emitting node metrics: {}", (Object)(mFinalT - mCurrT));
        }
    }

    private void emitShardStateMetrics(long prevWindowStartTime, MetricsDB metricsDB) {
        if (this.shardStateMetricsMap.containsKey(prevWindowStartTime)) {
            ShardStateMetricsSnapshot prevShardsStateMetricsSnapshot = (ShardStateMetricsSnapshot)this.shardStateMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitShardStateMetric(metricsDB, prevShardsStateMetricsSnapshot);
        } else {
            LOG.debug("Shard State snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    private void emitFaultDetectionMetrics(long prevWindowStartTime, MetricsDB metricsDB) {
        if (this.faultDetectionMetricsMap.containsKey(prevWindowStartTime)) {
            FaultDetectionMetricsSnapshot prevFaultDetectionSnap = (FaultDetectionMetricsSnapshot)this.faultDetectionMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitFaultDetectionMetrics(metricsDB, prevFaultDetectionSnap);
        } else {
            LOG.debug("Fault Detection snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    private void emitAdmissionControlMetrics(long prevWindowStartTime, MetricsDB metricsDB) throws Exception {
        if (this.admissionControlMetricsMap.containsKey(prevWindowStartTime)) {
            AdmissionControlSnapshot previousSnapshot = (AdmissionControlSnapshot)this.admissionControlMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitAdmissionControlMetrics(metricsDB, previousSnapshot);
        } else {
            LOG.debug("Admission control snapshot does not exist for the previous window. Not emitting metrics.");
        }
    }

    private void emitClusterManagerMetrics(long prevWindowStartTime, MetricsDB metricsDB) {
        if (this.clusterManagerEventMetricsMap.containsKey(prevWindowStartTime)) {
            ClusterManagerEventMetricsSnapshot preClusterManagerEventSnapshot = (ClusterManagerEventMetricsSnapshot)this.clusterManagerEventMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitClusterManagerEventMetrics(metricsDB, preClusterManagerEventSnapshot);
        } else {
            LOG.debug("ClusterManager snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    private void emitClusterManagerThrottlingMetrics(long prevWindowStartTime, MetricsDB metricsDB) {
        if (this.clusterManagerThrottlingMetricsMap.containsKey(prevWindowStartTime)) {
            ClusterManagerThrottlingMetricsSnapshot prevShardsStateMetricsSnapshot = (ClusterManagerThrottlingMetricsSnapshot)this.clusterManagerThrottlingMetricsMap.get(prevWindowStartTime);
            MetricsEmitter.emitClusterManagerThrottledTaskMetric(metricsDB, prevShardsStateMetricsSnapshot);
        } else {
            LOG.debug("ClusterManager Throttling snapshot for the previous window does not exist. Not emitting metrics.");
        }
    }

    public void processMetrics(String rootLocation, long currTimestamp) throws Exception {
        long mCurrT = System.currentTimeMillis();
        long currWindowStartTime = PerformanceAnalyzerMetrics.getTimeInterval((long)currTimestamp, (int)5000);
        long currWindowEndTime = (currWindowStartTime -= 15000L) + 5000L;
        EventProcessor osProcessor = OSEventProcessor.buildOSMetricEventsProcessor(currWindowStartTime, currWindowEndTime, this.conn, this.osMetricsMap);
        RequestEventProcessor requestProcessor = RequestEventProcessor.buildRequestMetricEventsProcessor(currWindowStartTime, currWindowEndTime, this.conn, this.shardRqMetricsMap);
        HttpRequestEventProcessor httpProcessor = HttpRequestEventProcessor.buildHttpRequestMetricEventsProcessor(currWindowStartTime, currWindowEndTime, this.conn, this.httpRqMetricsMap);
        FaultDetectionMetricsProcessor faultDetectionProcessor = FaultDetectionMetricsProcessor.buildFaultDetectionMetricsProcessor(currWindowStartTime, this.conn, this.faultDetectionMetricsMap);
        ClusterManagerMetricsEventProcessor clusterManagerEventsProcessor = ClusterManagerMetricsEventProcessor.buildClusterManagerMetricEventsProcessor(currWindowStartTime, this.conn, this.clusterManagerEventMetricsMap);
        NodeMetricsEventProcessor nodeEventsProcessor = NodeMetricsEventProcessor.buildNodeMetricEventsProcessor(currWindowStartTime, this.conn, this.nodeMetricsMap);
        ShardStateMetricsProcessor shardStateMetricsProcessor = ShardStateMetricsProcessor.buildShardStateMetricEventsProcessor(currWindowStartTime, this.conn, this.shardStateMetricsMap);
        GarbageCollectorInfoProcessor garbageCollectorInfoProcessor = GarbageCollectorInfoProcessor.buildGarbageCollectorInfoProcessor(currWindowStartTime, this.conn, this.gcInfoMap);
        ClusterManagerThrottlingMetricsEventProcessor clusterManagerThrottlingEventsProcessor = ClusterManagerThrottlingMetricsEventProcessor.buildClusterManagerThrottlingMetricEventsProcessor(currWindowStartTime, this.conn, this.clusterManagerThrottlingMetricsMap);
        ClusterDetailsEventProcessor clusterDetailsEventsProcessor = new ClusterDetailsEventProcessor(this.configOverridesApplier);
        AdmissionControlProcessor admissionControlProcessor = AdmissionControlProcessor.build(currWindowStartTime, this.conn, this.admissionControlMetricsMap);
        EventDispatcher eventDispatcher = new EventDispatcher();
        eventDispatcher.registerEventProcessor(osProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)requestProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)httpProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)nodeEventsProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)clusterManagerEventsProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)clusterManagerThrottlingEventsProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)shardStateMetricsProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)clusterDetailsEventsProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)faultDetectionProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)garbageCollectorInfoProcessor);
        eventDispatcher.registerEventProcessor((EventProcessor)admissionControlProcessor);
        eventDispatcher.initializeProcessing(currWindowStartTime, currWindowStartTime + 5000L);
        this.eventLogFileHandler.read(currWindowStartTime, eventDispatcher);
        eventDispatcher.finalizeProcessing();
        this.emitMetrics(currWindowStartTime);
        if (this.appContext != null && !clusterDetailsEventsProcessor.getNodesDetails().isEmpty()) {
            this.appContext.setClusterDetailsEventProcessor(clusterDetailsEventsProcessor);
        }
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for processing Metrics: {}", (Object)(mFinalT - mCurrT));
        ServiceMetrics.READER_METRICS_AGGREGATOR.updateStat((MeasurementSet)ReaderMetrics.READER_METRICS_PROCESS_TIME, (Number)(mFinalT - mCurrT));
    }

    public OSMetricsSnapshot alignOSMetrics(long startTime, long endTime, OSMetricsSnapshot alignedWindow) throws Exception {
        LOG.debug("Aligning metrics for {}, {}", (Object)startTime, (Object)endTime);
        if (this.osMetricsMap.size() < 4) {
            LOG.warn("Exited due to too few snapshots - {}", (Object)this.osMetricsMap.size());
            return null;
        }
        Map.Entry<Long, OSMetricsSnapshot> entry = this.osMetricsMap.higherEntry(startTime);
        if (entry == null) {
            LOG.warn("No OS snapshot above startTime.");
            return null;
        }
        Long t1 = entry.getKey();
        if (t1 == null) {
            LOG.error("We dont have an OS snapshot above startTime.");
            return null;
        }
        Long t2 = this.osMetricsMap.higherKey(t1);
        if (t2 == null) {
            LOG.error("We dont have the next OS snapshot above startTime.");
            return entry.getValue();
        }
        if (t2 < endTime) {
            LOG.error("Right window snapshot ends before endTime. rw: {}, lw: {}, startTime: {}, endTime: {}", (Object)t2, (Object)t1, (Object)startTime, (Object)endTime);
            return null;
        }
        LOG.debug("Adding new scaled OS snapshot- actualTime {}", (Object)startTime);
        OSMetricsSnapshot leftWindow = (OSMetricsSnapshot)this.osMetricsMap.get(t1);
        OSMetricsSnapshot rightWindow = (OSMetricsSnapshot)this.osMetricsMap.get(t2);
        OSMetricsSnapshot.alignWindow(leftWindow, rightWindow, alignedWindow.getTableName(), startTime, endTime);
        return alignedWindow;
    }

    public MemoryDBSnapshot alignNodeMetrics(AllMetrics.MetricName metricName, NavigableMap<Long, MemoryDBSnapshot> metricMap, long readerStartTime, long readerEndTime, MemoryDBSnapshot alignedWindow) throws Exception {
        LOG.debug("Aligning node metrics for {}, from {} to {}", (Object)metricName, (Object)readerStartTime, (Object)readerEndTime);
        if (metricMap.size() < 3) {
            LOG.warn("Exited node metrics for {}, due to too few snapshots", (Object)metricName);
            return null;
        }
        Map.Entry<Long, MemoryDBSnapshot> entry = metricMap.ceilingEntry(readerStartTime);
        if (entry == null) {
            LOG.warn("No {} metrics snapshot above startTime.", (Object)metricName);
            return null;
        }
        Long t1 = entry.getKey();
        if (t1 == null) {
            LOG.error("We dont have an {} snapshot above startTime.", (Object)metricName);
            return null;
        }
        Long t2 = metricMap.higherKey(t1);
        if (t2 == null) {
            LOG.error("We dont have the next {} snapshot above startTime.", (Object)metricName);
            return entry.getValue();
        }
        if (t1 == readerStartTime) {
            LOG.debug("Found matching {} snapshot.", (Object)metricName);
            return (MemoryDBSnapshot)metricMap.get(t2);
        }
        if (t2 <= readerEndTime) {
            LOG.error("Right window {} snapshot ends at or before endTime. rw: {}, lw: {}, startTime: {}, endTime: {}", (Object)metricName, (Object)t2, (Object)t1, (Object)readerStartTime, (Object)readerEndTime);
            return null;
        }
        LOG.debug("Adding new scaled {} snapshot- actualTime {}", (Object)metricName, (Object)readerStartTime);
        MemoryDBSnapshot leftWindow = (MemoryDBSnapshot)metricMap.get(t1);
        MemoryDBSnapshot rightWindow = (MemoryDBSnapshot)metricMap.get(t2);
        alignedWindow.alignWindow(leftWindow, rightWindow, t1, readerStartTime, readerEndTime);
        return alignedWindow;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public DSLContext getDSLContext() {
        return this.create;
    }

    public Map.Entry<Long, MetricsDB> getMetricsDB() {
        return this.metricsDBMap.lastEntry();
    }

    public MetricsDB createMetricsDB(long timestamp) throws Exception {
        MetricsDB db = new MetricsDB(timestamp);
        return db;
    }

    public void deleteDBs() throws Exception {
        for (MetricsDB db : this.metricsDBMap.values()) {
            db.remove();
        }
    }

    public NavigableSet<Long> getBatchMetrics() {
        if (this.batchMetricsEnabled) {
            TreeSet batchMetricsDBSetCopy = new TreeSet(this.batchMetricsDBSet.clone());
            long maxNumBatchMetricsDBFiles = PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes() * 12L;
            while ((long)batchMetricsDBSetCopy.size() > maxNumBatchMetricsDBFiles) {
                batchMetricsDBSetCopy.pollFirst();
            }
            return Collections.unmodifiableNavigableSet(batchMetricsDBSetCopy);
        }
        return null;
    }

    private void readBatchMetricsEnabledFromConf() {
        Path filePath = Paths.get(Util.DATA_DIR, BATCH_METRICS_ENABLED_CONF_FILE);
        Util.invokePrivileged(() -> {
            try (Scanner sc = new Scanner(filePath);){
                String nextLine = sc.nextLine();
                boolean oldValue = this.batchMetricsEnabled;
                boolean newValue = Boolean.parseBoolean(nextLine);
                if (oldValue != newValue) {
                    this.batchMetricsEnabled = newValue;
                    LOG.info("Batch metrics enabled changed from {} to {}", (Object)oldValue, (Object)newValue);
                }
            }
            catch (IOException e) {
                StatsCollector.instance().logException(StatExceptionCode.BATCH_METRICS_CONFIG_ERROR);
                LOG.error("Error reading file '{}': {}", (Object)filePath.toString(), (Object)e);
                this.batchMetricsEnabled = false;
            }
        });
    }

    public boolean getBatchMetricsEnabled() {
        return this.batchMetricsEnabled;
    }

    static Map<String, String> extractEntryData(String eventValue) {
        String[] lines = eventValue.split(System.lineSeparator());
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String line : lines) {
            String[] pair = line.split(":");
            if (pair.length == 1) {
                keyValueMap.put(pair[0], "");
                continue;
            }
            keyValueMap.put(pair[0], pair[1]);
        }
        return keyValueMap;
    }

    @VisibleForTesting
    Map<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> getNodeMetricsMap() {
        return this.nodeMetricsMap;
    }

    @VisibleForTesting
    NavigableMap<Long, OSMetricsSnapshot> getOsMetricsMap() {
        return this.osMetricsMap;
    }

    @VisibleForTesting
    EventLogFileHandler getEventLogFileHandler() {
        return this.eventLogFileHandler;
    }

    @VisibleForTesting
    NavigableMap<Long, ShardRequestMetricsSnapshot> getShardRequestMetricsMap() {
        return this.shardRqMetricsMap;
    }

    @VisibleForTesting
    NavigableMap<Long, HttpRequestMetricsSnapshot> getHttpRqMetricsMap() {
        return this.httpRqMetricsMap;
    }

    @VisibleForTesting
    NavigableMap<Long, ClusterManagerEventMetricsSnapshot> getClusterManagerEventMetricsMap() {
        return this.clusterManagerEventMetricsMap;
    }

    @VisibleForTesting
    NavigableMap<Long, ClusterManagerThrottlingMetricsSnapshot> getClusterManagerThrottlingMetricsMap() {
        return this.clusterManagerThrottlingMetricsMap;
    }

    @VisibleForTesting
    NavigableMap<Long, ShardStateMetricsSnapshot> getShardStateMetricsMap() {
        return this.shardStateMetricsMap;
    }

    @VisibleForTesting
    void putNodeMetricsMap(AllMetrics.MetricName name, NavigableMap<Long, MemoryDBSnapshot> metricsMap) {
        this.nodeMetricsMap.put(name, metricsMap);
    }

    @VisibleForTesting
    NavigableMap<Long, MetricsDB> getMetricsDBMap() {
        return this.metricsDBMap;
    }

    @VisibleForTesting
    public void readBatchMetricsEnabledFromConfShim() {
        this.readBatchMetricsEnabledFromConf();
    }
}

