/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public enum ModbusWriteFunctionCode {
    WRITE_COIL(5),
    WRITE_MULTIPLE_COILS(15),
    WRITE_SINGLE_REGISTER(6),
    WRITE_MULTIPLE_REGISTERS(16);

    private final int functionCode;

    private ModbusWriteFunctionCode(int code) {
        this.functionCode = code;
    }

    public int getFunctionCode() {
        return this.functionCode;
    }

    public static ModbusWriteFunctionCode fromFunctionCode(int functionCode) throws IllegalArgumentException {
        return Stream.of(ModbusWriteFunctionCode.values()).filter(v -> v.getFunctionCode() == functionCode).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid functionCode"));
    }
}

