/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.create;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class TestCreator {
    private static final Logger LOGGER = Logger.getLogger(TestCreator.class.getName());
    private final PhpModule phpModule;

    public TestCreator(PhpModule phpModule) {
        this.phpModule = phpModule;
    }

    public CreateTestsResult createTests(List<FileObject> files) {
        HashSet<FileObject> failed = new HashSet<FileObject>();
        HashSet<FileObject> succeeded = new HashSet<FileObject>();
        try {
            SkeletonGenerator skeletonGenerator = SkeletonGenerator.getDefault();
            for (FileObject fo : files) {
                this.generateTest(skeletonGenerator, this.phpModule, fo, failed, succeeded);
            }
        }
        catch (InvalidPhpExecutableException ex) {
            UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage(), (String)"FrameworksAndTools/PhpUnit");
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/PhpUnit");
        }
        return new CreateTestsResult(succeeded, failed);
    }

    private void generateTest(SkeletonGenerator skeletonGenerator, PhpModule phpModule, FileObject fo, Set<FileObject> failed, Set<FileObject> succeeded) throws ExecutionException {
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection classes = editorSupport.getClasses(fo);
        if (classes.isEmpty()) {
            failed.add(fo);
            return;
        }
        for (PhpClass phpClass : classes) {
            FileObject testFile = skeletonGenerator.generateTest(phpModule, fo, phpClass.getFullyQualifiedName());
            if (testFile != null) {
                succeeded.add(testFile);
                continue;
            }
            failed.add(fo);
        }
    }
}

