/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml.structure;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import net.vieiro.toml.antlr4.TOMLAntlrParser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public final class TomlStructureItem
implements StructureItem,
ElementHandle {
    private final ItemKind kind;
    private final String name;
    private final int startPosition;
    private final int stopPosition;
    private FileObject fo;

    public TomlStructureItem(FileObject fo, TOMLAntlrParser.Array_tableContext array_table) {
        this(fo, ItemKind.ARRAY_TABLE, (ParserRuleContext)array_table, (ParserRuleContext)array_table.key());
    }

    public TomlStructureItem(FileObject fo, TOMLAntlrParser.Standard_tableContext standard_table) {
        this(fo, ItemKind.STANDARD_TABLE, (ParserRuleContext)standard_table, (ParserRuleContext)standard_table.key());
    }

    private TomlStructureItem(FileObject fo, ItemKind kind, ParserRuleContext context, ParserRuleContext key) {
        this.kind = kind;
        this.name = key.getText();
        this.startPosition = context.start.getStartIndex();
        this.stopPosition = context.stop.getStopIndex();
        this.fo = fo;
    }

    public String getName() {
        return this.name;
    }

    public String getSortText() {
        return this.name;
    }

    public String getHtml(HtmlFormatter formatter) {
        formatter.appendText(this.name);
        return formatter.getText();
    }

    public ElementHandle getElementHandle() {
        return this;
    }

    public ElementKind getKind() {
        return ElementKind.CONSTANT;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return true;
    }

    public List<? extends StructureItem> getNestedItems() {
        return Collections.emptyList();
    }

    public long getPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.stopPosition;
    }

    public ImageIcon getCustomIcon() {
        String iconBase = this.getIconBase();
        return new ImageIcon(ImageUtilities.loadImage((String)iconBase));
    }

    private String getIconBase() {
        switch (this.kind) {
            case ARRAY_TABLE: {
                return "org/netbeans/modules/languages/toml/structure/resources/toml-array.png";
            }
        }
        return "org/netbeans/modules/languages/toml/structure/resources/toml-table.png";
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public String getMimeType() {
        return "text/x-toml";
    }

    public String getIn() {
        return null;
    }

    public boolean signatureEquals(ElementHandle handle) {
        return false;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return new OffsetRange(this.startPosition, this.stopPosition);
    }

    public static enum ItemKind {
        ARRAY_TABLE,
        STANDARD_TABLE;

    }
}

