/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.build.AdvancedTask;
import org.netbeans.modules.web.clientproject.build.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AdvancedTasksPanel
extends JPanel {
    private final String buildToolExec;
    private final List<AdvancedTask> tasks;
    private final Set<AdvancedTask> invalidTasks = new HashSet<AdvancedTask>();
    final AdvancedTaskListModel tasksListModel;
    DialogDescriptor descriptor;
    private AdvancedTask selectedTask;
    private JButton addButton;
    private JPanel detailsPanel;
    private JButton downButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel optionsLabel;
    private JTextField optionsTextField;
    private JLabel parametersLabel;
    private JTextField parametersTextField;
    private JLabel previewLabel;
    private JTextField previewTextField;
    private JButton removeButton;
    private JSeparator separator;
    private JCheckBox sharedCheckBox;
    private JCheckBox showSimpleTasksCheckBox;
    private JSplitPane splitPane;
    private JComboBox<String> tasksComboBox;
    private JLabel tasksLabel;
    private JList<AdvancedTask> tasksList;
    private JPanel tasksPanel;
    private JScrollPane tasksScrollPane;
    private JButton upButton;

    private AdvancedTasksPanel(String tasksLabel, String buildToolExec, List<String> simpleTasks, List<AdvancedTask> tasks, boolean showSimpleTasks) {
        assert (EventQueue.isDispatchThread());
        assert (tasksLabel != null);
        assert (buildToolExec != null);
        assert (simpleTasks != null);
        assert (tasks != null);
        this.buildToolExec = buildToolExec;
        this.tasks = new ArrayList<AdvancedTask>(tasks);
        this.tasksListModel = new AdvancedTaskListModel(this.tasks);
        this.initComponents();
        this.init(tasksLabel, simpleTasks, showSimpleTasks);
    }

    @CheckForNull
    public static AdvancedTasksPanel open(String title, String tasksLabel, String buildToolExec, List<String> simpleTasks, List<AdvancedTask> tasks, boolean showSimpleTasks) {
        assert (EventQueue.isDispatchThread());
        AdvancedTasksPanel panel = new AdvancedTasksPanel(tasksLabel, buildToolExec, simpleTasks, tasks, showSimpleTasks);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title, true, null);
        descriptor.setAdditionalOptions(new Object[]{panel.getShowSimpleTasksCheckBox()});
        descriptor.setClosingOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        descriptor.createNotificationLineSupport();
        panel.descriptor = descriptor;
        panel.selectFirstTask();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
            return panel;
        }
        return null;
    }

    private void init(String tasksLabel, List<String> tasks, boolean showSimpleTasks) {
        assert (EventQueue.isDispatchThread());
        Mnemonics.setLocalizedText((JLabel)this.tasksLabel, (String)tasksLabel);
        this.tasksComboBox.setModel(new DefaultComboBoxModel<String>(tasks.toArray(new String[0])));
        this.tasksList.setModel(this.tasksListModel);
        this.tasksList.setCellRenderer(new AdvancedTaskListCellRenderer());
        this.showSimpleTasksCheckBox.setSelected(showSimpleTasks);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListenerImpl(){

            @Override
            void updateTask(AdvancedTask task) {
                assert (EventQueue.isDispatchThread());
                task.setName(AdvancedTasksPanel.this.nameTextField.getText());
                AdvancedTasksPanel.this.tasksListModel.fireChange(task);
            }
        });
        this.optionsTextField.getDocument().addDocumentListener(new DocumentListenerImpl(){

            @Override
            void updateTask(AdvancedTask task) {
                task.setOptions(AdvancedTasksPanel.this.optionsTextField.getText());
            }
        });
        this.tasksComboBox.addActionListener(new ActionListenerImpl(){

            @Override
            void updateTask(AdvancedTask task) {
                task.setTasks((String)AdvancedTasksPanel.this.tasksComboBox.getSelectedItem());
            }
        });
        this.parametersTextField.getDocument().addDocumentListener(new DocumentListenerImpl(){

            @Override
            void updateTask(AdvancedTask task) {
                task.setParameters(AdvancedTasksPanel.this.parametersTextField.getText());
            }
        });
        this.sharedCheckBox.addItemListener(new ItemListenerImpl(){

            @Override
            void updateTask(AdvancedTask task) {
                task.setShared(AdvancedTasksPanel.this.sharedCheckBox.isSelected());
                AdvancedTasksPanel.this.tasksListModel.fireChange(task);
            }
        });
        this.tasksList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ArrayList selectedTasks = new ArrayList(AdvancedTasksPanel.this.tasksList.getSelectedValuesList());
                if (selectedTasks.size() == 1) {
                    AdvancedTasksPanel.this.selectedTask = (AdvancedTask)selectedTasks.get(0);
                } else {
                    AdvancedTasksPanel.this.selectedTask = null;
                }
                AdvancedTasksPanel.this.selectedTasksChanged();
            }
        });
    }

    public List<AdvancedTask> getTasks() {
        assert (EventQueue.isDispatchThread());
        return Collections.unmodifiableList(this.tasks);
    }

    public boolean isShowSimpleTasks() {
        assert (EventQueue.isDispatchThread());
        return this.showSimpleTasksCheckBox.isSelected();
    }

    JCheckBox getShowSimpleTasksCheckBox() {
        assert (EventQueue.isDispatchThread());
        return this.showSimpleTasksCheckBox;
    }

    void selectFirstTask() {
        assert (EventQueue.isDispatchThread());
        if (this.tasks.isEmpty()) {
            this.addNewTask();
        }
        this.tasksList.setSelectedIndex(0);
    }

    int[] getSelectedIndices() {
        assert (EventQueue.isDispatchThread());
        return this.tasksList.getSelectedIndices();
    }

    @CheckForNull
    AdvancedTask getSelectedTask() {
        assert (EventQueue.isDispatchThread());
        return this.selectedTask;
    }

    void selectedTasksChanged() {
        assert (EventQueue.isDispatchThread());
        this.taskChanged(true);
        this.handleActionButtons();
    }

    void taskChanged(boolean updateFields) {
        assert (EventQueue.isDispatchThread());
        AdvancedTask selected = this.getSelectedTask();
        if (selected == null) {
            this.clearFields();
            this.enableFields(false);
            return;
        }
        this.enableFields(true);
        if (updateFields) {
            this.nameTextField.setText(selected.getName());
            this.optionsTextField.setText(selected.getOptions());
            this.tasksComboBox.setSelectedItem(selected.getTasks());
            this.parametersTextField.setText(selected.getParameters());
            this.sharedCheckBox.setSelected(selected.isShared());
        }
        this.validateTask(selected);
        this.setPreview(selected);
    }

    private void validateTask(AdvancedTask task) {
        assert (EventQueue.isDispatchThread());
        assert (task != null);
        this.descriptor.getNotificationLineSupport().clearMessages();
        this.invalidTasks.remove(task);
        if (!StringUtilities.hasText(task.getName())) {
            this.invalidTasks.add(task);
            this.descriptor.getNotificationLineSupport().setErrorMessage(Bundle.AdvancedTasksPanel_error_name_empty());
        } else if (!this.invalidTasks.isEmpty()) {
            this.descriptor.getNotificationLineSupport().setErrorMessage(Bundle.AdvancedTasksPanel_error_other());
        }
        this.descriptor.setValid(this.descriptor.getNotificationLineSupport().getErrorMessage() == null);
    }

    private void setPreview(AdvancedTask task) {
        assert (EventQueue.isDispatchThread());
        assert (task != null);
        this.previewTextField.setText(this.buildToolExec + " " + task.getFullCommand());
    }

    private void enableFields(boolean enable) {
        assert (EventQueue.isDispatchThread());
        this.nameTextField.setEnabled(enable);
        this.optionsTextField.setEnabled(enable);
        this.tasksComboBox.setEnabled(enable);
        this.parametersTextField.setEnabled(enable);
        this.sharedCheckBox.setEnabled(enable);
    }

    private void clearFields() {
        assert (EventQueue.isDispatchThread());
        this.nameTextField.setText(null);
        this.optionsTextField.setText(null);
        this.tasksComboBox.setSelectedIndex(0);
        this.parametersTextField.setText(null);
        this.previewTextField.setText(null);
    }

    private void handleActionButtons() {
        int[] selectedIndices = this.getSelectedIndices();
        boolean selected = selectedIndices.length > 0;
        this.removeButton.setEnabled(selected);
        this.upButton.setEnabled(selected && Arrays.binarySearch(selectedIndices, 0) < 0);
        this.downButton.setEnabled(selected && Arrays.binarySearch(selectedIndices, this.tasks.size() - 1) < 0);
    }

    private AdvancedTask addNewTask() {
        AdvancedTask task = new AdvancedTask().setName(Bundle.AdvancedTasksPanel_task_new());
        this.tasks.add(task);
        this.tasksListModel.fireChange();
        return task;
    }

    private void initComponents() {
        this.showSimpleTasksCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.tasksPanel = new JPanel();
        this.tasksScrollPane = new JScrollPane();
        this.tasksList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.detailsPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.separator = new JSeparator();
        this.optionsLabel = new JLabel();
        this.optionsTextField = new JTextField();
        this.tasksLabel = new JLabel();
        this.tasksComboBox = new JComboBox();
        this.parametersLabel = new JLabel();
        this.parametersTextField = new JTextField();
        this.previewLabel = new JLabel();
        this.previewTextField = new JTextField();
        this.sharedCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.showSimpleTasksCheckBox, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.showSimpleTasksCheckBox.text"));
        this.tasksList.setMinimumSize(new Dimension(60, 80));
        this.tasksScrollPane.setViewportView(this.tasksList);
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/clientproject/ui/resources/add.png")));
        this.addButton.setToolTipText(NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.addButton.toolTipText"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedTasksPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/clientproject/ui/resources/remove.png")));
        this.removeButton.setToolTipText(NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.removeButton.toolTipText"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedTasksPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/clientproject/ui/resources/up.png")));
        this.upButton.setToolTipText(NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.upButton.toolTipText"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedTasksPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/clientproject/ui/resources/down.png")));
        this.downButton.setToolTipText(NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.downButton.toolTipText"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedTasksPanel.this.downButtonActionPerformed(evt);
            }
        });
        GroupLayout tasksPanelLayout = new GroupLayout(this.tasksPanel);
        this.tasksPanel.setLayout(tasksPanelLayout);
        tasksPanelLayout.setHorizontalGroup(tasksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tasksPanelLayout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.tasksScrollPane, -2, 0, Short.MAX_VALUE));
        tasksPanelLayout.linkSize(0, this.addButton, this.downButton, this.removeButton, this.upButton);
        tasksPanelLayout.setVerticalGroup(tasksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tasksPanelLayout.createSequentialGroup().addComponent(this.tasksScrollPane, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tasksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tasksPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton)).addGroup(GroupLayout.Alignment.TRAILING, tasksPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upButton).addComponent(this.downButton)))));
        this.splitPane.setLeftComponent(this.tasksPanel);
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.nameLabel.text"));
        this.optionsLabel.setLabelFor(this.optionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.optionsLabel.text"));
        this.tasksLabel.setLabelFor(this.tasksComboBox);
        Mnemonics.setLocalizedText((JLabel)this.tasksLabel, (String)"TASKS:");
        this.tasksComboBox.setEditable(true);
        this.parametersLabel.setLabelFor(this.parametersTextField);
        Mnemonics.setLocalizedText((JLabel)this.parametersLabel, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.parametersLabel.text"));
        this.previewLabel.setLabelFor(this.previewTextField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.previewLabel.text"));
        this.previewTextField.setEditable(false);
        this.sharedCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.sharedCheckBox, (String)NbBundle.getMessage(AdvancedTasksPanel.class, (String)"AdvancedTasksPanel.sharedCheckBox.text"));
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersLabel).addComponent(this.tasksLabel).addComponent(this.optionsLabel).addComponent(this.previewLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsTextField).addComponent(this.parametersTextField).addComponent(this.previewTextField).addComponent(this.tasksComboBox, 0, 401, Short.MAX_VALUE).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.sharedCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.nameTextField))).addComponent(this.separator)).addContainerGap()));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.optionsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tasksLabel).addComponent(this.tasksComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parametersLabel).addComponent(this.parametersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previewTextField, -2, -1, -2).addComponent(this.previewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sharedCheckBox).addContainerGap(96, Short.MAX_VALUE)));
        this.splitPane.setRightComponent(this.detailsPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        this.tasksList.setSelectedValue(this.addNewTask(), true);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedIndices = this.getSelectedIndices();
        this.tasksList.removeSelectionInterval(0, this.tasks.size());
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            this.tasks.remove(selectedIndices[i]);
        }
        this.tasksListModel.fireChange();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedIndices = this.getSelectedIndices();
        int[] newlySelectedIndices = new int[selectedIndices.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            int selectedIndex = selectedIndices[i];
            AdvancedTask tmp = this.tasks.get(selectedIndex - 1);
            this.tasks.set(selectedIndex - 1, this.tasks.get(selectedIndex));
            this.tasks.set(selectedIndex, tmp);
            newlySelectedIndices[i] = selectedIndex - 1;
        }
        this.tasksListModel.fireChange();
        this.tasksList.setSelectedIndices(newlySelectedIndices);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedIndices = this.getSelectedIndices();
        int[] newlySelectedIndices = new int[selectedIndices.length];
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            int selectedIndex = selectedIndices[i];
            AdvancedTask tmp = this.tasks.get(selectedIndex + 1);
            this.tasks.set(selectedIndex + 1, this.tasks.get(selectedIndex));
            this.tasks.set(selectedIndex, tmp);
            newlySelectedIndices[i] = selectedIndex + 1;
        }
        this.tasksListModel.fireChange();
        this.tasksList.setSelectedIndices(newlySelectedIndices);
    }

    private static final class AdvancedTaskListModel
    extends AbstractListModel<AdvancedTask> {
        private final List<AdvancedTask> tasks;

        public AdvancedTaskListModel(List<AdvancedTask> tasks) {
            assert (EventQueue.isDispatchThread());
            assert (tasks != null);
            this.tasks = tasks;
        }

        @Override
        public int getSize() {
            assert (EventQueue.isDispatchThread());
            return this.tasks.size();
        }

        @Override
        public AdvancedTask getElementAt(int index) {
            assert (EventQueue.isDispatchThread());
            return this.tasks.get(index);
        }

        void fireChange() {
            this.fireContentsChanged(this, 0, this.tasks.size() - 1);
        }

        void fireChange(AdvancedTask task) {
            int index = this.tasks.indexOf(task);
            this.fireContentsChanged(this, index, index);
        }
    }

    private final class AdvancedTaskListCellRenderer
    implements ListCellRenderer<AdvancedTask> {
        private final ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

        private AdvancedTaskListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AdvancedTask> list, AdvancedTask task, int index, boolean isSelected, boolean cellHasFocus) {
            assert (EventQueue.isDispatchThread());
            String name = task.getName();
            if (!StringUtilities.hasText(name)) {
                name = Bundle.AdvancedTaskListCellRenderer_name_invalid();
            }
            if (!task.isShared()) {
                name = Bundle.AdvancedTaskListCellRenderer_name_private(name);
            }
            if (AdvancedTasksPanel.this.invalidTasks.contains(task)) {
                name = "<html><font color=\"red\">" + name + "</font></html>";
            }
            return this.defaultRenderer.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
        }
    }

    private abstract class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AdvancedTask selectedTask = AdvancedTasksPanel.this.getSelectedTask();
            if (selectedTask != null) {
                this.updateTask(selectedTask);
            }
            AdvancedTasksPanel.this.taskChanged(false);
        }

        abstract void updateTask(AdvancedTask var1);
    }

    private abstract class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedTask selectedTask = AdvancedTasksPanel.this.getSelectedTask();
            if (selectedTask != null) {
                this.updateTask(selectedTask);
            }
            AdvancedTasksPanel.this.taskChanged(false);
        }

        abstract void updateTask(AdvancedTask var1);
    }

    private abstract class DocumentListenerImpl
    implements DocumentListener {
        private DocumentListenerImpl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            AdvancedTask selectedTask = AdvancedTasksPanel.this.getSelectedTask();
            if (selectedTask != null) {
                this.updateTask(selectedTask);
            }
            AdvancedTasksPanel.this.taskChanged(false);
        }

        abstract void updateTask(AdvancedTask var1);
    }
}

