/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TwigSyntax {
    private static final int END_PREFIX_LENGTH = "end".length();
    public static final Set<String> BLOCK_MACROS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("if", "for", "block", "set", "macro", "filter", "autoescape", "spaceless", "embed", "raw", "verbatim", "sandbox", "trans")));
    public static final Set<String> ELSE_MACROS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("elseif", "else")));
    public static final Map<String, Set<String>> RELATED_MACROS = Collections.unmodifiableMap(new HashMap<String, Set<String>>(){
        {
            this.put("if", new HashSet<String>(Arrays.asList("else", "elseif")));
            this.put("for", new HashSet<String>(Arrays.asList("else")));
        }
    });

    private TwigSyntax() {
    }

    public static boolean isBlockMacro(String macro) {
        assert (macro != null);
        String macroName = macro.toLowerCase();
        return !macroName.isEmpty() && (BLOCK_MACROS.contains(macroName) || macroName.length() > END_PREFIX_LENGTH && BLOCK_MACROS.contains(macroName.substring(END_PREFIX_LENGTH)) || ELSE_MACROS.contains(macroName));
    }

    public static boolean isElseMacro(String macro) {
        assert (macro != null);
        String macroName = macro.toLowerCase();
        return ELSE_MACROS.contains(macroName);
    }

    public static boolean isRelatedMacro(String actualMacro, String relatedToMacro) {
        assert (actualMacro != null && actualMacro.length() > 0);
        assert (relatedToMacro != null);
        return actualMacro.length() > END_PREFIX_LENGTH && actualMacro.substring(END_PREFIX_LENGTH).equals(relatedToMacro) || RELATED_MACROS.get(relatedToMacro) != null && RELATED_MACROS.get(relatedToMacro).contains(actualMacro);
    }
}

