/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

public final class ConfigUtils {
    public static final String DISPLAY_NAME_PROP = "display.name";

    public static FileObject createConfigFile(FileObject projectRoot, final String name, final EditableProperties props) throws IOException {
        final File f = new File(projectRoot.getPath() + "/nbproject/configs");
        final FileObject[] config = new FileObject[1];
        projectRoot.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject configs = FileUtil.createFolder((File)f);
                String freeName = FileUtil.findFreeFileName((FileObject)configs, (String)name, (String)"properties");
                config[0] = configs.createData(freeName + ".properties");
                try (OutputStream outputStream = config[0].getOutputStream();){
                    props.store(outputStream);
                }
            }
        });
        return config[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceToken(FileObject fo, Map<String, String> map) throws IOException {
        if (fo == null) {
            return;
        }
        FileLock lock = fo.lock();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)fo)), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    line = line.replace(entry.getKey(), entry.getValue());
                }
                sb.append(line);
                sb.append("\n");
            }
            OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), StandardCharsets.UTF_8);
            try {
                writer.write(sb.toString());
            }
            finally {
                writer.close();
                reader.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public static void replaceTokens(FileObject dir, Map<String, String> map, String ... files) throws IOException {
        for (String file : files) {
            ConfigUtils.replaceToken(dir.getFileObject(file), map);
        }
    }
}

