/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.MethodElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field.DelegateFieldAnalizer;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.openide.util.NbBundle;

public class DelegateMethodAnalyzer
implements MethodElementAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        List<? extends VariableElement> parameters = element.getParameters();
        int i = 0;
        for (VariableElement variableElement : parameters) {
            if (cancel.get()) {
                return;
            }
            if (AnnotationUtil.hasAnnotation(variableElement, "jakarta.decorator.Delegate", result.getInfo())) {
                result.requireCdiEnabled(element);
                if (cancel.get()) {
                    return;
                }
                this.checkMethodDefinition(element, variableElement, result);
                if (cancel.get()) {
                    return;
                }
                this.checkClassDefinition(parent, element, variableElement, result);
                if (cancel.get()) {
                    return;
                }
                this.checkDelegateType(variableElement, i, element, parent, result);
                VariableElement var = CdiEditorAnalysisFactory.resolveParameter(variableElement, element, result.getInfo());
                EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
                if (helper != null) {
                    helper.addInjectionPoint(result, var);
                }
            }
            ++i;
        }
    }

    private void checkClassDefinition(TypeElement parent, ExecutableElement element, VariableElement param, CdiAnalysisResult result) {
        if (!AnnotationUtil.hasAnnotation(parent, "jakarta.decorator.Decorator", result.getInfo())) {
            result.addError(param, NbBundle.getMessage(DelegateFieldAnalizer.class, (String)"ERR_DelegateIsNotInDecorator"));
        }
    }

    private void checkDelegateType(VariableElement element, int i, ExecutableElement method, TypeElement parent, CdiAnalysisResult result) {
        ExecutableType methodType = (ExecutableType)result.getInfo().getTypes().asMemberOf((DeclaredType)parent.asType(), method);
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        TypeMirror parameterType = parameterTypes.get(i);
        Collection<TypeMirror> decoratedTypes = DelegateFieldAnalizer.getDecoratedTypes(parent, result.getInfo());
        for (TypeMirror decoratedType : decoratedTypes) {
            if (result.getInfo().getTypes().isSubtype(parameterType, decoratedType)) continue;
            result.addError(element, NbBundle.getMessage(DelegateMethodAnalyzer.class, (String)"ERR_DelegateTypeHasNoDecoratedType"));
            return;
        }
    }

    private void checkMethodDefinition(ExecutableElement element, VariableElement param, CdiAnalysisResult result) {
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return;
        }
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.inject.Inject", result.getInfo())) {
            result.addError(param, NbBundle.getMessage(DelegateMethodAnalyzer.class, (String)"ERR_WrongDelegateMethod"));
        }
    }
}

