/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.Bundle;
import org.netbeans.modules.java.source.parsing.FastJar;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class CachingArchive
implements Archive,
FileChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CachingArchive.class.getName());
    private final File archiveFile;
    private final boolean keepOpened;
    private final String pathToRootInArchive;
    private ZipFile zipFile;
    byte[] names;
    private int nameOffset = 0;
    static final int[] EMPTY = new int[0];
    private Map<String, Folder> folders;
    private volatile Boolean multiRelease;

    public CachingArchive(@NonNull File archiveFile, boolean keepOpened) {
        this(archiveFile, null, keepOpened);
    }

    public CachingArchive(@NonNull File archiveFile, @NullAllowed String pathToRootInArchive, boolean keepOpened) {
        Parameters.notNull((CharSequence)"archiveFile", (Object)archiveFile);
        if (pathToRootInArchive != null) {
            if (!keepOpened) {
                throw new UnsupportedOperationException(String.format("FastJar not supported for relocated root of archive %s, relocation %s", archiveFile.getAbsolutePath(), pathToRootInArchive));
            }
            if (pathToRootInArchive.charAt(pathToRootInArchive.length() - 1) != '/') {
                throw new IllegalArgumentException(String.format("Path to root: %s has to end with /", pathToRootInArchive));
            }
        }
        this.archiveFile = archiveFile;
        this.pathToRootInArchive = pathToRootInArchive;
        this.keepOpened = keepOpened;
        FileUtil.addFileChangeListener((FileChangeListener)this, (File)FileUtil.normalizeFile((File)archiveFile));
    }

    @Override
    @NonNull
    public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
        Map<String, Folder> folders = this.doInit();
        assert (!this.keepOpened || this.zipFile != null);
        if (recursive) {
            ArrayList<JavaFileObject> collector = new ArrayList<JavaFileObject>();
            Predicate<String> isPkg = folder -> {
                int start;
                for (int i = start = folderName.length(); i < folder.length(); ++i) {
                    if ('/' != folder.charAt(i)) continue;
                    String name = folder.substring(start, i);
                    if (!name.isEmpty() && !SourceVersion.isIdentifier(name)) {
                        return false;
                    }
                    start = i + 1;
                }
                String name = folder.substring(start);
                return name.isEmpty() || SourceVersion.isIdentifier(name);
            };
            folders.entrySet().stream().filter(e -> {
                String fld = (String)e.getKey();
                if (folderName.isEmpty() && isPkg.test(fld)) {
                    return true;
                }
                return fld.startsWith(folderName) && (fld.length() == folderName.length() || fld.charAt(folderName.length()) == '/') && isPkg.test(fld);
            }).forEach(e -> this.listFolder((Folder)e.getValue(), (String)e.getKey(), kinds, collector));
            return collector;
        }
        Folder files = folders.get(folderName);
        return files == null ? Collections.emptyList() : this.listFolder(files, folderName, kinds, null);
    }

    @Override
    public JavaFileObject create(String relativePath, JavaFileFilterImplementation filter) {
        throw new UnsupportedOperationException("Write into archives not supported");
    }

    @Override
    public synchronized void clear() {
        this.folders = null;
        this.names = null;
        this.nameOffset = 0;
        this.multiRelease = null;
    }

    @Override
    public JavaFileObject getFile(@NonNull String name) {
        String sn;
        String folder;
        Map<String, Folder> folders = this.doInit();
        int index = name.lastIndexOf(47);
        if (index <= 0) {
            folder = "";
            sn = name;
        } else {
            folder = name.substring(0, index);
            sn = name.substring(index + 1);
        }
        Folder files = folders.get(folder);
        if (files == null) {
            return null;
        }
        assert (!this.keepOpened || this.zipFile != null);
        NameIs predicate = new NameIs(sn);
        for (int i = 0; i < files.idx; i += files.delta) {
            JavaFileObject fo = this.create(folder, files, i, predicate);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @Override
    public URI getDirectory(String dirName) throws IOException {
        Map<String, Folder> folders = this.doInit();
        if (folders.containsKey(dirName)) {
            URI zipURI = BaseUtilities.toURI((File)this.archiveFile);
            return FileObjects.getZipPathURI(zipURI, dirName);
        }
        return null;
    }

    public String toString() {
        return String.format("%s[archive: %s]", this.getClass().getSimpleName(), this.archiveFile.getAbsolutePath());
    }

    @Override
    public boolean isMultiRelease() {
        Boolean res = this.multiRelease;
        if (res == null) {
            res = Boolean.FALSE;
            JavaFileObject jfo = this.getFile("META-INF/MANIFEST.MF");
            if (jfo != null) {
                try (BufferedInputStream in = new BufferedInputStream(jfo.openInputStream());){
                    res = FileObjects.isMultiVersionArchive(in);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Cannot read: {0} manifest", this.archiveFile.getAbsolutePath());
                }
            }
            this.multiRelease = res;
        }
        return res;
    }

    protected void beforeInit() throws IOException {
    }

    protected short getFlags(@NonNull String dirname) throws IOException {
        return 0;
    }

    protected boolean includes(int flags, String folder, String name) {
        return true;
    }

    protected void afterInit(boolean success) throws IOException {
    }

    protected ZipFile getArchive(short flags) {
        return this.zipFile;
    }

    protected String getPathToRoot(short flags) {
        return this.pathToRootInArchive;
    }

    synchronized Map<String, Folder> doInit() {
        block8: {
            if (this.folders == null) {
                try {
                    boolean success = false;
                    this.beforeInit();
                    try {
                        this.names = new byte[16384];
                        this.folders = this.createMap(this.archiveFile);
                        this.trunc();
                        success = true;
                    }
                    finally {
                        this.afterInit(success);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Broken zip file: {0}", this.archiveFile.getAbsolutePath());
                    LOGGER.log(Level.FINE, null, e);
                    this.names = new byte[0];
                    this.nameOffset = 0;
                    this.folders = new HashMap<String, Folder>();
                    if (this.zipFile == null) break block8;
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Cannot close archive: {0}", this.archiveFile.getAbsolutePath());
                        LOGGER.log(Level.FINE, null, ex);
                    }
                }
            }
        }
        return this.folders;
    }

    private void trunc() {
        assert (Thread.holdsLock(this));
        byte[] newNames = new byte[this.nameOffset];
        System.arraycopy(this.names, 0, newNames, 0, this.nameOffset);
        this.names = newNames;
        Iterator<Folder> it = this.folders.values().iterator();
        while (it.hasNext()) {
            it.next().trunc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Folder> createMap(File file) throws IOException {
        String name;
        if (!file.canRead()) {
            return Collections.emptyMap();
        }
        HashMap<String, Folder> map = null;
        if (!this.keepOpened) {
            map = new HashMap<String, Folder>();
            try {
                Iterable<? extends FastJar.Entry> e = FastJar.list(file);
                for (FastJar.Entry entry : e) {
                    Folder fld;
                    name = entry.name;
                    int i = name.lastIndexOf(47);
                    String dirname = i == -1 ? "" : name.substring(0, i);
                    String basename = name.substring(i + 1);
                    if (basename.length() == 0) {
                        basename = null;
                    }
                    if ((fld = (Folder)map.get(dirname)) == null) {
                        fld = new Folder(true, this.getFlags(dirname));
                        map.put(dirname.intern(), fld);
                    }
                    if (basename == null) continue;
                    fld.appendEntry(this, basename, entry.getTime(), entry.offset);
                }
            }
            catch (IOException ioe) {
                map = null;
                Logger.getLogger(CachingArchive.class.getName()).log(Level.WARNING, "Fallback to ZipFile: {0}", file.getPath());
            }
        }
        if (map == null) {
            map = new HashMap();
            ZipFile zip = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    Folder fld;
                    String basename;
                    String dirname;
                    int i;
                    ZipEntry zipEntry;
                    try {
                        zipEntry = e.nextElement();
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IOException(iae);
                    }
                    catch (ZipError ze) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)((ZipError)Exceptions.attachSeverity((Throwable)ze, (Level)Level.WARNING)), (String)Bundle.ERR_CorruptedZipFile(file)));
                        break;
                    }
                    name = zipEntry.getName();
                    if (this.pathToRootInArchive != null) {
                        if (!name.startsWith(this.pathToRootInArchive)) continue;
                        i = name.lastIndexOf(47);
                        dirname = i < this.pathToRootInArchive.length() ? "" : name.substring(this.pathToRootInArchive.length(), i);
                        basename = name.substring(i + 1);
                    } else {
                        i = name.lastIndexOf(47);
                        dirname = i == -1 ? "" : name.substring(0, i);
                        basename = name.substring(i + 1);
                    }
                    if (basename.length() == 0) {
                        basename = null;
                    }
                    if ((fld = (Folder)map.get(dirname)) == null) {
                        fld = new Folder(false, this.getFlags(dirname));
                        map.put(dirname.intern(), fld);
                    }
                    if (basename == null || !this.includes(fld.flags, dirname, basename)) continue;
                    fld.appendEntry(this, basename, zipEntry.getTime(), -1L);
                }
            }
            finally {
                if (this.keepOpened) {
                    this.zipFile = zip;
                } else {
                    try {
                        zip.close();
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        }
        return map;
    }

    private synchronized String getString(int off, int len) {
        if (this.names == null) {
            return null;
        }
        byte[] name = new byte[len];
        System.arraycopy(this.names, off, name, 0, len);
        return new String(name, StandardCharsets.UTF_8);
    }

    static long join(int higher, int lower) {
        return (long)higher << 32 | (long)lower & 0xFFFFFFFFL;
    }

    private JavaFileObject create(@NonNull String pkg, @NonNull Folder f, @NonNull int off, @NonNull Predicate<String> predicate) {
        String baseName = this.getString(f.indices[off], f.indices[off + 1]);
        if (baseName != null && predicate.test(baseName)) {
            long mtime = CachingArchive.join(f.indices[off + 3], f.indices[off + 2]);
            if (this.zipFile == null) {
                if (f.delta == 4) {
                    return FileObjects.zipFileObject(this.archiveFile, pkg, baseName, mtime);
                }
                assert (f.delta == 6);
                long offset = CachingArchive.join(f.indices[off + 5], f.indices[off + 4]);
                return FileObjects.zipFileObject(this.archiveFile, pkg, baseName, mtime, offset);
            }
            return FileObjects.zipFileObject(this.getArchive(f.flags), this.getPathToRoot(f.flags), pkg, baseName, mtime);
        }
        return null;
    }

    @NonNull
    private List<JavaFileObject> listFolder(@NonNull Folder files, @NonNull String folderName, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed List<JavaFileObject> collector) {
        if (collector == null) {
            collector = new ArrayList<JavaFileObject>(files.idx / files.delta);
        }
        Predicate<String> predicate = kinds == null ? new Tautology() : new HasKind(kinds);
        for (int i = 0; i < files.idx; i += files.delta) {
            JavaFileObject fo = this.create(folderName, files, i, predicate);
            if (fo == null) continue;
            collector.add(fo);
        }
        return collector;
    }

    synchronized int putName(byte[] name) {
        int start = this.nameOffset;
        if (start + name.length > this.names.length) {
            byte[] newNames = new byte[this.names.length * 2 + name.length];
            System.arraycopy(this.names, 0, newNames, 0, start);
            this.names = newNames;
        }
        System.arraycopy(name, 0, this.names, start, name.length);
        this.nameOffset += name.length;
        return start;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.clear();
    }

    public void fileChanged(FileEvent fe) {
        this.clear();
    }

    public void fileDeleted(FileEvent fe) {
        this.clear();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.clear();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private static class Folder {
        int[] indices = EMPTY;
        int idx = 0;
        final short flags;
        final short delta;

        public Folder(boolean fastJar, short flags) {
            this.delta = fastJar ? (short)6 : (short)4;
            this.flags = flags;
        }

        void appendEntry(CachingArchive outer, String name, long mtime, long offset) {
            if (this.idx + this.delta > this.indices.length) {
                int[] newInd = new int[2 * this.indices.length + this.delta];
                System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                this.indices = newInd;
            }
            byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
            this.indices[this.idx++] = outer.putName(bytes);
            this.indices[this.idx++] = bytes.length;
            this.indices[this.idx++] = (int)(mtime & 0xFFFFFFFFFFFFFFFFL);
            this.indices[this.idx++] = (int)(mtime >> 32);
            if (this.delta == 6) {
                this.indices[this.idx++] = (int)(offset & 0xFFFFFFFFFFFFFFFFL);
                this.indices[this.idx++] = (int)(offset >> 32);
            }
        }

        void trunc() {
            if (this.indices.length > this.idx) {
                int[] newInd = new int[this.idx];
                System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                this.indices = newInd;
            }
        }
    }

    private static class NameIs
    implements Predicate<String> {
        private final String name;

        private NameIs(@NonNull String name) {
            Parameters.notNull((CharSequence)"name", (Object)name);
            this.name = name;
        }

        @Override
        public boolean test(@NonNull String value) {
            return this.name.equals(value);
        }
    }

    private static class Tautology
    implements Predicate<String> {
        private Tautology() {
        }

        @Override
        public boolean test(@NonNull String value) {
            return true;
        }
    }

    private static class HasKind
    implements Predicate<String> {
        private final Set<JavaFileObject.Kind> kinds;

        private HasKind(@NonNull Set<JavaFileObject.Kind> kinds) {
            Parameters.notNull((CharSequence)"kinds", kinds);
            this.kinds = kinds;
        }

        @Override
        public boolean test(@NonNull String value) {
            return this.kinds.contains((Object)FileObjects.getKind(FileObjects.getExtension(value)));
        }
    }
}

