/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.io.IOException;
import java.util.ArrayList;
import jdk.jshell.JShell;
import jdk.jshell.spi.ExecutionControlProvider;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.launch.JShellConnection;
import org.netbeans.modules.jshell.launch.RemoteJShellAccessor;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.netbeans.modules.jshell.support.ShellSession;
import org.openide.windows.InputOutput;

class ProjectShellEnv
extends JShellEnvironment {
    private final ShellAgent agent;
    private final String startupMode;

    public ProjectShellEnv(ShellAgent agent, Project project, String displayName, String startupMode) {
        super(project, displayName);
        this.agent = agent;
        this.startupMode = startupMode;
    }

    @Override
    protected InputOutput createInputOutput() {
        return this.agent.getIO();
    }

    @Override
    public JShell.Builder customizeJShell(JShell.Builder b) {
        b = super.customizeJShell(b);
        JavaPlatform pl = ShellProjectUtils.findPlatform(this.getProject());
        if (!ShellProjectUtils.isModularJDK(pl)) {
            return b;
        }
        ArrayList<String> addReads = new ArrayList<String>();
        addReads.add("--add-reads:java.jshell=ALL-UNNAMED");
        return b.remoteVMOptions((String[])addReads.toArray(String[]::new));
    }

    @Override
    public ExecutionControlProvider createExecutionEnv() {
        try {
            RemoteJShellAccessor accessor = this.agent.createRemoteService();
            CloseNotifier nf = new CloseNotifier(accessor, this.getSession());
            ShellLaunchManager.getInstance().addLaunchListener(nf);
            return accessor;
        }
        catch (IOException ex) {
            return null;
        }
    }

    ShellAgent getAgent() {
        return this.agent;
    }

    @Override
    public String getMode() {
        return this.startupMode;
    }

    private class CloseNotifier
    implements ShellLaunchListener {
        private final RemoteJShellAccessor accessor;
        private final ShellSession session;
        private boolean closed;

        public CloseNotifier(RemoteJShellAccessor accessor, ShellSession session) {
            this.accessor = accessor;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ShellLaunchEvent ev) {
            JShellConnection c = ev.getConnection();
            CloseNotifier closeNotifier = this;
            synchronized (closeNotifier) {
                if (this.closed || c != this.accessor.getOpenedConnection()) {
                    return;
                }
                this.closed = true;
            }
            ProjectShellEnv.this.notifyDisconnected(this.session, ev.isRemoteClose());
            ShellLaunchManager.getInstance().removeLaunchListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void agentDestroyed(ShellLaunchEvent ev) {
            CloseNotifier closeNotifier = this;
            synchronized (closeNotifier) {
                if (this.closed || ev.getAgent() != ProjectShellEnv.this.agent) {
                    return;
                }
                this.closed = true;
            }
            ProjectShellEnv.this.notifyShutdown(true);
            ShellLaunchManager.getInstance().removeLaunchListener(this);
        }

        @Override
        public void connectionInitiated(ShellLaunchEvent ev) {
        }

        @Override
        public void handshakeCompleted(ShellLaunchEvent ev) {
        }
    }
}

