/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.newproject;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.gradle.newproject.Bundle;
import org.netbeans.modules.gradle.newproject.NewProjectSettings;
import org.netbeans.modules.gradle.spi.newproject.GradleInitWizard;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class GradleInitPanelVisual
extends JPanel {
    private boolean packageNameChanged = false;
    private String packageSuffix;
    private final DocumentListener fieldUpdater = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            GradleInitPanelVisual.this.updateTextFields(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GradleInitPanelVisual.this.updateTextFields(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            GradleInitPanelVisual.this.updateTextFields(e);
        }
    };
    private JButton btBrowse;
    private JCheckBox cbComments;
    private JComboBox<GradleInitWizard.GradleDSL> cbDSL;
    private JComboBox<Integer> cbJavaVersion;
    private JComboBox<GradleInitWizard.TestFramework> cbTestFramework;
    private JLabel lbDSL;
    private JLabel lbJavaVersion;
    private JLabel lbLocation;
    private JLabel lbPackageName;
    private JLabel lbProjectFolder;
    private JLabel lbProjectName;
    private JLabel lbTestFramework;
    private JTextField tfLocation;
    private JTextField tfPackageName;
    private JTextField tfProjectFolder;
    private JTextField tfProjectName;

    public GradleInitPanelVisual() {
        this.initComponents();
        this.cbDSL.setModel(new DefaultComboBoxModel<GradleInitWizard.GradleDSL>(GradleInitWizard.GradleDSL.values()));
        this.tfProjectName.getDocument().addDocumentListener(this.fieldUpdater);
        this.tfLocation.getDocument().addDocumentListener(this.fieldUpdater);
        this.tfPackageName.getDocument().addDocumentListener(this.fieldUpdater);
    }

    private void initComponents() {
        this.lbProjectName = new JLabel();
        this.tfProjectName = new JTextField();
        this.lbLocation = new JLabel();
        this.tfLocation = new JTextField();
        this.btBrowse = new JButton();
        this.lbProjectFolder = new JLabel();
        this.tfProjectFolder = new JTextField();
        this.lbPackageName = new JLabel();
        this.tfPackageName = new JTextField();
        this.lbJavaVersion = new JLabel();
        this.cbJavaVersion = new JComboBox();
        this.lbTestFramework = new JLabel();
        this.cbTestFramework = new JComboBox();
        this.lbDSL = new JLabel();
        this.cbDSL = new JComboBox();
        this.cbComments = new JCheckBox();
        this.lbProjectName.setLabelFor(this.tfProjectName);
        Mnemonics.setLocalizedText((JLabel)this.lbProjectName, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbProjectName.text"));
        this.lbLocation.setLabelFor(this.tfLocation);
        Mnemonics.setLocalizedText((JLabel)this.lbLocation, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbLocation.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btBrowse, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.btBrowse.text"));
        this.btBrowse.setActionCommand(NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.btBrowse.actionCommand"));
        this.btBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradleInitPanelVisual.this.btBrowseActionPerformed(evt);
            }
        });
        this.lbProjectFolder.setLabelFor(this.tfProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.lbProjectFolder, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbProjectFolder.text"));
        this.tfProjectFolder.setEditable(false);
        this.lbPackageName.setLabelFor(this.tfPackageName);
        Mnemonics.setLocalizedText((JLabel)this.lbPackageName, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbPackageName.text"));
        this.lbJavaVersion.setLabelFor(this.cbJavaVersion);
        Mnemonics.setLocalizedText((JLabel)this.lbJavaVersion, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbJavaVersion.text"));
        this.lbTestFramework.setLabelFor(this.cbTestFramework);
        Mnemonics.setLocalizedText((JLabel)this.lbTestFramework, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbTestFramework.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbDSL, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.lbDSL.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbComments, (String)NbBundle.getMessage(GradleInitPanelVisual.class, (String)"GradleInitPanelVisual.cbComments.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbPackageName, -1, -1, Short.MAX_VALUE).addComponent(this.lbJavaVersion, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbLocation, -1, -1, Short.MAX_VALUE).addComponent(this.lbProjectFolder, -1, -1, Short.MAX_VALUE).addComponent(this.lbProjectName, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.lbTestFramework, -1, 141, Short.MAX_VALUE).addComponent(this.lbDSL, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.cbDSL, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.cbComments)).addComponent(this.cbJavaVersion, GroupLayout.Alignment.LEADING, 0, 291, Short.MAX_VALUE).addComponent(this.tfLocation, GroupLayout.Alignment.LEADING).addComponent(this.tfProjectName, GroupLayout.Alignment.LEADING).addComponent(this.tfProjectFolder, GroupLayout.Alignment.LEADING).addComponent(this.tfPackageName, GroupLayout.Alignment.LEADING).addComponent(this.cbTestFramework, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btBrowse).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbProjectName).addComponent(this.tfProjectName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbLocation).addComponent(this.tfLocation, -2, -1, -2).addComponent(this.btBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbProjectFolder).addComponent(this.tfProjectFolder, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfPackageName, -2, -1, -2).addComponent(this.lbPackageName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbJavaVersion, -2, -1, -2).addComponent(this.lbJavaVersion)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTestFramework, -2, -1, -2).addComponent(this.lbTestFramework)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbComments).addComponent(this.lbDSL).addComponent(this.cbDSL, -2, -1, -2)).addContainerGap(54, Short.MAX_VALUE)));
    }

    private void btBrowseActionPerformed(ActionEvent evt) {
        if ("BROWSE".equals(evt.getActionCommand())) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(null);
            chooser.setDialogTitle(Bundle.TIT_Select_Project_Location());
            chooser.setFileSelectionMode(1);
            String path = this.tfLocation.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.tfLocation.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
        }
    }

    void read(WizardDescriptor settings) {
        NewProjectSettings newproject = NewProjectSettings.getDefault();
        File loc = (File)settings.getProperty("projdir");
        if (loc == null || loc.getParentFile() == null || !loc.getParentFile().isDirectory()) {
            loc = ProjectChooser.getProjectsFolder();
        }
        this.tfLocation.setText(loc.getAbsolutePath());
        String name = (String)settings.getProperty("name");
        name = name != null ? name : GradleInitPanelVisual.firstAvailableName(loc, "gradleproject");
        this.tfProjectName.setText(name);
        String packageBase = (String)settings.getProperty("packageBase");
        if (packageBase != null) {
            this.tfPackageName.setText(packageBase);
        } else {
            String packagePrefix = newproject.getPackagePrefix();
            this.tfPackageName.setText(packagePrefix + name);
        }
        this.adjustPackageBase();
        if (settings.getProperty("javaVersions") != null) {
            List javaVersions = (List)settings.getProperty("javaVersions");
            DefaultComboBoxModel<Integer> versionModel = new DefaultComboBoxModel<Integer>(javaVersions.toArray(new Integer[0]));
            this.cbJavaVersion.setModel(versionModel);
            if (settings.getProperty("javaVersion") != null) {
                this.cbJavaVersion.setSelectedItem(settings.getProperty("javaVersion"));
            }
        } else {
            this.lbJavaVersion.setVisible(false);
            this.cbJavaVersion.setVisible(false);
        }
        if (settings.getProperty("testFrameworks") != null) {
            List testframeworks = (List)settings.getProperty("testFrameworks");
            DefaultComboBoxModel<GradleInitWizard.TestFramework> frameworkModel = new DefaultComboBoxModel<GradleInitWizard.TestFramework>(testframeworks.toArray(new GradleInitWizard.TestFramework[0]));
            this.cbTestFramework.setModel(frameworkModel);
            if (settings.getProperty("testFramework") != null) {
                this.cbTestFramework.setSelectedItem(settings.getProperty("testFramework"));
            }
        } else {
            this.lbTestFramework.setVisible(false);
            this.cbTestFramework.setVisible(false);
        }
        GradleInitWizard.GradleDSL dsl = (GradleInitWizard.GradleDSL)((Object)settings.getProperty("DSL"));
        this.cbDSL.setSelectedItem((Object)(dsl != null ? dsl : newproject.getGradleDSL()));
        Boolean comments = (Boolean)settings.getProperty("comments");
        this.cbComments.setSelected(comments != null ? comments.booleanValue() : newproject.getGenerateComments());
        this.tfProjectName.selectAll();
    }

    void write(WizardDescriptor settings) {
        NewProjectSettings newproject = NewProjectSettings.getDefault();
        File projectFolder = new File(this.tfLocation.getText());
        ProjectChooser.setProjectsFolder((File)projectFolder);
        settings.putProperty("projdir", (Object)projectFolder);
        settings.putProperty("name", (Object)this.tfProjectName.getText());
        if (this.tfPackageName.isVisible()) {
            String pkg = this.tfPackageName.getText();
            settings.putProperty("packageBase", (Object)pkg);
            String derivedPackage = this.derivedPackage();
            if (pkg.endsWith(derivedPackage)) {
                String prefix = pkg.substring(0, pkg.length() - derivedPackage.length());
                newproject.setPackagePrefix(prefix);
            }
        }
        if (settings.getProperty("javaVersions") != null) {
            settings.putProperty("javaVersion", this.cbJavaVersion.getSelectedItem());
        }
        if (settings.getProperty("testFrameworks") != null) {
            settings.putProperty("testFramework", this.cbTestFramework.getSelectedItem());
        }
        settings.putProperty("DSL", this.cbDSL.getSelectedItem());
        newproject.setGradleDSL((GradleInitWizard.GradleDSL)((Object)this.cbDSL.getSelectedItem()));
        settings.putProperty("comments", (Object)this.cbComments.isSelected());
        newproject.setGenerateComments(this.cbComments.isSelected());
    }

    private static String firstAvailableName(File dir, String baseName) {
        String name;
        File folder;
        int index = 1;
        while ((folder = new File(dir, name = baseName + String.valueOf(index++))).exists()) {
        }
        return name;
    }

    private void updateTextFields(DocumentEvent e) {
        Document doc = e.getDocument();
        if (this.tfProjectName.getDocument() == doc || this.tfLocation.getDocument() == doc) {
            File location = new File(this.tfLocation.getText());
            if (location.isDirectory()) {
                this.tfProjectFolder.setText(this.tfLocation.getText() + File.separator + this.tfProjectName.getText());
            } else {
                this.tfProjectFolder.setText(this.tfLocation.getText());
            }
        }
        if (!this.packageNameChanged && this.tfProjectName.getDocument() == doc) {
            this.tfPackageName.getDocument().removeDocumentListener(this.fieldUpdater);
            this.adjustPackageBase();
            this.tfPackageName.getDocument().addDocumentListener(this.fieldUpdater);
        }
        if (this.tfProjectName.getDocument() == doc) {
            this.firePropertyChange("projectName", null, this.tfProjectName.getText());
        }
    }

    private String derivedPackage() {
        return this.tfProjectName.getText().replace('_', '.').replace('-', '.');
    }

    private void adjustPackageBase() {
        String derivedPackage = this.derivedPackage();
        String pkg = this.tfPackageName.getText();
        if (this.packageSuffix != null && pkg.endsWith(this.packageSuffix)) {
            String newPkg = pkg.substring(0, pkg.length() - this.packageSuffix.length()) + derivedPackage;
            this.tfPackageName.setText(newPkg);
        }
        this.packageSuffix = derivedPackage;
    }
}

