/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.helpers.PublicId;
import org.apache.xml.resolver.readers.SAXCatalogParser;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.debug = catalog.getCatalogManager().debug;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public XCatalogReader() {
    }

    public XCatalogReader(SAXParserFactory sAXParserFactory, Catalog catalog) {
        super(sAXParserFactory);
        this.setCatalog(catalog);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block15: {
            int n = -1;
            Vector<String> vector = new Vector<String>();
            if (string2.equals("Base")) {
                n = Catalog.BASE;
                vector.add(attributes.getValue("HRef"));
                this.debug.message(4, "Base", attributes.getValue("HRef"));
            } else if (string2.equals("Delegate")) {
                n = Catalog.DELEGATE_PUBLIC;
                vector.add(attributes.getValue("PublicID"));
                vector.add(attributes.getValue("HRef"));
                this.debug.message(4, "Delegate", PublicId.normalize(attributes.getValue("PublicID")), attributes.getValue("HRef"));
            } else if (string2.equals("Extend")) {
                n = Catalog.CATALOG;
                vector.add(attributes.getValue("HRef"));
                this.debug.message(4, "Extend", attributes.getValue("HRef"));
            } else if (string2.equals("Map")) {
                n = Catalog.PUBLIC;
                vector.add(attributes.getValue("PublicID"));
                vector.add(attributes.getValue("HRef"));
                this.debug.message(4, "Map", PublicId.normalize(attributes.getValue("PublicID")), attributes.getValue("HRef"));
            } else if (string2.equals("Remap")) {
                n = Catalog.SYSTEM;
                vector.add(attributes.getValue("SystemID"));
                vector.add(attributes.getValue("HRef"));
                this.debug.message(4, "Remap", attributes.getValue("SystemID"), attributes.getValue("HRef"));
            } else if (!string2.equals("XCatalog")) {
                this.debug.message(1, "Invalid catalog entry type", string2);
            }
            if (n >= 0) {
                try {
                    CatalogEntry catalogEntry = new CatalogEntry(n, vector);
                    this.catalog.addEntry(catalogEntry);
                }
                catch (CatalogException catalogException) {
                    if (catalogException.getExceptionType() == 3) {
                        this.debug.message(1, "Invalid catalog entry type", string2);
                    }
                    if (catalogException.getExceptionType() != 2) break block15;
                    this.debug.message(1, "Invalid catalog entry", string2);
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }
}

