/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadGroupImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.modules.debugger.jpda.util.WeakCacheMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DebuggingViewSupportImpl
extends DebuggingView.DVSupport {
    private final JPDADebuggerImpl debugger;
    private final Map<JPDAThreadImpl, JPDADVThread> threadsMap = new WeakCacheMap();
    private final Map<JPDAThreadGroupImpl, JPDADVThreadGroup> threadGroupsMap = new WeakCacheMap();
    private static Preferences preferences;

    public DebuggingViewSupportImpl(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        ChangeListener chl = new ChangeListener();
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)chl);
        this.debugger.addPropertyChangeListener("currentThread", (PropertyChangeListener)chl);
        this.debugger.getThreadsCollector().addPropertyChangeListener((PropertyChangeListener)chl);
        this.debugger.getThreadsCollector().getDeadlockDetector().addPropertyChangeListener((PropertyChangeListener)chl);
    }

    public DebuggingView.DVThread getCurrentThread() {
        JPDAThreadImpl currentThread = (JPDAThreadImpl)this.debugger.getCurrentThread();
        if (!(currentThread == null || currentThread.isSuspended() || currentThread.isSuspendedNoFire() || currentThread.isMethodInvoking())) {
            currentThread = null;
        }
        return this.get((JPDAThread)currentThread);
    }

    public DebuggingView.DVSupport.STATE getState() {
        int state = this.debugger.getState();
        if (state == 4) {
            return DebuggingView.DVSupport.STATE.DISCONNECTED;
        }
        return DebuggingView.DVSupport.STATE.RUNNING;
    }

    public List<DebuggingView.DVThread> getAllThreads() {
        List threads = this.debugger.getThreadsCollector().getAllThreads();
        ArrayList<JPDADVThread> dvThreads = new ArrayList<JPDADVThread>(threads.size());
        for (JPDAThread t : threads) {
            dvThreads.add(this.get(t));
        }
        return Collections.unmodifiableList(dvThreads);
    }

    public String getDisplayName(DebuggingView.DVThread thread) {
        String name;
        try {
            JPDAThreadImpl jt = ((JPDADVThread)thread).getKey();
            name = DebuggingNodeModel.getDisplayName((JPDAThread)jt, false);
            Session session = this.debugger.getSession();
            Session currSession = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (session != currSession) {
                String str = NbBundle.getMessage(DebuggingViewSupportImpl.class, (String)"CTL_Session", (Object)session.getName());
                name = name.charAt(0) + str + ", " + name.substring(1);
            }
        }
        catch (UnknownTypeException e) {
            name = thread.getName();
        }
        return name;
    }

    public Image getIcon(DebuggingView.DVThread thread) {
        return ImageUtilities.loadImage((String)DebuggingNodeModel.getIconBase((JPDAThread)((JPDADVThread)thread).getKey()));
    }

    public Session getSession() {
        return this.debugger.getSession();
    }

    public void resume() {
        this.debugger.resume();
    }

    public Set<DebuggingView.Deadlock> getDeadlocks() {
        Set dds = this.debugger.getThreadsCollector().getDeadlockDetector().getDeadlocks();
        if (dds == null) {
            return null;
        }
        HashSet<DebuggingView.Deadlock> dvds = new HashSet<DebuggingView.Deadlock>(dds.size());
        for (DeadlockDetector.Deadlock dd : dds) {
            Collection threads = dd.getThreads();
            dvds.add(this.createDeadlock(threads));
        }
        return dvds;
    }

    protected List<DebuggingView.DVFilter> getFilters() {
        ArrayList<DebuggingView.DVFilter> list = new ArrayList<DebuggingView.DVFilter>();
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showSuspendedThreadsOnly));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showThreadGroups));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showSuspendTable));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showSystemThreads));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showMonitors));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showQualifiedNames));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.sortSuspend));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.sortAlphabetic));
        list.add(DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.sortNatural));
        return list;
    }

    public static Preferences getFilterPreferences() {
        if (preferences == null) {
            preferences = DebuggingView.DVFilter.getDefault((DebuggingView.DVFilter.DefaultFilter)DebuggingView.DVFilter.DefaultFilter.showThreadGroups).getPreferences();
        }
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDADVThread get(JPDAThread t) {
        JPDADVThread dvt;
        if (t == null) {
            return null;
        }
        Map<JPDAThreadImpl, JPDADVThread> map = this.threadsMap;
        synchronized (map) {
            dvt = this.threadsMap.get(t);
            if (dvt == null) {
                dvt = new JPDADVThread(this, (JPDAThreadImpl)t);
                this.threadsMap.put((JPDAThreadImpl)t, dvt);
            }
        }
        return dvt;
    }

    public JPDADVThread[] get(JPDAThread[] threads) {
        int n = threads.length;
        JPDADVThread[] dvThreads = new JPDADVThread[n];
        for (int i = 0; i < n; ++i) {
            dvThreads[i] = this.get((JPDAThread)((JPDAThreadImpl)threads[i]));
        }
        return dvThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDADVThreadGroup get(JPDAThreadGroup tg) {
        JPDADVThreadGroup dvtg;
        if (tg == null) {
            return null;
        }
        Map<JPDAThreadGroupImpl, JPDADVThreadGroup> map = this.threadGroupsMap;
        synchronized (map) {
            dvtg = this.threadGroupsMap.get(tg);
            if (dvtg == null) {
                dvtg = new JPDADVThreadGroup(this, (JPDAThreadGroupImpl)tg);
                this.threadGroupsMap.put((JPDAThreadGroupImpl)tg, dvtg);
            }
        }
        return dvtg;
    }

    public JPDADVThreadGroup[] get(JPDAThreadGroup[] threadGroups) {
        int n = threadGroups.length;
        JPDADVThreadGroup[] dvGroups = new JPDADVThreadGroup[n];
        for (int i = 0; i < n; ++i) {
            dvGroups[i] = this.get((JPDAThreadGroup)((JPDAThreadGroupImpl)threadGroups[i]));
        }
        return dvGroups;
    }

    protected int getFrameCount(JPDADVThread thread) {
        return thread.getKey().getStackDepth();
    }

    protected List<DebuggingView.DVFrame> getFrames(JPDADVThread thread, int from, int to) {
        return JPDADVThread.getFrames(thread, from, to);
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private DebuggingView.DVSupport.STATE state = DebuggingView.DVSupport.STATE.DISCONNECTED;

        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("threadStarted".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("threadStarted", DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getOldValue())), DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getNewValue())));
            } else if ("threadDied".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("threadDied", DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getOldValue())), DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getNewValue())));
            } else if ("currentThread".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("currentThread", DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getOldValue())), DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getNewValue())));
            } else if ("threadSuspended".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("threadSuspended", DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getOldValue())), DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getNewValue())));
            } else if ("threadResumed".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("threadResumed", DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getOldValue())), DebuggingViewSupportImpl.this.get((JPDAThread)((JPDAThreadImpl)evt.getNewValue())));
            } else if ("state".equals(propertyName)) {
                int ds = DebuggingViewSupportImpl.this.debugger.getState();
                if (ds == 2 && this.state != DebuggingView.DVSupport.STATE.RUNNING) {
                    this.state = DebuggingView.DVSupport.STATE.RUNNING;
                    DebuggingViewSupportImpl.this.firePropertyChange("state", DebuggingView.DVSupport.STATE.DISCONNECTED, DebuggingView.DVSupport.STATE.RUNNING);
                } else if (ds == 4) {
                    DebuggingViewSupportImpl.this.firePropertyChange("state", DebuggingView.DVSupport.STATE.RUNNING, DebuggingView.DVSupport.STATE.DISCONNECTED);
                }
            } else if ("deadlock".equals(propertyName)) {
                DebuggingViewSupportImpl.this.firePropertyChange("deadlock", evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

