/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.actions.JPDADebuggerAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class MakeCallerCurrentActionProvider
extends JPDADebuggerAction {
    private RequestProcessor rp;

    public MakeCallerCurrentActionProvider(ContextProvider lookupProvider) {
        super((JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.rp = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.getDebuggerImpl().addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
    }

    public void doAction(Object action) {
        JPDAThread t = this.getDebuggerImpl().getCurrentThread();
        if (t == null) {
            return;
        }
        int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
        if (i >= t.getStackDepth() - 1) {
            return;
        }
        MakeCallerCurrentActionProvider.setCurrentCallStackFrameIndex(this.getDebuggerImpl(), ++i);
    }

    @Override
    protected void checkEnabled(int debuggerState) {
        JPDAThread t;
        if (debuggerState == 3 && (t = this.getDebuggerImpl().getCurrentThread()) != null) {
            this.checkEnabledLazySingleAction(debuggerState, this.rp);
            return;
        }
        this.setEnabledSingleAction(false);
    }

    @Override
    protected boolean checkEnabledLazyImpl(int debuggerState) {
        int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
        JPDAThread t = this.getDebuggerImpl().getCurrentThread();
        if (t == null) {
            return false;
        }
        return i < t.getStackDepth() - 1;
    }

    static int getCurrentCallStackFrameIndex(JPDADebugger debuggerImpl) {
        JPDAThread t = debuggerImpl.getCurrentThread();
        if (t == null) {
            return -1;
        }
        CallStackFrame csf = debuggerImpl.getCurrentCallStackFrame();
        if (csf == null) {
            return -1;
        }
        return csf.getFrameDepth();
    }

    static void setCurrentCallStackFrameIndex(JPDADebugger debuggerImpl, int index) {
        try {
            JPDAThread t = debuggerImpl.getCurrentThread();
            if (t == null) {
                return;
            }
            if (t.getStackDepth() <= index) {
                return;
            }
            CallStackFrame csf = t.getCallStack(index, index + 1)[0];
            csf.makeCurrent();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }
}

