/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.Collection;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.openide.util.ImageUtilities;

public final class IconsUtils {
    private static final String PNG_EXTENSION = ".png";
    private static final String GIF_EXTENSION = ".gif";
    private static final String ICON_BASE = "org/netbeans/modules/php/editor/resources/";
    private static final String EMPTY_FILE_ICON_BASE = "org/netbeans/modules/csl/source/resources/icons/emptyfile-icon";

    private IconsUtils() {
    }

    public static ImageIcon getElementIcon(PhpElementKind elementKind, Collection<Modifier> modifiers) {
        ImageIcon imageIcon;
        switch (elementKind) {
            case CLASS: {
                imageIcon = IconsUtils.loadClassIcon();
                break;
            }
            case IFACE: {
                imageIcon = IconsUtils.loadInterfaceIcon();
                break;
            }
            case TRAIT: {
                imageIcon = IconsUtils.loadTraitIcon();
                break;
            }
            case ENUM: {
                imageIcon = IconsUtils.loadEnumIcon();
                break;
            }
            case CONSTANT: {
                imageIcon = IconsUtils.loadConstantIcon();
                break;
            }
            case FUNCTION: {
                imageIcon = IconsUtils.loadFunctionIcon();
                break;
            }
            default: {
                imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/emptyfile-icon.png", (boolean)false);
            }
        }
        return imageIcon;
    }

    public static ImageIcon getElementIcon(PhpElementKind elementKind) {
        return IconsUtils.getElementIcon(elementKind, null);
    }

    public static ImageIcon getErrorGlyphIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/error-glyph.gif", (boolean)false);
    }

    public static ImageIcon loadClassIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/class.png", (boolean)false);
    }

    public static ImageIcon loadInterfaceIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/interface.png", (boolean)false);
    }

    public static ImageIcon loadTraitIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/trait.png", (boolean)false);
    }

    public static ImageIcon loadEnumIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/enum.png", (boolean)false);
    }

    public static ImageIcon loadFunctionIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/function.png", (boolean)false);
    }

    public static ImageIcon loadConstantIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/constant.png", (boolean)false);
    }

    public static ImageIcon loadEnumCaseIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/enumCase.png", (boolean)false);
    }

    public static ImageIcon loadKeywordIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/editor/resources/php16Key.png", (boolean)false);
    }
}

