/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.actions.Bundle;
import org.netbeans.modules.php.editor.actions.FixUsesAction;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.GroupUseScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.UnusedUsesCollector;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Pair;

public class FixUsesPerformer {
    private static final Logger LOGGER = Logger.getLogger(FixUsesPerformer.class.getName());
    private static final String NEW_LINE = "\n";
    private static final char SEMICOLON = ';';
    private static final char SPACE = ' ';
    private static final String USE_KEYWORD = "use";
    private static final String USE_PREFIX = "\nuse ";
    private static final String USE_CONST_PREFIX = "\nuse const ";
    private static final String USE_FUNCTION_PREFIX = "\nuse function ";
    private static final String AS_KEYWORD = "as";
    private static final String AS_CONCAT = " as ";
    private static final String EMPTY_STRING = "";
    private static final char COMMA = ',';
    private static final char CURLY_OPEN = '{';
    private static final char CURLY_CLOSE = '}';
    private static final Map<UsePart.Type, Integer> PSR12_TYPE_PRIORITIES = new HashMap<UsePart.Type, Integer>();
    private static final Map<UsePart.Type, Integer> DEFAULT_TYPE_PRIORITIES = new HashMap<UsePart.Type, Integer>();
    private final PHPParseResult parserResult;
    private final ImportData importData;
    private final List<ImportData.ItemVariant> selections;
    private final boolean removeUnusedUses;
    private final FixUsesAction.Options options;
    private EditList editList;
    private BaseDocument baseDocument;

    public FixUsesPerformer(PHPParseResult parserResult, ImportData importData, List<ImportData.ItemVariant> selections, boolean removeUnusedUses, FixUsesAction.Options options) {
        this.parserResult = parserResult;
        this.importData = importData;
        this.selections = selections;
        this.removeUnusedUses = removeUnusedUses;
        this.options = options;
    }

    public void perform() {
        Document document = this.parserResult.getSnapshot().getSource().getDocument(false);
        if (document instanceof BaseDocument) {
            this.baseDocument = (BaseDocument)document;
            this.editList = new EditList(this.baseDocument);
            this.processSelections();
            this.editList.apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSelections() {
        void var9_12;
        List<ImportData.DataItem> dataItems = this.resolveDuplicateSelections();
        assert (this.selections.size() <= dataItems.size()) : "The selections size must not be larger than the dataItems size. selections size: " + this.selections.size() + " > dataItems size: " + dataItems.size();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult, this.importData.caretPosition);
        assert (namespaceScope != null);
        CheckVisitor checkVisitor = new CheckVisitor();
        Program program = this.parserResult.getProgram();
        if (program != null) {
            program.accept(checkVisitor);
        }
        int startOffset = this.getOffset(namespaceScope, this.importData.caretPosition, checkVisitor);
        ArrayList<UsePart> useParts = new ArrayList<UsePart>();
        Collection<? extends GroupUseScope> declaredGroupUses = namespaceScope.getDeclaredGroupUses();
        for (GroupUseScope groupUseScope : declaredGroupUses) {
            for (UseScope useElement : groupUseScope.getUseScopes()) {
                this.processUseElement(useElement, useParts);
            }
        }
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredSingleUses();
        for (UseScope useScope : declaredUses) {
            assert (!useScope.isPartOfGroupUse()) : useScope;
            this.processUseElement(useScope, useParts);
        }
        boolean bl = false;
        while (var9_12 < this.selections.size()) {
            ImportData.ItemVariant itemVariant = this.selections.get((int)var9_12);
            if (itemVariant.canBeUsed()) {
                SanitizedUse sanitizedUse = new SanitizedUse(new UsePart(this.modifyUseName(itemVariant.getName()), UsePart.Type.create(itemVariant.getType()), itemVariant.isFromAliasedElement()), useParts, this.createAliasStrategy((int)var9_12, useParts, this.selections));
                if (sanitizedUse.shouldBeUsed()) {
                    useParts.add(sanitizedUse.getSanitizedUsePart());
                }
                for (UsedNamespaceName usedNamespaceName : dataItems.get((int)var9_12).getUsedNamespaceNames()) {
                    this.editList.replace(usedNamespaceName.getOffset(), usedNamespaceName.getReplaceLength(), sanitizedUse.getReplaceName(usedNamespaceName), false, 0);
                }
            }
            ++var9_12;
        }
        this.replaceUnimportedItems();
        Map<UsePart.Type, Integer> map = this.getTypeOrderPriorities(useParts, checkVisitor.getExistingTypeOrderPriorities());
        String string = this.createInsertString(useParts, map);
        this.insertUses(startOffset, string, checkVisitor);
    }

    private void insertUses(int startOffset, String insertString, CheckVisitor visitor) {
        List<OffsetRange> usedRanges = visitor.getUsedRanges();
        String existingUses = this.getExistingUses(usedRanges);
        if (insertString.isEmpty() || existingUses.equals(insertString.trim())) {
            StatusDisplayer.getDefault().setStatusText(Bundle.FixUsesPerformer_noChanges());
        } else {
            this.processExistingUses(usedRanges);
            this.editList.replace(startOffset, 0, insertString, false, 0);
        }
    }

    private void replaceUnimportedItems() {
        for (ImportData.DataItem dataItem : this.importData.getItemsToReplace()) {
            ImportData.ItemVariant defaultVariant = dataItem.getDefaultVariant();
            for (UsedNamespaceName usedNamespaceName : dataItem.getUsedNamespaceNames()) {
                this.editList.replace(usedNamespaceName.getOffset(), usedNamespaceName.getReplaceLength(), defaultVariant.getName(), false, 0);
            }
        }
    }

    private List<ImportData.DataItem> resolveDuplicateSelections() {
        ArrayList<ImportData.DataItem> dataItems = new ArrayList<ImportData.DataItem>(this.importData.getItems());
        ArrayList<ImportData.ItemVariant> selectionsCopy = new ArrayList<ImportData.ItemVariant>(this.selections);
        ArrayList<Integer> itemIndexesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.selections.size(); ++i) {
            ArrayList<UsedNamespaceName> usedNamespaceNames = new ArrayList<UsedNamespaceName>();
            ImportData.ItemVariant baseVariant = this.selections.get(i);
            if (!baseVariant.canBeUsed()) continue;
            for (int j = i + 1; j < selectionsCopy.size(); ++j) {
                ImportData.ItemVariant testedVariant = (ImportData.ItemVariant)selectionsCopy.get(j);
                if (!baseVariant.equals(testedVariant) || !itemIndexesToRemove.add(j)) continue;
                ImportData.DataItem duplicateItem = (ImportData.DataItem)dataItems.get(j);
                usedNamespaceNames.addAll(duplicateItem.getUsedNamespaceNames());
            }
            if (usedNamespaceNames.isEmpty()) continue;
            ((ImportData.DataItem)dataItems.get(i)).addUsedNamespaceNames(usedNamespaceNames);
        }
        Collections.sort(itemIndexesToRemove);
        Collections.reverse(itemIndexesToRemove);
        Iterator iterator = itemIndexesToRemove.iterator();
        while (iterator.hasNext()) {
            int itemIndexToRemove = (Integer)iterator.next();
            this.selections.remove(itemIndexToRemove);
            dataItems.remove(itemIndexToRemove);
        }
        return dataItems;
    }

    private AliasStrategy createAliasStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
        AliasStrategyImpl createAliasStrategy = this.options.aliasesCapitalsOfNamespaces() ? new CapitalsStrategy(selectionIndex, existingUseParts, selections) : new UnqualifiedNameStrategy(selectionIndex, existingUseParts, selections);
        return createAliasStrategy;
    }

    private void processUseElement(UseScope useElement, List<UsePart> useParts) {
        if (this.isUsed(useElement) || !this.removeUnusedUses) {
            AliasedName aliasedName = useElement.getAliasedName();
            if (aliasedName != null) {
                useParts.add(new UsePart(this.modifyUseName(aliasedName.getRealName().toString()) + AS_CONCAT + aliasedName.getAliasName(), UsePart.Type.create(useElement.getType())));
            } else {
                useParts.add(new UsePart(this.modifyUseName(useElement.getName()), UsePart.Type.create(useElement.getType())));
            }
        }
    }

    private String modifyUseName(String useName) {
        String result = useName;
        result = this.options.startUseWithNamespaceSeparator() ? (result.startsWith("\\") ? result : "\\" + result) : (result.startsWith("\\") ? result.substring("\\".length()) : result);
        return result;
    }

    private boolean isUsed(UseScope useElement) {
        boolean result = true;
        for (UnusedUsesCollector.UnusedOffsetRanges unusedRange : new UnusedUsesCollector(this.parserResult).collect()) {
            if (!unusedRange.getRangeToVisualise().containsInclusive(useElement.getOffset())) continue;
            result = false;
            break;
        }
        return result;
    }

    private String createInsertString(List<UsePart> useParts, Map<UsePart.Type, Integer> typeOrderPriorities) {
        StringBuilder insertString = new StringBuilder();
        this.sort(useParts, typeOrderPriorities);
        if (!useParts.isEmpty()) {
            insertString.append(NEW_LINE);
        }
        String indentString = null;
        if (this.options.preferGroupUses() || this.options.preferMultipleUseStatementsCombined()) {
            CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
            indentString = IndentUtils.createIndentString((int)codeStyle.getIndentSize(), (boolean)codeStyle.expandTabToSpaces(), (int)codeStyle.getTabSize());
        }
        if (this.options.preferGroupUses() && this.options.getPhpVersion().compareTo((Enum)PhpVersion.PHP_70) >= 0) {
            insertString.append(this.createStringForGroupUse(useParts, indentString, typeOrderPriorities));
        } else if (this.options.preferMultipleUseStatementsCombined()) {
            insertString.append(this.createStringForMultipleUse(useParts, indentString));
        } else {
            insertString.append(this.createStringForCommonUse(useParts));
        }
        return insertString.toString();
    }

    private Map<UsePart.Type, Integer> getTypeOrderPriorities(List<UsePart> useParts, Map<UsePart.Type, Integer> existingTypeOrderPriorities) {
        boolean useExistingOrder = true;
        for (UsePart usePart : useParts) {
            if (existingTypeOrderPriorities.get((Object)usePart.getType()) != null) continue;
            useExistingOrder = false;
            break;
        }
        if (this.options.keepExistingUseTypeOrder() && useExistingOrder) {
            return existingTypeOrderPriorities;
        }
        if (this.options.putInPSR12Order()) {
            return Collections.unmodifiableMap(PSR12_TYPE_PRIORITIES);
        }
        return Collections.unmodifiableMap(DEFAULT_TYPE_PRIORITIES);
    }

    private void sort(List<UsePart> useParts, Map<UsePart.Type, Integer> typePriorities) {
        useParts.sort((u1, u2) -> {
            int result = 0;
            Integer p1 = (Integer)typePriorities.get((Object)u1.getType());
            Integer p2 = (Integer)typePriorities.get((Object)u2.getType());
            if (p1 != null && p2 != null) {
                result = Integer.compare(p1, p2);
            }
            return result == 0 ? u1.getTextPart().compareToIgnoreCase(u2.getTextPart()) : result;
        });
    }

    private String createStringForGroupUse(List<UsePart> useParts, String indentString, Map<UsePart.Type, Integer> typePriorities) {
        ArrayList<UsePart> typeUseParts = new ArrayList<UsePart>(useParts.size());
        ArrayList<UsePart> constUseParts = new ArrayList<UsePart>(useParts.size());
        ArrayList<UsePart> functionUseParts = new ArrayList<UsePart>(useParts.size());
        block5: for (UsePart usePart : useParts) {
            switch (usePart.getType()) {
                case TYPE: {
                    typeUseParts.add(usePart);
                    continue block5;
                }
                case CONST: {
                    constUseParts.add(usePart);
                    continue block5;
                }
                case FUNCTION: {
                    functionUseParts.add(usePart);
                    continue block5;
                }
            }
            assert (false) : "Unknown type: " + (Object)((Object)usePart.getType());
        }
        StringBuilder insertString = new StringBuilder();
        HashMap<String, List<UsePart>> groupUseParts = new HashMap<String, List<UsePart>>();
        groupUseParts.put(USE_PREFIX, typeUseParts);
        groupUseParts.put(USE_CONST_PREFIX, constUseParts);
        groupUseParts.put(USE_FUNCTION_PREFIX, functionUseParts);
        this.createStringForGroupUse(insertString, indentString, groupUseParts, typePriorities);
        return insertString.toString();
    }

    private List<String> usePartsToNamespaces(List<UsePart> useParts) {
        return useParts.stream().map(part -> part.getTextPart()).collect(Collectors.toList());
    }

    private void createStringForGroupUse(StringBuilder insertString, String indentString, Map<String, List<UsePart>> useParts, Map<UsePart.Type, Integer> typePriorities) {
        this.createStringForGroupUse(this.getOrderedUseTypePrefixes(typePriorities), useParts, insertString, indentString);
    }

    private List<String> getOrderedUseTypePrefixes(Map<UsePart.Type, Integer> typePriorities) {
        String[] priorities = new String[typePriorities.size()];
        for (Map.Entry<UsePart.Type, Integer> entry : typePriorities.entrySet()) {
            Integer position = entry.getValue();
            priorities[position.intValue()] = this.getUseTypePrefix(entry.getKey());
        }
        return Arrays.asList(priorities);
    }

    private String getUseTypePrefix(UsePart.Type type) {
        switch (type) {
            case TYPE: {
                return USE_PREFIX;
            }
            case FUNCTION: {
                return USE_FUNCTION_PREFIX;
            }
            case CONST: {
                return USE_CONST_PREFIX;
            }
        }
        assert (false) : "Unkown type: " + (Object)((Object)type);
        return USE_PREFIX;
    }

    private void createStringForGroupUse(List<String> orderedUseTypePrefixes, Map<String, List<UsePart>> useParts, StringBuilder insertString, String indentString) {
        for (String useType : orderedUseTypePrefixes) {
            this.createStringForGroupUse((Pair<String, Map<String, List<UsePart>>>)Pair.of((Object)useType, useParts), insertString, indentString);
        }
    }

    private void createStringForGroupUse(Pair<String, Map<String, List<UsePart>>> useParts, StringBuilder insertString, String indentString) {
        String useType = (String)useParts.first();
        if (!((List)((Map)useParts.second()).get(useType)).isEmpty()) {
            this.appendNewLineBetweenUseTypes(insertString);
        }
        this.createStringForGroupUse(insertString, indentString, useType, (List)((Map)useParts.second()).get(useType));
    }

    private void appendNewLineBetweenUseTypes(StringBuilder insertString) {
        for (int i = 0; i < this.options.getBlankLinesBetweenUseTypes(); ++i) {
            this.appendNewLine(insertString);
        }
    }

    private void appendNewLine(StringBuilder insertString) {
        if (insertString.length() > 0) {
            insertString.append(NEW_LINE);
        }
    }

    private void createStringForGroupUse(StringBuilder insertString, String indentString, String usePrefix, List<UsePart> useParts) {
        ArrayList<UsePart> groupedUseParts = new ArrayList<UsePart>(useParts.size());
        ArrayList<UsePart> nonGroupedUseParts = new ArrayList<UsePart>(useParts.size());
        List<String> prefixes = CodeUtils.getCommonNamespacePrefixes(this.usePartsToNamespaces(useParts));
        String lastGroupUsePrefix = null;
        for (UsePart usePart : useParts) {
            String fqNamespace = CodeUtils.fullyQualifyNamespace(usePart.getTextPart());
            String groupUsePrefix = null;
            for (String prefix : prefixes) {
                if (!fqNamespace.startsWith(prefix)) continue;
                groupUsePrefix = prefix;
                break;
            }
            if (groupUsePrefix != null) {
                if (lastGroupUsePrefix != null && !lastGroupUsePrefix.equals(groupUsePrefix)) {
                    this.processGroupedUseParts(insertString, indentString, usePrefix, lastGroupUsePrefix, groupedUseParts);
                }
                lastGroupUsePrefix = groupUsePrefix;
                this.processNonGroupedUseParts(insertString, indentString, nonGroupedUseParts);
                groupedUseParts.add(usePart);
                continue;
            }
            this.processGroupedUseParts(insertString, indentString, usePrefix, lastGroupUsePrefix, groupedUseParts);
            nonGroupedUseParts.add(usePart);
        }
        this.processNonGroupedUseParts(insertString, indentString, nonGroupedUseParts);
        this.processGroupedUseParts(insertString, indentString, usePrefix, lastGroupUsePrefix, groupedUseParts);
    }

    private void processNonGroupedUseParts(StringBuilder insertString, String indentString, List<UsePart> nonGroupedUseParts) {
        if (nonGroupedUseParts.isEmpty()) {
            return;
        }
        if (this.options.preferMultipleUseStatementsCombined()) {
            insertString.append(this.createStringForMultipleUse(nonGroupedUseParts, indentString));
        } else {
            insertString.append(this.createStringForCommonUse(nonGroupedUseParts));
        }
        nonGroupedUseParts.clear();
    }

    private void processGroupedUseParts(StringBuilder insertString, String indentString, String usePrefix, String groupUsePrefix, List<UsePart> groupedUseParts) {
        if (groupedUseParts.isEmpty()) {
            return;
        }
        assert (groupUsePrefix != null) : groupedUseParts;
        String properGroupUsePrefix = this.modifyUseName(groupUsePrefix);
        insertString.append(usePrefix).append(properGroupUsePrefix).append('{').append(NEW_LINE);
        boolean first = true;
        int prefixLength = properGroupUsePrefix.length();
        for (UsePart groupUsePart : groupedUseParts) {
            if (first) {
                first = false;
            } else {
                insertString.append(',').append(NEW_LINE);
            }
            insertString.append(indentString).append(groupUsePart.getTextPart().substring(prefixLength));
        }
        insertString.append(NEW_LINE).append('}').append(';');
        groupedUseParts.clear();
    }

    private String createStringForMultipleUse(List<UsePart> useParts, String indentString) {
        StringBuilder insertString = new StringBuilder();
        UsePart.Type lastUsePartType = null;
        for (UsePart usePart : useParts) {
            if (lastUsePartType != null) {
                if (lastUsePartType == usePart.getType()) {
                    insertString.append(',').append(NEW_LINE).append(indentString);
                } else {
                    insertString.append(';');
                    this.appendNewLineBetweenUseTypes(insertString);
                }
            }
            if (lastUsePartType != usePart.getType()) {
                lastUsePartType = usePart.getType();
                switch (usePart.getType()) {
                    case TYPE: {
                        insertString.append(USE_PREFIX);
                        break;
                    }
                    case CONST: {
                        insertString.append(USE_CONST_PREFIX);
                        break;
                    }
                    case FUNCTION: {
                        insertString.append(USE_FUNCTION_PREFIX);
                        break;
                    }
                    default: {
                        insertString.append(USE_PREFIX);
                    }
                }
            }
            insertString.append(usePart.getTextPart());
        }
        if (!useParts.isEmpty()) {
            insertString.append(';');
        }
        return insertString.toString();
    }

    private String createStringForCommonUse(List<UsePart> useParts) {
        StringBuilder result = new StringBuilder();
        UsePart.Type lastUseType = null;
        for (UsePart usePart : useParts) {
            if (lastUseType != null && lastUseType != usePart.getType()) {
                this.appendNewLineBetweenUseTypes(result);
            }
            result.append(usePart.getUsePrefix()).append(usePart.getTextPart()).append(';');
            lastUseType = usePart.getType();
        }
        return result.toString();
    }

    private String getExistingUses(List<OffsetRange> usedRanges) {
        String existingUses = EMPTY_STRING;
        if (!usedRanges.isEmpty()) {
            int start = usedRanges.get(0).getStart();
            int end = usedRanges.get(usedRanges.size() - 1).getEnd();
            try {
                existingUses = this.baseDocument.getText(start, end - start);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
            }
        }
        return existingUses;
    }

    private void processExistingUses(List<OffsetRange> usedRanges) {
        for (OffsetRange offsetRange : usedRanges) {
            int startOffset = this.getOffsetWithoutLeadingWhitespaces(offsetRange.getStart());
            this.editList.replace(startOffset, offsetRange.getEnd() - startOffset, EMPTY_STRING, false, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOffsetWithoutLeadingWhitespaces(int startOffset) {
        int result = startOffset;
        this.baseDocument.readLock();
        try {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.baseDocument, startOffset);
            if (ts != null) {
                ts.move(startOffset);
                while (ts.movePrevious() && ((PHPTokenId)ts.token().id()).equals((Object)PHPTokenId.WHITESPACE)) {
                    result = ts.offset();
                }
            }
        }
        finally {
            this.baseDocument.readUnlock();
        }
        return result;
    }

    private int getOffset(NamespaceScope namespaceScope, int caretPosition, CheckVisitor checkVisitor) {
        try {
            ModelElement lastSingleUse = FixUsesPerformer.getLastUse(namespaceScope, false);
            ModelElement lastGroupUse = FixUsesPerformer.getLastUse(namespaceScope, true);
            if (lastSingleUse != null && lastGroupUse != null) {
                if (lastSingleUse.getOffset() > lastGroupUse.getOffset()) {
                    return LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)lastSingleUse.getOffset());
                }
                return LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)lastGroupUse.getNameRange().getEnd());
            }
            if (lastSingleUse != null) {
                return LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)lastSingleUse.getOffset());
            }
            if (lastGroupUse != null) {
                return LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)lastGroupUse.getNameRange().getEnd());
            }
            int offset = LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)namespaceScope.getOffset());
            if (namespaceScope.isDefaultNamespace()) {
                offset = Integer.max(offset, FixUsesPerformer.getFirstPhpTagPosition(this.parserResult, namespaceScope));
            }
            if (namespaceScope.isDefaultNamespace()) {
                List<NamespaceDeclaration> globalNamespaceDeclarations = checkVisitor.getGlobalNamespaceDeclarations();
                if (!globalNamespaceDeclarations.isEmpty()) {
                    offset = globalNamespaceDeclarations.get(0).getBody().getStartOffset() + 1;
                }
                for (NamespaceDeclaration globalNamespace : globalNamespaceDeclarations) {
                    if (globalNamespace.getStartOffset() > caretPosition || caretPosition > globalNamespace.getEndOffset()) continue;
                    offset = globalNamespace.getBody().getStartOffset() + 1;
                    break;
                }
            }
            offset = FixUsesPerformer.processDeclareStatementsOffset(namespaceScope, checkVisitor, offset);
            return offset;
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
            return 0;
        }
    }

    private static int processDeclareStatementsOffset(NamespaceScope namespaceScope, CheckVisitor checkVisitor, int offset) {
        int result = offset;
        int maxDeclareOffset = FixUsesPerformer.getMaxDeclareOffset(namespaceScope, checkVisitor);
        for (DeclareStatement declareStatement : checkVisitor.getDeclareStatements()) {
            if (maxDeclareOffset < declareStatement.getStartOffset()) break;
            result = Math.max(result, declareStatement.getEndOffset());
        }
        return result;
    }

    private static int getMaxDeclareOffset(NamespaceScope namespaceScope, CheckVisitor checkVisitor) {
        int maxDeclareOffset = namespaceScope.getBlockRange().getEnd();
        if (!namespaceScope.getElements().isEmpty()) {
            for (ModelElement modelElement : namespaceScope.getElements()) {
                if (FixUsesPerformer.isInDeclare(modelElement.getOffset(), checkVisitor.getDeclareStatements())) {
                    maxDeclareOffset = FixUsesPerformer.getDeclareEndPosition(modelElement.getOffset(), checkVisitor.getDeclareStatements());
                    continue;
                }
                maxDeclareOffset = modelElement.getOffset();
                break;
            }
        }
        return maxDeclareOffset;
    }

    private static boolean isInDeclare(int offset, List<DeclareStatement> declareStatements) {
        for (DeclareStatement declareStatement : declareStatements) {
            if (!FixUsesPerformer.isInDeclare(offset, declareStatement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInDeclare(int offset, DeclareStatement declareStatement) {
        return declareStatement.getStartOffset() < offset && offset < declareStatement.getEndOffset();
    }

    private static int getDeclareEndPosition(int offset, List<DeclareStatement> declareStatements) {
        for (DeclareStatement declareStatement : declareStatements) {
            if (!FixUsesPerformer.isInDeclare(offset, declareStatement)) continue;
            return declareStatement.getEndOffset();
        }
        return -1;
    }

    @CheckForNull
    private static ModelElement getLastUse(NamespaceScope namespaceScope, boolean group) {
        PhpElement offsetElement = null;
        Collection<Scope> declaredUses = group ? namespaceScope.getDeclaredGroupUses() : namespaceScope.getDeclaredSingleUses();
        for (Scope useElement : declaredUses) {
            if (offsetElement != null && offsetElement.getOffset() >= useElement.getOffset()) continue;
            offsetElement = useElement;
        }
        return offsetElement;
    }

    private static int getFirstPhpTagPosition(PHPParseResult parserResult, NamespaceScope namespaceScope) {
        TokenHierarchy tokenHierarchy;
        TokenSequence<PHPTokenId> ts;
        int startOffset = namespaceScope.getOffset();
        int result = -1;
        if (namespaceScope.isDefaultNamespace() && (ts = LexUtilities.getPHPTokenSequence(tokenHierarchy = parserResult.getSnapshot().getTokenHierarchy(), startOffset)) != null) {
            ts.move(startOffset);
            while (ts.moveNext()) {
                if (ts.token().id() != PHPTokenId.PHP_OPENTAG) continue;
                result = ts.offset() + ts.token().length();
                break;
            }
        }
        return result;
    }

    static {
        DEFAULT_TYPE_PRIORITIES.put(UsePart.Type.TYPE, 0);
        DEFAULT_TYPE_PRIORITIES.put(UsePart.Type.CONST, 1);
        DEFAULT_TYPE_PRIORITIES.put(UsePart.Type.FUNCTION, 2);
        PSR12_TYPE_PRIORITIES.put(UsePart.Type.TYPE, 0);
        PSR12_TYPE_PRIORITIES.put(UsePart.Type.FUNCTION, 1);
        PSR12_TYPE_PRIORITIES.put(UsePart.Type.CONST, 2);
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private final List<DeclareStatement> declareStatements = new ArrayList<DeclareStatement>();
        private final List<NamespaceDeclaration> globalNamespaceDeclarations = new ArrayList<NamespaceDeclaration>();
        private final List<OffsetRange> usedRanges = new LinkedList<OffsetRange>();
        private final Map<UsePart.Type, Integer> existingTypeOrderPriorities = new HashMap<UsePart.Type, Integer>();

        private CheckVisitor() {
        }

        public List<DeclareStatement> getDeclareStatements() {
            return Collections.unmodifiableList(this.declareStatements);
        }

        public List<NamespaceDeclaration> getGlobalNamespaceDeclarations() {
            return Collections.unmodifiableList(this.globalNamespaceDeclarations);
        }

        public List<OffsetRange> getUsedRanges() {
            return Collections.unmodifiableList(this.usedRanges);
        }

        public Map<UsePart.Type, Integer> getExistingTypeOrderPriorities() {
            return Collections.unmodifiableMap(this.existingTypeOrderPriorities);
        }

        @Override
        public void visit(DeclareStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.declareStatements.add(node);
            super.visit(node);
        }

        @Override
        public void visit(NamespaceDeclaration declaration) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (declaration.isBracketed() && declaration.getName() == null) {
                this.globalNamespaceDeclarations.add(declaration);
            }
            super.visit(declaration);
        }

        @Override
        public void visit(UseStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.usedRanges.add(new OffsetRange(node.getStartOffset(), node.getEndOffset()));
            UsePart.Type usePartType = UsePart.Type.create(node.getType());
            Integer priority = this.existingTypeOrderPriorities.get((Object)usePartType);
            if (priority == null) {
                this.existingTypeOrderPriorities.put(usePartType, this.existingTypeOrderPriorities.size());
            }
            super.visit(node);
        }
    }

    private static class SanitizedUse {
        private final UsePart usePartToSanitization;
        private String alias;
        private final boolean shouldBeUsed;

        public SanitizedUse(UsePart usePartToSanitization, List<UsePart> existingUseParts, AliasStrategy createAliasStrategy) {
            this.usePartToSanitization = usePartToSanitization;
            QualifiedName qualifiedName = QualifiedName.create(usePartToSanitization.getTextPart());
            if (!existingUseParts.contains(usePartToSanitization) && !usePartToSanitization.isFromAliasedElement()) {
                this.alias = createAliasStrategy.createAlias(qualifiedName);
                this.shouldBeUsed = true;
            } else {
                this.shouldBeUsed = false;
            }
        }

        public UsePart getSanitizedUsePart() {
            return new UsePart(this.hasAlias() ? this.usePartToSanitization.getTextPart() + FixUsesPerformer.AS_CONCAT + this.alias : this.usePartToSanitization.getTextPart(), this.usePartToSanitization.getType(), this.usePartToSanitization.isFromAliasedElement());
        }

        private boolean hasAlias() {
            return this.alias != null && !this.alias.isEmpty();
        }

        public String getReplaceName(UsedNamespaceName usedNamespaceName) {
            String result = this.hasAlias() ? this.alias : (this.usePartToSanitization.isFromAliasedElement() ? this.usePartToSanitization.getTextPart() : usedNamespaceName.getReplaceName());
            return result;
        }

        public boolean shouldBeUsed() {
            return this.shouldBeUsed;
        }
    }

    private static class UsePart
    implements Comparable<UsePart> {
        private final String textPart;
        private final Type type;
        private final boolean isFromAliasedElement;

        private UsePart(String textPart, Type type, boolean isFromAliasedElement) {
            this.textPart = textPart;
            this.type = type;
            this.isFromAliasedElement = isFromAliasedElement;
        }

        private UsePart(String textPart, Type type) {
            this(textPart, type, false);
        }

        public String getTextPart() {
            return this.textPart;
        }

        public Type getType() {
            return this.type;
        }

        public String getUsePrefix() {
            return this.type.getUsePrefix();
        }

        public boolean isFromAliasedElement() {
            return this.isFromAliasedElement;
        }

        @Override
        public int compareTo(UsePart other) {
            int result = 0;
            if (Type.TYPE.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 0;
            } else if (Type.TYPE.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.TYPE.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = 0;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = 0;
            }
            return result == 0 ? this.getTextPart().compareToIgnoreCase(other.getTextPart()) : result;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.textPart);
            hash = 71 * hash + Objects.hashCode((Object)this.type);
            hash = 71 * hash + (this.isFromAliasedElement ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsePart other = (UsePart)obj;
            if (!Objects.equals(this.textPart, other.textPart)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.isFromAliasedElement == other.isFromAliasedElement;
        }

        public String toString() {
            return "UsePart{" + (Object)((Object)this.type) + " " + this.textPart + '}';
        }

        static abstract class Type
        extends Enum<Type> {
            public static final /* enum */ Type TYPE = new Type(){

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_PREFIX;
                }
            };
            public static final /* enum */ Type CONST = new Type(){

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_CONST_PREFIX;
                }
            };
            public static final /* enum */ Type FUNCTION = new Type(){

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_FUNCTION_PREFIX;
                }
            };
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }

            abstract String getUsePrefix();

            static Type create(ImportData.ItemVariant.Type type) {
                Type result;
                switch (type) {
                    case CLASS: 
                    case INTERFACE: 
                    case TRAIT: 
                    case ENUM: {
                        result = TYPE;
                        break;
                    }
                    case CONST: {
                        result = CONST;
                        break;
                    }
                    case FUNCTION: {
                        result = FUNCTION;
                        break;
                    }
                    default: {
                        result = TYPE;
                    }
                }
                return result;
            }

            static Type create(UseScope.Type type) {
                Type result;
                switch (type) {
                    case TYPE: {
                        result = TYPE;
                        break;
                    }
                    case CONST: {
                        result = CONST;
                        break;
                    }
                    case FUNCTION: {
                        result = FUNCTION;
                        break;
                    }
                    default: {
                        result = TYPE;
                    }
                }
                return result;
            }

            static Type create(UseStatement.Type type) {
                Type usePartType = TYPE;
                switch (type) {
                    case TYPE: {
                        usePartType = TYPE;
                        break;
                    }
                    case FUNCTION: {
                        usePartType = FUNCTION;
                        break;
                    }
                    case CONST: {
                        usePartType = CONST;
                        break;
                    }
                    default: {
                        assert (false) : "Unknown Type: " + (Object)((Object)type);
                        break;
                    }
                }
                return usePartType;
            }

            private static /* synthetic */ Type[] $values() {
                return new Type[]{TYPE, CONST, FUNCTION};
            }

            static {
                $VALUES = Type.$values();
            }
        }
    }

    private static interface AliasStrategy {
        public String createAlias(QualifiedName var1);
    }

    private static class CapitalsStrategy
    extends AliasStrategyImpl {
        public CapitalsStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            StringBuilder sb = new StringBuilder();
            for (String segment : qualifiedName.getSegments()) {
                sb.append(Character.toUpperCase(segment.charAt(0)));
            }
            return sb.toString();
        }
    }

    private static class UnqualifiedNameStrategy
    extends AliasStrategyImpl {
        public UnqualifiedNameStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            return qualifiedName.getName();
        }
    }

    private static abstract class AliasStrategyImpl
    implements AliasStrategy {
        private final int selectionIndex;
        private final List<UsePart> existingUseParts;
        private final List<ImportData.ItemVariant> selections;

        public AliasStrategyImpl(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            this.selectionIndex = selectionIndex;
            this.existingUseParts = existingUseParts;
            this.selections = selections;
        }

        @Override
        public String createAlias(QualifiedName qualifiedName) {
            String possibleAliasedName;
            String result = FixUsesPerformer.EMPTY_STRING;
            String newAliasedName = possibleAliasedName = this.getPossibleAliasName(qualifiedName);
            int i = 1;
            while (this.existSelectionWith(newAliasedName, this.selectionIndex) || this.existUseWith(newAliasedName)) {
                result = newAliasedName = possibleAliasedName + ++i;
            }
            return result.isEmpty() && this.mustHaveAlias(qualifiedName) ? possibleAliasedName : result;
        }

        private boolean mustHaveAlias(QualifiedName qualifiedName) {
            String unqualifiedName = qualifiedName.getName();
            return this.existSelectionWith(unqualifiedName, this.selectionIndex) || this.existUseWith(unqualifiedName);
        }

        private boolean existSelectionWith(String name, int selectionIndex) {
            for (int i = selectionIndex + 1; i < this.selections.size(); ++i) {
                if (!this.endsWithName(this.selections.get(i).getName(), name)) continue;
                return true;
            }
            return false;
        }

        private boolean existUseWith(String name) {
            for (UsePart existingUsePart : this.existingUseParts) {
                if (!this.endsWithName(existingUsePart.getTextPart(), name) && !existingUsePart.getTextPart().endsWith(' ' + name)) continue;
                return true;
            }
            return false;
        }

        private boolean endsWithName(String usePart, String name) {
            return usePart.endsWith("\\" + name);
        }

        protected abstract String getPossibleAliasName(QualifiedName var1);
    }
}

