/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.tasklist.impl.OpenTaskAction;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.modules.tasklist.ui.TaskListTableUI;
import org.netbeans.modules.tasklist.ui.TaskListTopComponent;
import org.netbeans.modules.tasklist.ui.Util;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class TaskListTable
extends JTable {
    private TableCellRenderer foldingGroupRenderer;
    private TableCellRenderer groupRenderer;
    private Action defaultAction = new DefaultAction();
    private Action nextTaskAction = new TaskNavigationAction(true);
    private Action prevTaskAction = new TaskNavigationAction(false);
    private static final Icon openedIcon = (Icon)UIManager.get("Tree.expandedIcon");
    private static final Icon closedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
    private static Map<Image, ImageIcon> iconCache = new HashMap<Image, ImageIcon>(10);
    private static final Icon NO_ICON = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 1;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    };
    private static Color unfocusedSelBg = null;
    private static Color unfocusedSelFg = null;

    public TaskListTable() {
        this.setAutoResizeMode(3);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TaskListTable.this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TaskListTable.this.maybePopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = TaskListTable.this.rowAtPoint(e.getPoint());
                if (TaskListTable.this.isFoldingModel()) {
                    FoldingTaskListModel foldingModel = TaskListTable.this.getFoldingModel();
                    if (e.getClickCount() == 2) {
                        if (foldingModel.isGroupRow(row)) {
                            foldingModel.toggleGroupExpanded(row);
                            return;
                        }
                    } else if (e.getClickCount() == 1 && foldingModel.isGroupRow(row)) {
                        TaskListTable.this.maybeExpandGroup(e.getPoint());
                        return;
                    }
                }
                if (e.getClickCount() == 2) {
                    TaskListTable.this.defaultAction.actionPerformed(null);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TaskListTable.this.repaintSelectedRow();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TaskListTable.this.repaintSelectedRow();
            }
        });
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setAutoCreateColumnsFromModel(false);
        int requiredRowHeight = 18 + 2 * this.getIntercellSpacing().height;
        this.setRowHeight(Math.max(this.getRowHeight(), requiredRowHeight));
        InputMap inputMap = this.getInputMap(1);
        Object right = inputMap.get(KeyStroke.getKeyStroke(39, 0));
        Object left = inputMap.get(KeyStroke.getKeyStroke(37, 0));
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "defaultAction");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        ActionMap actionMap = this.getActionMap();
        Action actionLeft = actionMap.get(left);
        Action actionRight = actionMap.get(right);
        actionMap.put(left, new ToggleGroupAction(false, actionLeft));
        actionMap.put(right, new ToggleGroupAction(true, actionRight));
        actionMap.put("defaultAction", this.defaultAction);
        actionMap.put("jumpPrev", this.prevTaskAction);
        actionMap.put("jumpNext", this.nextTaskAction);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                MyTableColumn newColumn = new MyTableColumn(i);
                if (i == 3) {
                    newColumn.setCellRenderer(new LeftDotRenderer());
                } else if (i != 0) {
                    newColumn.setCellRenderer(new TooltipRenderer());
                }
                this.addColumn(newColumn);
            }
        }
    }

    @Override
    public void removeNotify() {
        if (this.getModel() instanceof TaskListModel) {
            this.storeColumnState();
        }
        super.removeNotify();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        MyTableHeader res = new MyTableHeader(this.columnModel);
        res.setTable(this);
        return res;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        if (col == 0) {
            if (this.isFoldingModel() && this.getFoldingModel().isGroupRow(row)) {
                return this.getFoldingGroupRenderer();
            }
            return this.getGroupRenderer();
        }
        return super.getCellRenderer(row, col);
    }

    private void maybePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            e.consume();
            int row = this.rowAtPoint(e.getPoint());
            if (row >= 0) {
                this.getSelectionModel().setSelectionInterval(row, row);
            }
            JPopupMenu popup = Util.createPopup(this);
            popup.show(this, e.getX(), e.getY());
        }
    }

    private TableCellRenderer getFoldingGroupRenderer() {
        if (null == this.foldingGroupRenderer) {
            this.foldingGroupRenderer = new FoldingTaskGroupRenderer();
        }
        return this.foldingGroupRenderer;
    }

    private TableCellRenderer getGroupRenderer() {
        if (null == this.groupRenderer) {
            this.groupRenderer = new TaskGroupRenderer();
        }
        return this.groupRenderer;
    }

    private void maybeExpandGroup(Point point) {
        int row = this.rowAtPoint(point);
        int col = this.columnAtPoint(point);
        if (0 != col) {
            return;
        }
        Rectangle rect = this.getCellRect(row, col, false);
        TableCellRenderer renderer = this.getCellRenderer(row, col);
        this.prepareRenderer(renderer, row, col);
        if (renderer instanceof FoldingTaskGroupRenderer) {
            Icon icon = ((FoldingTaskGroupRenderer)renderer).getIcon();
            rect.grow(0, -(rect.height - openedIcon.getIconHeight()) / 2);
            rect.x = this.getColumnModel().getColumnMargin();
            rect.width = openedIcon.getIconWidth();
            if (rect.contains(point)) {
                FoldingTaskListModel foldingModel = this.getFoldingModel();
                foldingModel.toggleGroupExpanded(row);
            }
        }
    }

    private void storeColumnState() {
        int count = this.getColumnModel().getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            if (!(tc instanceof MyTableColumn)) continue;
            ((MyTableColumn)tc).storeState();
        }
    }

    @Override
    public void setUI(TableUI ui) {
        super.setUI(new TaskListTableUI());
        this.setTableHeader(this.createDefaultTableHeader());
    }

    @Override
    public void setModel(TableModel newModel) {
        if (this.getModel() instanceof TaskListModel && newModel != this.getModel()) {
            this.storeColumnState();
            ((TaskListModel)this.getModel()).detach();
        }
        if (newModel instanceof TaskListModel) {
            ((TaskListModel)newModel).attach();
        }
        super.setModel(newModel);
        this.createDefaultColumnsFromModel();
    }

    private boolean isFoldingModel() {
        return this.getModel() instanceof FoldingTaskListModel;
    }

    private FoldingTaskListModel getFoldingModel() {
        return this.isFoldingModel() ? (FoldingTaskListModel)this.getModel() : null;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int hitRowIndex = this.rowAtPoint(e.getPoint());
        if (this.isFoldingModel() && this.getFoldingModel().isGroupRow(hitRowIndex)) {
            return this.getFoldingModel().getGroupAtRow(hitRowIndex).getGroup().getDescription();
        }
        return super.getToolTipText(e);
    }

    Task getSelectedTask() {
        int selRow = this.getSelectedRow();
        if (selRow < 0) {
            return null;
        }
        return ((TaskListModel)this.getModel()).getTaskAtRow(selRow);
    }

    int getSortColumn() {
        return ((TaskListModel)this.getModel()).getSortingColumnn();
    }

    void setSortColumn(int col) {
        ((TaskListModel)this.getModel()).toggleSort(col);
    }

    boolean isAscendingSort() {
        return ((TaskListModel)this.getModel()).isAscendingSort();
    }

    void setAscendingSort(boolean asc) {
        ((TaskListModel)this.getModel()).setAscendingSort(asc);
    }

    private Point getPositionForPopup() {
        int selRow = this.getSelectedRow();
        if (selRow < 0) {
            return null;
        }
        Rectangle rect = this.getCellRect(selRow, 0, true);
        if (rect == null) {
            return null;
        }
        return new Point(0, rect.y + rect.height);
    }

    @Override
    public Color getSelectionBackground() {
        if (!(this.hasFocus() || TaskListTable.isNimbus() || TaskListTable.isGTK())) {
            return TaskListTable.getUnfocusedSelectionBackground();
        }
        return UIManager.getColor("Table.selectionBackground");
    }

    @Override
    public Color getSelectionForeground() {
        if (!(this.hasFocus() || TaskListTable.isNimbus() || TaskListTable.isGTK())) {
            return TaskListTable.getUnfocusedSelectionForeground();
        }
        return UIManager.getColor("Table.selectionForeground");
    }

    private void repaintSelectedRow() {
        int selRow = this.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        Rectangle rect = this.getCellRect(selRow, 0, true);
        Rectangle rect2 = this.getCellRect(selRow, this.getColumnCount() - 1, true);
        rect.width = rect2.x + rect2.width;
        this.repaint(rect);
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    private class DefaultAction
    extends AbstractAction {
        private DefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Task t = TaskListTable.this.getSelectedTask();
            if (null != t) {
                Action a = Util.getDefaultAction(t);
                if (a.isEnabled()) {
                    a.actionPerformed(null);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private class TaskNavigationAction
    extends AbstractAction {
        private boolean navigateToNextTask;

        public TaskNavigationAction(boolean navigateToNextTask) {
            super(navigateToNextTask ? NbBundle.getMessage(TaskListTable.class, (String)"LBL_NextTask") : NbBundle.getMessage(TaskListTable.class, (String)"LBL_PrevTask"));
            this.navigateToNextTask = navigateToNextTask;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (0 == TaskListTable.this.getModel().getRowCount()) {
                return;
            }
            int currentRow = TaskListTable.this.getSelectedRow();
            if (currentRow < 0) {
                currentRow = 0;
            } else if (!TaskListTable.this.isFoldingModel() || !TaskListTable.this.getFoldingModel().isGroupRow(currentRow)) {
                currentRow += this.navigateToNextTask ? 1 : -1;
            }
            TaskListModel tlm = (TaskListModel)TaskListTable.this.getModel();
            while (true) {
                FoldingTaskListModel.FoldingGroup fg;
                if (currentRow < 0) {
                    currentRow = tlm.getRowCount() - 1;
                } else if (currentRow >= tlm.getRowCount()) {
                    currentRow = 0;
                }
                Task t = tlm.getTaskAtRow(currentRow);
                if (null != t) {
                    TaskListTable.this.getSelectionModel().setSelectionInterval(currentRow, currentRow);
                    TaskListTable.this.scrollRectToVisible(TaskListTable.this.getCellRect(currentRow, 0, true));
                    OpenTaskAction a = new OpenTaskAction(t);
                    if (a.isEnabled()) {
                        a.actionPerformed(e);
                        break;
                    }
                    TaskListTopComponent.findInstance().requestActive();
                    break;
                }
                if (TaskListTable.this.isFoldingModel() && !(fg = TaskListTable.this.getFoldingModel().getGroupAtRow(currentRow)).isExpanded()) {
                    fg.setExpanded(true);
                }
                currentRow += this.navigateToNextTask ? 1 : -1;
            }
        }
    }

    private class PopupAction
    extends AbstractAction {
        public PopupAction() {
            super("Popup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point p = TaskListTable.this.getPositionForPopup();
            if (p == null) {
                p = new Point(0, 0);
            }
            JPopupMenu popup = Util.createPopup(TaskListTable.this);
            popup.show(TaskListTable.this, p.x, p.y);
        }

        @Override
        public boolean isEnabled() {
            return TaskListTable.this.isFocusOwner();
        }
    }

    private class ToggleGroupAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean expand;

        public ToggleGroupAction(boolean expand, Action defaultAction) {
            this.defaultAction = defaultAction;
            this.expand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TaskListTable.this.isFoldingModel()) {
                FoldingTaskListModel.FoldingGroup group;
                FoldingTaskListModel foldingModel = TaskListTable.this.getFoldingModel();
                int selRow = TaskListTable.this.getSelectedRow();
                if (selRow >= 0 && null != (group = foldingModel.getGroupAtRow(selRow)) && group.isExpanded() != this.expand) {
                    group.setExpanded(this.expand);
                    return;
                }
            }
            this.defaultAction.actionPerformed(e);
        }
    }

    private class MyTableColumn
    extends TableColumn {
        private float ratio;

        public MyTableColumn(int index) {
            super(index);
            if (index == 0) {
                this.setWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setMinWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setMaxWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setResizable(false);
            } else {
                switch (this.modelIndex) {
                    case 1: {
                        this.ratio = 0.65f;
                        break;
                    }
                    case 3: {
                        this.ratio = 0.2f;
                        break;
                    }
                    case 2: {
                        this.ratio = 0.1f;
                    }
                }
                this.ratio = Settings.getDefault().getPreferredColumnWidth(index, TaskListTable.this.isFoldingModel(), this.ratio);
            }
        }

        @Override
        public int getPreferredWidth() {
            int idx = this.getModelIndex();
            if (TaskListTable.this.isFoldingModel() && idx == 0) {
                return this.getWidth();
            }
            int totalWidth = TaskListTable.this.getParent().getWidth();
            return (int)((float)totalWidth * this.ratio);
        }

        public void storeState() {
            float totalWidth = TaskListTable.this.getWidth();
            if (totalWidth > 0.0f) {
                this.ratio = (float)this.getWidth() / totalWidth;
                Settings.getDefault().setPreferredColumnWidth(this.getModelIndex(), TaskListTable.this.isFoldingModel(), this.ratio);
            }
        }

        @Override
        public Object getHeaderValue() {
            Object res = super.getHeaderValue();
            if (TaskListTable.isNimbus() && TaskListTable.this.getModel() instanceof TaskListModel && res instanceof String) {
                TaskListModel tlm = (TaskListModel)TaskListTable.this.getModel();
                if (this.getModelIndex() == tlm.getSortingColumnn()) {
                    String name = res.toString();
                    name = tlm.isAscendingSort() ? name + "  \u028c" : name + "  v";
                    res = name;
                }
            }
            return res;
        }
    }

    private static class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private LeftDotRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                int nChars;
                this.setToolTipText(value.toString());
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                for (nChars = cellText.length() - 1; nChars > 0 && (textWidth += fm.charWidth(cellText.charAt(nChars))) <= availableWidth; --nChars) {
                }
                this.setText(dots + cellText.substring(nChars + 1));
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private static class TooltipRenderer
    extends DefaultTableCellRenderer {
        private TooltipRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                this.setToolTipText(cellText);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class MyTableHeader
    extends JTableHeader {
        public MyTableHeader(TableColumnModel model) {
            super(model);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 1) {
                        return;
                    }
                    int column = MyTableHeader.this.columnAtPoint(e.getPoint());
                    if (column > 0 && TaskListTable.this.getModel() instanceof TaskListModel) {
                        ((TaskListModel)TaskListTable.this.getModel()).toggleSort(column);
                        MyTableHeader.this.repaint();
                    }
                }
            });
            this.setReorderingAllowed(false);
        }

        @Override
        public void setDraggedColumn(TableColumn aColumn) {
            if (null != aColumn && aColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(aColumn);
        }

        @Override
        public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
            if (!(defaultRenderer instanceof SortingHeaderRenderer) && !TaskListTable.isNimbus()) {
                defaultRenderer = new SortingHeaderRenderer(defaultRenderer);
            }
            super.setDefaultRenderer(defaultRenderer);
        }

        @Override
        public void setUI(TableHeaderUI ui) {
            super.setUI(ui);
        }

        @Override
        public void setResizingColumn(TableColumn col) {
            if (null != this.getResizingColumn() && null == col) {
                TaskListTable.this.storeColumnState();
            }
            super.setResizingColumn(col);
        }

        @Override
        public JTable getTable() {
            return TaskListTable.this;
        }
    }

    private class FoldingTaskGroupRenderer
    extends DefaultTableCellRenderer {
        private final Color GTK_BK_COLOR = new Color(184, 207, 229);
        private final Color AQUA_BK_COLOR = new Color(225, 235, 240);
        private final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        private final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());

        public FoldingTaskGroupRenderer() {
            UIManager.get("nb.propertysheet");
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res;
            if (TaskListTable.this.getFoldingModel().isGroupRow(row)) {
                // empty if block
            }
            if ((res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel && value instanceof FoldingTaskListModel.FoldingGroup) {
                FoldingTaskListModel.FoldingGroup fg = (FoldingTaskListModel.FoldingGroup)value;
                JLabel renderer = (JLabel)res;
                renderer.setText(fg.getGroup().getDisplayName() + " (" + fg.getTaskCount() + ")");
                Icon treeIcon = fg.isExpanded() ? openedIcon : closedIcon;
                renderer.setIcon(treeIcon);
                renderer.setToolTipText(fg.getGroup().getDescription());
                renderer.setHorizontalAlignment(2);
                if (!isSelected) {
                    renderer.setBackground(this.getBackgroundColor());
                }
            }
            return res;
        }

        public Color getBackgroundColor() {
            if (this.isGTK) {
                return this.GTK_BK_COLOR;
            }
            if (this.isAqua) {
                return this.AQUA_BK_COLOR;
            }
            return UIManager.getColor("PropSheet.setBackground");
        }
    }

    private class TaskGroupRenderer
    extends DefaultTableCellRenderer {
        private TaskGroupRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (res instanceof JLabel && value instanceof TaskGroup) {
                TaskGroup tg = (TaskGroup)value;
                JLabel renderer = (JLabel)res;
                renderer.setText(null);
                ImageIcon icon = (ImageIcon)iconCache.get(tg.getIcon());
                if (null == icon) {
                    icon = new ImageIcon(tg.getIcon());
                    iconCache.put(tg.getIcon(), icon);
                }
                renderer.setIcon(icon);
                renderer.setToolTipText(tg.getDescription());
                renderer.setHorizontalAlignment(4);
            }
            return res;
        }
    }

    private class SortingHeaderRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer origRenderer;
        private static final String SORT_ASC_ICON = "org/netbeans/modules/tasklist/ui/resources/columnsSortedAsc.gif";
        private static final String SORT_DESC_ICON = "org/netbeans/modules/tasklist/ui/resources/columnsSortedDesc.gif";
        private JLabel defaultRenderer;

        SortingHeaderRenderer(TableCellRenderer origRenderer) {
            TableCellRenderer ren;
            this.origRenderer = origRenderer;
            if (TaskListTable.isGTK() && (ren = new JTableHeader().getDefaultRenderer()) instanceof JLabel) {
                this.defaultRenderer = (JLabel)((Object)ren);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (null == table) {
                return new JLabel();
            }
            Component comp = this.origRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                TaskListModel tlm = (TaskListModel)TaskListTable.this.getModel();
                if (column == tlm.getSortingColumnn()) {
                    label.setIcon(this.getProperIcon(!tlm.isAscendingSort()));
                    label.setHorizontalTextPosition(10);
                } else {
                    label.setIcon(NO_ICON);
                }
                if (TaskListTable.isGTK() && null != this.defaultRenderer) {
                    this.defaultRenderer.setText(label.getText());
                    Dimension prefSize = this.defaultRenderer.getPreferredSize();
                    if (prefSize.width > 1 && prefSize.height > 1) {
                        label.setPreferredSize(prefSize);
                    }
                    label.setText(" " + label.getText());
                }
            }
            return comp;
        }

        private ImageIcon getProperIcon(boolean descending) {
            if (descending) {
                return ImageUtilities.loadImageIcon((String)SORT_DESC_ICON, (boolean)false);
            }
            return ImageUtilities.loadImageIcon((String)SORT_ASC_ICON, (boolean)false);
        }
    }
}

