/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class GetterSetterGenerator
extends CodeActionsProvider {
    private static final String GENERATE_GETTER_SETTER = "nbls.java.generate.getter.setter";
    private static final String KIND = "kind";
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String ALL = "all";
    private static final String FIELDS = "fields";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        String name;
        CompilationController info;
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        List only = params.getContext().getOnly();
        boolean all = only != null && only.contains("source");
        Pair<Set<VariableElement>, Set<VariableElement>> pair = GetterSetterGenerator.findMissingGettersSetters((CompilationInfo)info, params.getRange(), all);
        boolean missingGetters = !((Set)pair.first()).isEmpty();
        boolean missingSetters = !((Set)pair.second()).isEmpty();
        String uri = Utils.toUri(info.getFileObject());
        int offset = GetterSetterGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        if (missingGetters) {
            name = ((Set)pair.first()).size() == 1 ? Bundle.DN_GenerateGetterFor(((VariableElement)((Set)pair.first()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateGetters();
            result.add(this.createCodeAction(client, name, all ? "source.generate" : "quickfix", null, "nbls.generate.code", GENERATE_GETTER_SETTER, GetterSetterGenerator.data(1, uri, offset, all, ((Set)pair.first()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel((CompilationInfo)info, variableElement));
                item.setUserData(new CodeActionsProvider.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList()))));
        }
        if (missingSetters) {
            name = ((Set)pair.second()).size() == 1 ? Bundle.DN_GenerateSetterFor(((VariableElement)((Set)pair.second()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateSetters();
            result.add(this.createCodeAction(client, name, all ? "source.generate" : "quickfix", null, "nbls.generate.code", GENERATE_GETTER_SETTER, GetterSetterGenerator.data(2, uri, offset, all, ((Set)pair.second()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel((CompilationInfo)info, variableElement));
                item.setUserData(new CodeActionsProvider.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList()))));
        }
        if (missingGetters && missingSetters) {
            ((Set)pair.first()).retainAll((Collection)pair.second());
            name = ((Set)pair.first()).size() == 1 ? Bundle.DN_GenerateGetterSetterFor(((VariableElement)((Set)pair.first()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateGettersSetters();
            result.add(this.createCodeAction(client, name, all ? "source.generate" : "quickfix", null, "nbls.generate.code", GENERATE_GETTER_SETTER, GetterSetterGenerator.data(0, uri, offset, all, ((Set)pair.first()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel((CompilationInfo)info, variableElement));
                item.setUserData(new CodeActionsProvider.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList()))));
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(GENERATE_GETTER_SETTER);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        JsonObject data = (JsonObject)arguments.get(0);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            String text;
            String title;
            int kind = data.getAsJsonPrimitive(KIND).getAsInt();
            String uri = data.getAsJsonPrimitive(URI).getAsString();
            int offset = data.getAsJsonPrimitive(OFFSET).getAsInt();
            boolean all = data.getAsJsonPrimitive(ALL).getAsBoolean();
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(data.get(FIELDS), QuickPickItem[].class));
            switch (kind) {
                case 1: {
                    title = Bundle.DN_GenerateGetters();
                    text = Bundle.DN_SelectGetters();
                    break;
                }
                case 2: {
                    title = Bundle.DN_GenerateSetters();
                    text = Bundle.DN_SelectSetters();
                    break;
                }
                default: {
                    title = Bundle.DN_GenerateGettersSetters();
                    text = Bundle.DN_SelectGettersSetters();
                }
            }
            if (all && fields.size() > 1) {
                client.showQuickPick(new ShowQuickPickParams(title, text, true, fields)).thenAccept(selected -> {
                    try {
                        future.complete(selected != null && !selected.isEmpty() ? this.generate(kind, uri, offset, (List<QuickPickItem>)selected) : null);
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        future.completeExceptionally(ex);
                    }
                });
            } else {
                future.complete(this.generate(kind, uri, offset, fields));
            }
        }
        catch (JsonSyntaxException | IOException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private WorkspaceEdit generate(int kind, String uri, int offset, List<QuickPickItem> fields) throws IOException, IllegalArgumentException {
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = wc.getTreeUtilities().pathFor(offset);
            tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                List variableElements = fields.stream().map(item -> {
                    CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                    return (VariableElement)data.resolve((CompilationInfo)wc);
                }).collect(Collectors.toList());
                GeneratorUtils.generateGettersAndSetters((WorkingCopy)wc, (TreePath)tp, variableElements, (int)kind, (int)-1);
            }
        }));
        return edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
    }

    private static Pair<Set<VariableElement>, Set<VariableElement>> findMissingGettersSetters(CompilationInfo info, Range range, boolean all) {
        TreePath tp = info.getTreeUtilities().pathFor(GetterSetterGenerator.getOffset(info, range.getStart()));
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        int selectionStart = GetterSetterGenerator.getOffset(info, range.getStart());
        int selectionEnd = GetterSetterGenerator.getOffset(info, range.getEnd());
        ClassTree clazz = (ClassTree)tp.getLeaf();
        HashSet<VariableElement> selectedFields = new HashSet<VariableElement>();
        for (Tree tree : clazz.getMembers()) {
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            int start = (int)info.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree);
            int end = (int)info.getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), tree);
            if (!all && !GetterSetterGenerator.intersects(start, end, selectionStart, selectionEnd)) continue;
            selectedFields.add((VariableElement)info.getTrees().getElement(new TreePath(tp, tree)));
        }
        Pair<Set<VariableElement>, Set<VariableElement>> pair = GetterSetterGenerator.findMissingGettersSetters(info, type);
        ((Set)pair.first()).retainAll(selectedFields);
        ((Set)pair.second()).retainAll(selectedFields);
        return pair;
    }

    private static boolean intersects(int fieldStart, int fieldEnd, int selectionStart, int selectionEnd) {
        return selectionStart <= fieldEnd && selectionEnd >= fieldStart;
    }

    private static Pair<Set<VariableElement>, Set<VariableElement>> findMissingGettersSetters(CompilationInfo info, TypeElement type) {
        LinkedHashSet<VariableElement> missingGetters = new LinkedHashSet<VariableElement>();
        LinkedHashSet<VariableElement> missingSetters = new LinkedHashSet<VariableElement>();
        ElementUtilities eu = info.getElementUtilities();
        CodeStyle codeStyle = CodeStyle.getDefault((FileObject)info.getFileObject());
        for (VariableElement variableElement : ElementFilter.fieldsIn(info.getElements().getAllMembers(type))) {
            boolean hasSetter;
            if ("<error>".contentEquals(variableElement.getSimpleName())) continue;
            boolean hasGetter = eu.hasGetter(type, variableElement, codeStyle);
            boolean bl = hasSetter = variableElement.getModifiers().contains((Object)Modifier.FINAL) || eu.hasSetter(type, variableElement, codeStyle);
            if (!hasGetter) {
                missingGetters.add(variableElement);
            }
            if (hasSetter) continue;
            missingSetters.add(variableElement);
        }
        return Pair.of(missingGetters, missingSetters);
    }

    private static Map<String, Object> data(int kind, String uri, int offset, boolean all, List<QuickPickItem> fields) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KIND, kind);
        data.put(URI, uri);
        data.put(OFFSET, offset);
        data.put(ALL, all);
        data.put(FIELDS, fields);
        return data;
    }
}

