/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.Bundle;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ConnectAction
extends AbstractAction
implements ContextAwareAction,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ConnectAction.class.getName());
    private final DatabaseConnection connection;

    public ConnectAction(DatabaseConnection connection) {
        super(NbBundle.getMessage(ConnectAction.class, (String)"Connect"));
        this.connection = connection;
        if (connection != null) {
            connection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)connection));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.connection == null || this.connection.isConnected()) {
            return;
        }
        new ConnectionDialogDisplayer().showDialog(this.connection, false);
    }

    @Override
    public boolean isEnabled() {
        return this.connection != null && !this.connection.isConnected();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConnectAction((DatabaseConnection)actionContext.lookup(DatabaseConnection.class));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.propertyChange(evt));
        } else {
            this.setEnabled(this.connection != null && !this.connection.isConnected());
        }
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        volatile boolean failed = false;
        final ExceptionListener excListener = new ExceptionListener(){

            @Override
            public void exceptionOccurred(Exception exc) {
                if (exc instanceof DDLException) {
                    LOGGER.log(Level.INFO, null, exc.getCause());
                } else {
                    LOGGER.log(Level.INFO, null, exc);
                }
                String message = null;
                if (exc instanceof ClassNotFoundException) {
                    message = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"EXC_ClassNotFound"), exc.getMessage());
                } else {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(DbUtilities.formatError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exc.getMessage()));
                    if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                        for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                            buffer.append("\n\n").append(sqlEx.getMessage());
                        }
                    }
                    message = buffer.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        };
        private static HelpCtx CONNECT_ACTION_HELPCTX = new HelpCtx(ConnectAction.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showDialog(final DatabaseConnection dbcon, boolean showDialog) {
            String user = dbcon.getUser();
            boolean remember = dbcon.rememberPassword();
            dbcon.addExceptionListener(this.excListener);
            final boolean headless = GraphicsEnvironment.isHeadless();
            if (!this.supportsConnectWithoutUsername(dbcon) && (user == null || !remember) || showDialog) {
                Credentials input;
                if (headless) {
                    input = new CredetialsLine(dbcon);
                } else {
                    ConnectPanel basePanel = new ConnectPanel(this, dbcon);
                    input = new CredetialsUI(basePanel);
                }
                PropertyChangeListener connectionListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if ("state".equals(event.getPropertyName())) {
                            if (event.getNewValue() == DatabaseConnection.State.connecting) {
                                this.fireConnectionStarted();
                            } else if (event.getNewValue() == DatabaseConnection.State.failed) {
                                this.fireConnectionFailed();
                            } else if (event.getNewValue() == DatabaseConnection.State.connected) {
                                this.fireConnectionFinished();
                                dbcon.setSchema(dbcon.getSchema());
                                DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                                if (realDbcon != null) {
                                    realDbcon.setPassword(dbcon.getPassword());
                                    realDbcon.setRememberPassword(dbcon.rememberPassword());
                                }
                                dbcon.setRememberPassword(input.rememberPassword());
                                if (!headless) {
                                    SwingUtilities.invokeLater(() -> {
                                        if (dlg != null) {
                                            dlg.close();
                                        }
                                    });
                                }
                            }
                        }
                    }
                };
                dbcon.addPropertyChangeListener(connectionListener);
                if (headless) {
                    this.connectWithNewInfo(dbcon, input);
                } else {
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (event.getSource() == DialogDescriptor.OK_OPTION) {
                                this.connectWithNewInfo(dbcon, input);
                            }
                        }
                    };
                    Mutex.EVENT.writeAccess(() -> {
                        ConnectPanel basePanel = input.getConnectPanel();
                        this.dlg = new ConnectionDialog(this, basePanel, basePanel.getTitle(), CONNECT_ACTION_HELPCTX, actionListener);
                        this.dlg.setVisible(true);
                        return null;
                    });
                }
                dbcon.removeExceptionListener(this.excListener);
            } else {
                try {
                    Dialog dialog;
                    DialogDescriptor descriptor = null;
                    ProgressHandle progress = null;
                    progress = ProgressHandle.createHandle((String)Bundle.Progress_ConnectingDB(dbcon.getDisplayName()));
                    if (headless) {
                        dialog = null;
                    } else {
                        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progress);
                        progressComponent.setPreferredSize(new Dimension(350, 20));
                        ConnectProgressDialog panel = new ConnectProgressDialog(progressComponent, null);
                        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectAction.class, (String)"ACS_ConnectingDialogTextA11yDesc"));
                        descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConnectAction.class, (String)"ConnectingDialogTitle"), true, new Object[0], null, 0, null, null);
                        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
                    }
                    PropertyChangeListener connectionListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(final PropertyChangeEvent event) {
                            if (headless) {
                                this.handlePropertyChange(event);
                            } else {
                                Mutex.EVENT.readAccess(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.handlePropertyChange(event);
                                    }
                                });
                            }
                        }

                        private void handlePropertyChange(PropertyChangeEvent event) {
                            if ("state".equals(event.getPropertyName())) {
                                if (event.getNewValue() == DatabaseConnection.State.connected) {
                                    if (dialog != null) {
                                        dialog.setVisible(false);
                                    }
                                } else if (event.getNewValue() == DatabaseConnection.State.failed) {
                                    failed = true;
                                    if (dialog != null) {
                                        dialog.setVisible(false);
                                    }
                                }
                            }
                        }
                    };
                    this.failed = false;
                    dbcon.addPropertyChangeListener(connectionListener);
                    try {
                        RequestProcessor.Task connectTask = dbcon.connectAsync();
                        progress.start();
                        progress.switchToIndeterminate();
                        if (dialog == null) {
                            connectTask.waitFinished();
                        } else {
                            dialog.setVisible(true);
                        }
                        progress.finish();
                        if (dialog != null) {
                            dialog.dispose();
                        }
                    }
                    finally {
                        dbcon.removePropertyChangeListener(connectionListener);
                    }
                }
                catch (Exception exc) {
                    String message = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exc.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    this.failed = true;
                }
                dbcon.removeExceptionListener(this.excListener);
                if (this.failed) {
                    this.showDialog(dbcon, true);
                }
            }
        }

        @Override
        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectAction.class, (String)"ConnectionProgress_Schemas"));
            ArrayList<String> schemas = new ArrayList<String>();
            try {
                ResultSet rs;
                DatabaseMetaData dbMetaData = dbcon.getJDBCConnection().getMetaData();
                if (dbMetaData.supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableObtainSchemas", (Object)exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }

        private boolean supportsConnectWithoutUsername(DatabaseConnection dc) {
            try {
                return dc.findJDBCDriver().getClassName().equals("org.sqlite.JDBC") || dc.findJDBCDriver().getClassName().equals("org.h2.Driver");
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        private void connectWithNewInfo(DatabaseConnection dbcon, Credentials input) {
            dbcon.setUser(input.getUser());
            dbcon.setPassword(input.getPassword());
            dbcon.setUser(input.getUser());
            dbcon.setPassword(input.getPassword());
            dbcon.setRememberPassword(input.rememberPassword());
            if (!dbcon.isVitalConnection()) {
                dbcon.connectAsync();
            } else {
                DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                if (realDbcon != null) {
                    realDbcon.setPassword(dbcon.getPassword());
                    realDbcon.setRememberPassword(input.rememberPassword());
                }
                dbcon.setRememberPassword(input.rememberPassword());
                if (this.dlg != null) {
                    this.dlg.close();
                }
            }
        }
    }

    private static class CredentialsCallback
    implements NotifyDescriptor.ComposedInput.Callback {
        private final String initialUser;

        public CredentialsCallback(String user) {
            this.initialUser = user;
        }

        public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
            if (number == 1) {
                NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Bundle.MSG_EnterUsername(), Bundle.MSG_EnterUsername());
                inputLine.setInputText(this.initialUser);
                return inputLine;
            }
            if (number == 2) {
                return new NotifyDescriptor.PasswordLine(Bundle.MSG_EnterPassword(), Bundle.MSG_EnterPassword());
            }
            return null;
        }
    }

    private static class CredetialsUI
    extends Credentials {
        private final ConnectPanel connectPanel;

        private CredetialsUI(ConnectPanel cp) {
            this.connectPanel = cp;
        }

        @Override
        String getPassword() {
            return this.connectPanel.getPassword();
        }

        @Override
        String getUser() {
            return this.connectPanel.getUser();
        }

        @Override
        boolean rememberPassword() {
            return this.connectPanel.rememberPassword();
        }

        @Override
        ConnectPanel getConnectPanel() {
            return this.connectPanel;
        }
    }

    private static class CredetialsLine
    extends Credentials {
        private final DatabaseConnection dbconnection;
        private String user;
        private String password;
        private boolean initialized;

        private CredetialsLine(DatabaseConnection dbconn) {
            this.dbconnection = dbconn;
        }

        private void init() {
            if (!this.initialized) {
                this.initialized = true;
                this.setUsernameAndPassword();
            }
        }

        @Override
        String getUser() {
            this.init();
            return this.user;
        }

        @Override
        String getPassword() {
            this.init();
            return this.password;
        }

        @Override
        boolean rememberPassword() {
            return this.dbconnection.rememberPassword();
        }

        @Override
        ConnectPanel getConnectPanel() {
            throw new IllegalStateException();
        }

        private boolean setUsernameAndPassword() {
            CredentialsCallback callback = new CredentialsCallback(this.dbconnection.getUser());
            NotifyDescriptor.ComposedInput userPassword = new NotifyDescriptor.ComposedInput(this.dbconnection.getDisplayName(), 2, (NotifyDescriptor.ComposedInput.Callback)callback);
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)userPassword)) {
                NotifyDescriptor[] inputs = userPassword.getInputs();
                this.user = ((NotifyDescriptor.InputLine)inputs[0]).getInputText();
                this.password = ((NotifyDescriptor.InputLine)inputs[1]).getInputText();
                return true;
            }
            return false;
        }
    }

    private static abstract class Credentials {
        private Credentials() {
        }

        abstract String getUser();

        abstract String getPassword();

        abstract boolean rememberPassword();

        abstract ConnectPanel getConnectPanel();
    }
}

