/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.NetworkSources;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetNetworkSourceResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private NetworkSources networkSources;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public NetworkSources getNetworkSources() {
        return this.networkSources;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "networkSources"})
    private GetNetworkSourceResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, NetworkSources networkSources) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.networkSources = networkSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",networkSources=").append(String.valueOf((Object)this.networkSources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkSourceResponse)) {
            return false;
        }
        GetNetworkSourceResponse other = (GetNetworkSourceResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.networkSources, (Object)other.networkSources);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.networkSources == null ? 43 : this.networkSources.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetNetworkSourceResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private NetworkSources networkSources;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder networkSources(NetworkSources networkSources) {
            this.networkSources = networkSources;
            return this;
        }

        public Builder copy(GetNetworkSourceResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.networkSources(o.getNetworkSources());
            return this;
        }

        public GetNetworkSourceResponse build() {
            return new GetNetworkSourceResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.networkSources);
        }
    }
}

