/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.netbeans.libs.freemarker.FreemarkerEngine;

public class FreemarkerFactory
implements ScriptEngineFactory {
    private static final List<String> names;
    private static final List<String> extensions;
    private static final List<String> mimeTypes;

    @Override
    public String getEngineName() {
        return "freemarker";
    }

    @Override
    public String getEngineVersion() {
        return "2.3.32";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "freemarker";
    }

    @Override
    public String getLanguageVersion() {
        return "2.3.32";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append("${");
        buf.append(obj);
        buf.append(".");
        buf.append(m);
        buf.append("(");
        if (args.length != 0) {
            int i;
            for (i = 0; i < args.length - 1; ++i) {
                buf.append("$").append(args[i]);
                buf.append(", ");
            }
            buf.append("$").append(args[i]);
        }
        buf.append(")}");
        return buf.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        int len = toDisplay.length();
        buf.append("${context.getWriter().write(\"");
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")}");
        return buf.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            buf.append(statements[i]);
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new FreemarkerEngine(this);
    }

    static {
        ArrayList<String> n = new ArrayList<String>(2);
        n.add("FreeMarker");
        n.add("freemarker");
        names = Collections.unmodifiableList(n);
        ArrayList<String> e = new ArrayList<String>(2);
        e.add("fm");
        e.add("ftl");
        extensions = Collections.unmodifiableList(e);
        ArrayList<String> m = new ArrayList<String>(1);
        m.add("text/x-freemarker");
        mimeTypes = Collections.unmodifiableList(m);
    }
}

