/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteCloudExadataInfrastructureRequest
extends BmcRequest<Void> {
    private String cloudExadataInfrastructureId;
    private String ifMatch;
    private Boolean isDeleteVmClusters;
    private String opcRequestId;

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getIsDeleteVmClusters() {
        return this.isDeleteVmClusters;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cloudExadataInfrastructureId(this.cloudExadataInfrastructureId).ifMatch(this.ifMatch).isDeleteVmClusters(this.isDeleteVmClusters).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",isDeleteVmClusters=").append(String.valueOf(this.isDeleteVmClusters));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteCloudExadataInfrastructureRequest)) {
            return false;
        }
        DeleteCloudExadataInfrastructureRequest other = (DeleteCloudExadataInfrastructureRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.isDeleteVmClusters, other.isDeleteVmClusters) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.isDeleteVmClusters == null ? 43 : this.isDeleteVmClusters.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCloudExadataInfrastructureRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cloudExadataInfrastructureId = null;
        private String ifMatch = null;
        private Boolean isDeleteVmClusters = null;
        private String opcRequestId = null;

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder isDeleteVmClusters(Boolean isDeleteVmClusters) {
            this.isDeleteVmClusters = isDeleteVmClusters;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCloudExadataInfrastructureRequest o) {
            this.cloudExadataInfrastructureId(o.getCloudExadataInfrastructureId());
            this.ifMatch(o.getIfMatch());
            this.isDeleteVmClusters(o.getIsDeleteVmClusters());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCloudExadataInfrastructureRequest build() {
            DeleteCloudExadataInfrastructureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteCloudExadataInfrastructureRequest buildWithoutInvocationCallback() {
            DeleteCloudExadataInfrastructureRequest request = new DeleteCloudExadataInfrastructureRequest();
            request.cloudExadataInfrastructureId = this.cloudExadataInfrastructureId;
            request.ifMatch = this.ifMatch;
            request.isDeleteVmClusters = this.isDeleteVmClusters;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

