/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.Hacks;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.PhysicalView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

public class ProjectsRootNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(ProjectsRootNode.class.getName());
    private static final Set<ProjectsRootNode> all = new WeakSet();
    private static final RequestProcessor RP = new RequestProcessor(ProjectsRootNode.class);
    static final int PHYSICAL_VIEW = 0;
    static final int LOGICAL_VIEW = 1;
    private static final String ICON_BASE = "org/netbeans/modules/project/ui/resources/projectsRootNode.gif";
    public static final String ACTIONS_FOLDER = "ProjectsTabActions";
    public static final String ACTIONS_FOLDER_PHYSICAL = "FilesTabActions";
    private ResourceBundle bundle;
    private final int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectsRootNode(int type) {
        super((Children)new ProjectChildren(type), Lookups.singleton((Object)(type == 1 ? "projectTabLogical_tc" : "projectTab_tc")));
        this.setIconBaseWithExtension(ICON_BASE);
        this.type = type;
        Set<ProjectsRootNode> set = all;
        synchronized (set) {
            all.add(this);
        }
    }

    public String getName() {
        return "OpenProjects";
    }

    public String getDisplayName() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ProjectsRootNode.class);
        }
        return this.bundle.getString("LBL_OpenProjectsNode_Name");
    }

    public boolean canRename() {
        return false;
    }

    public Node.Handle getHandle() {
        return new Handle(this.type);
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return new Action[0];
        }
        List actions = Utilities.actionsForPath((String)(this.type == 0 ? ACTIONS_FOLDER_PHYSICAL : ACTIONS_FOLDER));
        return actions.toArray(new Action[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node findNode(FileObject target) {
        ProjectChildren ch = (ProjectChildren)this.getChildren();
        assert (ch.type == 1 || ch.type == 0);
        Project ownerProject = ProjectsRootNode.findProject(target);
        SelectInProjectFileOwnerQueryImpl foq = SelectInProjectFileOwnerQueryImpl.getInstance();
        if (foq != null) {
            foq.setCurrentProject(target, ownerProject);
        }
        try {
            int lookOnlyInOwnerProject;
            int n = lookOnlyInOwnerProject = ownerProject != null ? 0 : 1;
            while (lookOnlyInOwnerProject < 2) {
                for (Node node : ch.getNodes(true)) {
                    PhysicalView.PathFinder pf;
                    Project p = (Project)node.getLookup().lookup(Project.class);
                    assert (p != null) : "Should have had a Project in lookup of " + node;
                    if (lookOnlyInOwnerProject == 0 && p != ownerProject) continue;
                    Node n2 = null;
                    LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
                    if (lvp != null) {
                        n2 = lvp.findPath(node, (Object)target);
                    }
                    if (n2 == null && ch.type == 0 && (pf = (PhysicalView.PathFinder)node.getLookup().lookup(PhysicalView.PathFinder.class)) != null) {
                        n2 = pf.findPath(node, target);
                    }
                    if (n2 == null) continue;
                    Node node2 = n2;
                    return node2;
                }
                ++lookOnlyInOwnerProject;
            }
        }
        finally {
            if (foq != null) {
                foq.clearCurrentProject();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkNoLazyNode() {
        Set<ProjectsRootNode> set = all;
        synchronized (set) {
            for (ProjectsRootNode root : all) {
                ProjectsRootNode.checkNoLazyNode(root.getChildren());
            }
        }
    }

    static void checkNoLazyNode(Children children) {
        for (Node n : children.getNodes()) {
            if (n instanceof BadgingNode) {
                ((BadgingNode)n).replaceProject(null);
            }
            if (n.getLookup().lookup(LazyProject.class) == null) continue;
            OpenProjectList.LOGGER.warning("LazyProjects remain visible");
        }
    }

    @CheckForNull
    private static Project findProject(@NonNull FileObject target) {
        Project owner = FileOwnerQuery.getOwner((FileObject)target);
        if (owner != null && ProjectConvertors.isConvertorProject((Project)owner)) {
            for (FileObject dir = owner.getProjectDirectory().getParent(); dir != null; dir = dir.getParent()) {
                Project p = FileOwnerQuery.getOwner((FileObject)dir);
                if (p == null || ProjectConvertors.isConvertorProject((Project)p)) continue;
                owner = p;
                break;
            }
        }
        return owner;
    }

    static class ProjectChildren
    extends Children.Keys<Pair>
    implements ChangeListener,
    PropertyChangeListener,
    NodeListener {
        static final RequestProcessor RP = new RequestProcessor(ProjectChildren.class);
        private final Map<Sources, Reference<Project>> sources2projects = new WeakHashMap<Sources, Reference<Project>>();
        private final Map<Project, Reference<Pair>> projects2Pairs = Collections.synchronizedMap(new WeakHashMap());
        final int type;

        public ProjectChildren(int type) {
            this.type = type;
        }

        public void addNotify() {
            OpenProjectList.getDefault().addPropertyChangeListener(this);
            if (Boolean.getBoolean("test.projectnode.sync")) {
                this.setKeys(this.getKeys());
            } else {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        this.setKeys(this.getKeys());
                    }
                });
            }
        }

        public void removeNotify() {
            OpenProjectList.getDefault().removePropertyChangeListener(this);
            for (Sources sources : this.sources2projects.keySet()) {
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.projects2Pairs.clear();
            this.setKeys(Collections.emptySet());
        }

        public int getNodesCount(boolean optimalResult) {
            if (optimalResult) {
                this.setKeys(this.getKeys());
            }
            return super.getNodesCount(optimalResult);
        }

        protected Node[] createNodes(Pair p) {
            Project project = p.project;
            Node[] origNodes = null;
            boolean[] projectInLookup = new boolean[]{true};
            if (this.type == 0) {
                Sources sources = (Sources)((org.openide.util.Pair)p.data.second()).first();
                SourceGroup[] groups = (SourceGroup[])((org.openide.util.Pair)p.data.second()).second();
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                this.sources2projects.put(sources, new WeakReference<Project>(project));
                ArrayList<Node> nodes = new ArrayList<Node>(groups.length);
                for (SourceGroup group : groups) {
                    Node n = PhysicalView.createNodeForSourceGroup(group, project);
                    if (n == null) continue;
                    nodes.add(n);
                }
                origNodes = nodes.toArray(new Node[0]);
            } else {
                assert (this.type == 1);
                origNodes = new Node[]{this.logicalViewForProject(project, (Union2<LogicalViewProvider, org.openide.util.Pair<Sources, SourceGroup[]>>)p.data, projectInLookup)};
            }
            Node[] badgedNodes = new Node[origNodes.length];
            for (int i = 0; i < origNodes.length; ++i) {
                badgedNodes[i] = this.type == 0 && !PhysicalView.isProjectDirNode(origNodes[i]) ? origNodes[i] : new BadgingNode(this, p, origNodes[i], this.type == 1);
            }
            return badgedNodes;
        }

        @NonNull
        final Node logicalViewForProject(@NonNull Project project, Union2<LogicalViewProvider, org.openide.util.Pair<Sources, SourceGroup[]>> data, boolean[] projectInLookup) {
            Node node;
            if (!data.hasFirst()) {
                LOG.log(Level.WARNING, "Warning - project of {0} in {1} doesn't supply a LogicalViewProvider in its lookup", new Object[]{project.getClass(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())});
                Sources sources = (Sources)((org.openide.util.Pair)data.second()).first();
                SourceGroup[] groups = (SourceGroup[])((org.openide.util.Pair)data.second()).second();
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                node = groups.length > 0 ? PhysicalView.createNodeForSourceGroup(groups[0], project) : Node.EMPTY;
            } else {
                LogicalViewProvider lvp = (LogicalViewProvider)data.first();
                node = lvp.createLogicalView();
                if (!project.equals(node.getLookup().lookup(Project.class))) {
                    LOG.log(Level.WARNING, "Warning - project {0} failed to supply itself in the lookup of the root node of its own logical view", ProjectUtils.getInformation((Project)project).getName());
                    if (projectInLookup != null) {
                        projectInLookup[0] = false;
                    }
                }
            }
            node.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this, (Object)node));
            return node;
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("OpenProjects".equals(e.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        this.setKeys(this.getKeys());
                    }
                });
            } else if ("displayName".equals(e.getPropertyName())) {
                RP.schedule(new Runnable(){

                    @Override
                    public void run() {
                        this.setKeys(this.getKeys());
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Reference<Project> projectRef = this.sources2projects.get(e.getSource());
            if (projectRef == null) {
                return;
            }
            final Project project = projectRef.get();
            if (project == null) {
                return;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Optional.ofNullable((Reference)projects2Pairs.get(project)).map(ref -> (Pair)ref.get()).ifPresent(p -> ((Pair)p).update(project));
                    this.refresh(project);
                }
            });
        }

        final void refresh(Project p) {
            this.refreshKey(new Pair(p, this.type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Pair> getKeys() {
            List<Project> projects = Arrays.asList(OpenProjectList.getDefault().getOpenProjects());
            projects.sort(OpenProjectList.projectByDisplayName());
            ArrayList<Pair> dirs = new ArrayList<Pair>(projects.size());
            HashMap<Project, Pair> snapshot = new HashMap<Project, Pair>();
            for (Project project : projects) {
                Pair p = new Pair(project, this.type);
                dirs.add(p);
                snapshot.put(project, p);
            }
            Map<Project, Reference<Pair>> map = this.projects2Pairs;
            synchronized (map) {
                this.projects2Pairs.clear();
                snapshot.entrySet().forEach(e -> this.projects2Pairs.put((Project)e.getKey(), new WeakReference<Pair>((Pair)e.getValue())));
            }
            return dirs;
        }

        static final class Pair {
            Project project;
            final FileObject fo;
            private final int type;
            private Union2<LogicalViewProvider, org.openide.util.Pair<Sources, SourceGroup[]>> data;

            public Pair(Project project, int type) {
                this.project = project;
                this.fo = project.getProjectDirectory();
                this.type = type;
                this.data = Pair.createData(project, type);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Pair other = (Pair)obj;
                return this.fo == other.fo || this.fo != null && this.fo.equals(other.fo);
            }

            public int hashCode() {
                int hash = 7;
                hash = 53 * hash + (this.fo != null ? this.fo.hashCode() : 0);
                return hash;
            }

            private void update(@NonNull Project project) {
                assert (project != null);
                this.project = project;
                this.data = Pair.createData(project, this.type);
            }

            private static Union2<LogicalViewProvider, org.openide.util.Pair<Sources, SourceGroup[]>> createData(Project p, int type) {
                switch (type) {
                    case 1: {
                        LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
                        if (lvp != null) {
                            return Union2.createFirst((Object)lvp);
                        }
                    }
                    case 0: {
                        Sources s = ProjectUtils.getSources((Project)p);
                        SourceGroup[] groups = s.getSourceGroups("generic");
                        return Union2.createSecond((Object)org.openide.util.Pair.of((Object)s, (Object)groups));
                    }
                }
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
    }

    private static class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;
        private final int viewType;

        public Handle(int viewType) {
            this.viewType = viewType;
        }

        public Node getNode() {
            return new ProjectsRootNode(this.viewType);
        }
    }

    public static final class SelectInProjectFileOwnerQueryImpl
    implements FileOwnerQueryImplementation {
        private final ThreadLocal<Object[]> current = new ThreadLocal();

        @CheckForNull
        public Project getOwner(URI file) {
            Object[] currentTuple = this.current.get();
            if (currentTuple != null) {
                Object currentUri = currentTuple[1];
                if (currentUri == null) {
                    currentTuple[1] = currentUri = ((FileObject)currentTuple[0]).toURI();
                }
                if (currentUri.equals(file)) {
                    return (Project)currentTuple[2];
                }
            }
            return null;
        }

        public Project getOwner(FileObject file) {
            Object[] currentTuple = this.current.get();
            if (currentTuple != null && currentTuple[0].equals(file)) {
                return (Project)currentTuple[2];
            }
            return null;
        }

        private void setCurrentProject(@NonNull FileObject fo, @NullAllowed Project prj) {
            assert (fo != null);
            this.current.set(new Object[]{fo, null, prj});
        }

        private void clearCurrentProject() {
            this.current.remove();
        }

        @CheckForNull
        private static SelectInProjectFileOwnerQueryImpl getInstance() {
            for (FileOwnerQueryImplementation impl : Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class)) {
                if (SelectInProjectFileOwnerQueryImpl.class != impl.getClass()) continue;
                return (SelectInProjectFileOwnerQueryImpl)SelectInProjectFileOwnerQueryImpl.class.cast(impl);
            }
            return null;
        }
    }

    static final class BadgingNode
    extends FilterNode
    implements ChangeListener,
    PropertyChangeListener,
    Runnable,
    FileStatusListener {
        private static final String MAGIC = "BadgingNode.\u03bc\u03b1\u03b3\u03b9\u03ba";
        private final Object privateLock = new Object();
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        RequestProcessor.Task task;
        private boolean nameChange;
        private boolean iconChange;
        private volatile Boolean mainCache;
        private final ProjectChildren ch;
        private final boolean logicalView;
        private final ProjectChildren.Pair pair;
        private final Set<FileObject> projectDirsListenedTo = new WeakSet();
        private static final int DELAY = 50;
        private final FileChangeListener newSubDirListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                this.setProjectFilesAsynch();
            }

            public void fileFolderCreated(FileEvent fe) {
                this.setProjectFilesAsynch();
            }
        };
        private final RequestProcessor.Task fsRefreshTask = Hacks.RP.create(new Runnable(){

            @Override
            public void run() {
                this.setProjectFiles();
            }
        });
        private final Lookup.Result<ProjectIconAnnotator> result = Lookup.getDefault().lookupResult(ProjectIconAnnotator.class);

        private void setProjectFilesAsynch() {
            if (Boolean.getBoolean("test.nodelay")) {
                this.setProjectFiles();
                return;
            }
            this.fsRefreshTask.schedule(50);
        }

        public BadgingNode(ProjectChildren ch, ProjectChildren.Pair p, Node n, boolean logicalView) {
            super(n, null, BadgingNode.badgingLookup(n));
            this.ch = ch;
            this.pair = p;
            this.logicalView = logicalView;
            OpenProjectList.log(Level.FINER, "BadgingNode init {0}", this.toStringForLog());
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
            this.setProjectFilesAsynch();
            OpenProjectList.log(Level.FINER, "BadgingNode finished {0}", this.toStringForLog());
            AnnotationListener annotationListener = new AnnotationListener(this);
            annotationListener.init();
            this.result.addLookupListener((LookupListener)annotationListener);
        }

        private static Lookup badgingLookup(Node n) {
            return new BadgingLookup(n.getLookup());
        }

        protected final void setProjectFiles() {
            Project prj = (Project)this.getLookup().lookup(Project.class);
            if (prj != null && !(prj instanceof LazyProject)) {
                this.setProjectFiles(prj);
            }
        }

        private void replaceProject(Project newProj) {
            if (newProj == null) {
                try {
                    newProj = ProjectManager.getDefault().findProject(this.pair.fo);
                    if (newProj == this.pair.project) {
                        return;
                    }
                }
                catch (IOException ex) {
                    OpenProjectList.log(Level.INFO, "No project for " + this.pair.fo, ex);
                }
                catch (IllegalArgumentException ex) {
                    OpenProjectList.log(Level.INFO, "No project for " + this.pair.fo, ex);
                }
            }
            OpenProjectList.log(Level.FINER, "replacing for {0}", this.toStringForLog());
            Project p = (Project)this.getLookup().lookup(Project.class);
            if (p == null) {
                OpenProjectList.log(Level.FINE, "no project in lookup {0}", this.toStringForLog());
                return;
            }
            FileObject fo = p.getProjectDirectory();
            if (newProj != null && newProj.getProjectDirectory().equals(fo)) {
                Node n = null;
                if (this.logicalView) {
                    n = this.ch.logicalViewForProject(newProj, (Union2<LogicalViewProvider, Pair<Sources, SourceGroup[]>>)ProjectChildren.Pair.createData(newProj, this.logicalView ? 1 : 0), null);
                    OpenProjectList.log(Level.FINER, "logical view {0}", n);
                } else {
                    Node[] arr = PhysicalView.createNodesForProject(newProj);
                    OpenProjectList.log(Level.FINER, "physical view {0}", Arrays.asList(arr));
                    if (arr.length > 1) {
                        this.pair.update(newProj);
                        OpenProjectList.log(Level.FINER, "refreshing for {0}", newProj);
                        this.ch.refresh(newProj);
                        OpenProjectList.log(Level.FINER, "refreshed for {0}", newProj);
                        return;
                    }
                    if (arr.length == 1) {
                        n = arr[0];
                    } else {
                        OpenProjectList.log(Level.WARNING, "newProject yields null node: " + newProj, new Object[0]);
                        n = Node.EMPTY;
                    }
                }
                OpenProjectList.log(Level.FINER, "change original: {0}", n);
                OpenProjectList.log(Level.FINER, "children before change original: {0}", this.getChildren());
                OpenProjectList.log(Level.FINER, "delegate children before change original: {0}", this.getOriginal().getChildren());
                this.changeOriginal(n, true);
                OpenProjectList.log(Level.FINER, "delegate after change original: {0}", this.getOriginal());
                OpenProjectList.log(Level.FINER, "name after change original: {0}", this.getName());
                OpenProjectList.log(Level.FINER, "children after change original: {0}", this.getChildren());
                OpenProjectList.log(Level.FINER, "delegate children after change original: {0}", this.getOriginal().getChildren());
                BadgingLookup bl = (BadgingLookup)this.getLookup();
                bl.setMyLookups(n.getLookup());
                OpenProjectList.log(Level.FINER, "done {0}", this.toStringForLog());
                this.setProjectFilesAsynch();
            } else {
                FileObject newDir;
                if (newProj != null) {
                    newDir = newProj.getProjectDirectory();
                } else {
                    newDir = null;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            OpenProjectList.getDefault().close(new Project[]{((BadgingNode)this).pair.project}, false);
                        }
                    });
                }
                OpenProjectList.log(Level.FINER, "wrong directories. current: " + fo + " new " + newDir, new Object[0]);
            }
        }

        private void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")), project.getProjectDirectory());
        }

        private void setGroups(Collection<SourceGroup> groups, FileObject projectDirectory) {
            if (this.groupsListeners != null) {
                for (Map.Entry<SourceGroup, PropertyChangeListener> entry : this.groupsListeners.entrySet()) {
                    entry.getKey().removePropertyChangeListener(entry.getValue());
                }
            }
            HashMap<SourceGroup, PropertyChangeListener> _groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                _groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                if (fo.equals(projectDirectory)) {
                    for (FileObject kid : fo.getChildren()) {
                        Project owner = FileOwnerQuery.getOwner((FileObject)kid);
                        if (owner == null || owner.getProjectDirectory() != projectDirectory) continue;
                        roots.add(kid);
                    }
                    if (!this.projectDirsListenedTo.add(fo)) continue;
                    fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.newSubDirListener, (Object)fo));
                    continue;
                }
                roots.add(fo);
            }
            this.groupsListeners = _groupsListeners;
            this.setFiles(roots);
        }

        protected final void setFiles(Set<FileObject> files) {
            if (this.fileSystemListeners != null) {
                for (Map.Entry<FileSystem, FileStatusListener> entry : this.fileSystemListeners.entrySet()) {
                    entry.getKey().removeFileStatusListener(entry.getValue());
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            for (FileObject fo : files) {
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    LOG.log(Level.INFO, "Cannot get " + fo + " filesystem, ignoring...", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = Hacks.RP.create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public String getDisplayName() {
            String original = super.getDisplayName();
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    original = this.files.iterator().next().getFileSystem().getDecorator().annotateName(original, this.files);
                }
                catch (FileStateInvalidException e) {
                    LOG.log(Level.INFO, null, e);
                }
            }
            return original;
        }

        private String getLogName() {
            String original = super.getDisplayName();
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    original = this.files.iterator().next().getFileSystem().getDecorator().annotateName(original, this.files);
                }
                catch (FileStateInvalidException e) {
                    LOG.log(Level.INFO, null, e);
                }
            }
            return original;
        }

        private String toStringForLog() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[Name=" + this.getName() + ", displayName=" + this.getLogName() + "]";
        }

        public String getHtmlDisplayName() {
            String htmlName = this.getOriginal().getHtmlDisplayName();
            if (htmlName == null) {
                try {
                    htmlName = XMLUtil.toElementContent((String)this.getOriginal().getDisplayName());
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            if (htmlName == null) {
                return null;
            }
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    String annotatedMagic = this.files.iterator().next().getFileSystem().getDecorator().annotateNameHtml(MAGIC, this.files);
                    if (annotatedMagic != null) {
                        htmlName = annotatedMagic.replace(MAGIC, htmlName);
                    }
                }
                catch (FileStateInvalidException e) {
                    LOG.log(Level.INFO, null, e);
                }
            }
            return this.isMainAsync() ? "<b>" + htmlName + "</b>" : htmlName;
        }

        public Image getIcon(int type) {
            return this.getIcon(type, false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type, true);
        }

        private Image getIcon(int type, boolean opened) {
            Image img;
            Image image = img = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            if (this.logicalView) {
                Project p;
                if (this.files != null && this.files.iterator().hasNext()) {
                    try {
                        FileObject fo = this.files.iterator().next();
                        img = FileUIUtils.getImageDecorator((FileSystem)fo.getFileSystem()).annotateIcon(img, type, this.files);
                    }
                    catch (FileStateInvalidException e) {
                        LOG.log(Level.INFO, null, e);
                    }
                }
                if ((p = (Project)this.getLookup().lookup(Project.class)) != null) {
                    for (ProjectIconAnnotator pa : this.result.allInstances()) {
                        img = pa.annotateIcon(p, img, opened);
                    }
                }
            }
            return img;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("MainProject".equals(e.getPropertyName())) {
                this.mainCache = null;
                this.fireDisplayNameChange(null, null);
            }
            if ("ReplaceProject".equals(e.getPropertyName())) {
                this.replaceProject((Project)e.getNewValue());
            }
            if ("containership".equals(e.getPropertyName())) {
                this.setProjectFilesAsynch();
            }
        }

        private boolean isMainAsync() {
            Boolean res = this.mainCache;
            if (res != null) {
                return res;
            }
            RP.execute(new Runnable(){

                @Override
                public void run() {
                    mainCache = this.isMain();
                    this.fireDisplayNameChange(null, null);
                }
            });
            return false;
        }

        private boolean isMain() {
            Project p = (Project)this.getLookup().lookup(Project.class);
            return p != null && OpenProjectList.getDefault().isMainProject(p);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fsRefreshTask.schedule(50);
        }

        public Object getValue(String attributeName) {
            if ("customDelete".equals(attributeName)) {
                return true;
            }
            return super.getValue(attributeName);
        }

        public boolean canDestroy() {
            Project p = (Project)this.getLookup().lookup(Project.class);
            if (p == null) {
                return false;
            }
            ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            String[] sa = ap != null ? ap.getSupportedActions() : new String[]{};
            int k = sa.length;
            for (int i = 0; i < k; ++i) {
                if (!"delete".equals(sa[i])) continue;
                return ap.isActionEnabled("delete", this.getLookup());
            }
            return false;
        }

        public void destroy() throws IOException {
            Project p = (Project)this.getLookup().lookup(Project.class);
            if (p == null) {
                return;
            }
            final ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    ap.invokeAction("delete", this.getLookup());
                }
            });
        }

        static class AnnotationListener
        implements LookupListener,
        ChangeListener {
            private final Set<ProjectIconAnnotator> annotators = new WeakSet();
            private final Reference<BadgingNode> node;

            public AnnotationListener(BadgingNode node) {
                this.node = new WeakReference<BadgingNode>(node);
            }

            void init() {
                BadgingNode n = this.node.get();
                if (n == null) {
                    return;
                }
                for (ProjectIconAnnotator annotator : n.result.allInstances()) {
                    if (!this.annotators.add(annotator)) continue;
                    annotator.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)annotator));
                }
            }

            public void resultChanged(LookupEvent ev) {
                this.init();
                this.stateChanged(null);
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                BadgingNode n = this.node.get();
                if (n == null) {
                    return;
                }
                n.fireIconChange();
                n.fireOpenedIconChange();
            }
        }
    }

    private static final class BadgingLookup
    extends ProxyLookup {
        public BadgingLookup(Lookup ... lkps) {
            super(lkps);
        }

        public void setMyLookups(Lookup ... lkps) {
            this.setLookups(lkps);
        }

        public boolean isSearchInfo() {
            return this.getLookups().length > 1;
        }
    }
}

