/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.code;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import org.netbeans.spi.java.hints.BooleanOption;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.IntegerOption;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;

public class ReflectiveCustomizerProvider
implements CustomizerProvider {
    private final String hintClassName;
    private final String hintId;
    private final List<OptionDescriptor> options;

    public ReflectiveCustomizerProvider(String hintClassName, String hintId, List<OptionDescriptor> options) {
        this.hintClassName = hintClassName;
        this.hintId = hintId;
        this.options = options;
    }

    @Override
    public JComponent getCustomizer(Preferences prefs) {
        return new CustomizerImpl(prefs, this.hintClassName, this.hintId, this.options);
    }

    private static final class CustomizerImpl
    extends JPanel {
        private int row;

        public CustomizerImpl(Preferences prefs, String hintClassName, String hintId, List<OptionDescriptor> options) {
            try {
                this.setLayout(new GridBagLayout());
                this.row = 0;
                for (OptionDescriptor option : options) {
                    if (!(option.parameters instanceof IntegerOption)) continue;
                    this.createIntegerOption(option, prefs);
                }
                for (OptionDescriptor option : options) {
                    if (!(option.parameters instanceof BooleanOption)) continue;
                    this.createBooleanOption(option, prefs);
                }
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.anchor = 18;
                constraints.fill = 1;
                constraints.gridheight = 1;
                constraints.gridwidth = 0;
                constraints.gridx = 0;
                constraints.gridy = this.row++;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                this.add((Component)new JPanel(), constraints);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void createIntegerOption(OptionDescriptor option, Preferences prefs) {
            JComponent field;
            IntegerOption iopt = (IntegerOption)option.parameters;
            JLabel l = new JLabel();
            Mnemonics.setLocalizedText((JLabel)l, (String)(option.displayName + ":"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            constraints.gridy = this.row;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(0, 0, 0, 8);
            this.add((Component)l, constraints);
            int val = prefs.getInt(option.preferencesKey, (Integer)option.defaultValue);
            if (iopt.step() > 0) {
                val = Math.min(iopt.maxValue(), Math.max(iopt.minValue(), val));
                prefs.putInt(option.preferencesKey, val);
                JSpinner spinner = new JSpinner(new SpinnerNumberModel(val, iopt.minValue(), iopt.maxValue(), iopt.step()));
                spinner.addChangeListener(new ActionListenerImpl(option.preferencesKey, prefs));
                field = spinner;
            } else {
                JFormattedTextField formatted;
                NumberFormatter nf = new NumberFormatter();
                nf.setValueClass(Integer.class);
                nf.setMaximum(Integer.valueOf(iopt.maxValue()));
                nf.setMinimum(Integer.valueOf(iopt.minValue()));
                field = formatted = new JFormattedTextField(nf);
            }
            if (option.tooltip != null && !option.tooltip.isEmpty()) {
                field.setToolTipText(option.tooltip);
            }
            constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.gridy = this.row;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            this.add((Component)field, constraints);
            constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.gridheight = 1;
            constraints.gridwidth = 0;
            constraints.gridx = 2;
            constraints.gridy = this.row++;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            this.add((Component)new JPanel(), constraints);
        }

        private JComponent createBooleanOption(OptionDescriptor option, Preferences prefs) {
            JCheckBox checkBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)option.displayName);
            checkBox.setToolTipText(option.tooltip);
            checkBox.addActionListener(new ActionListenerImpl(option.preferencesKey, prefs));
            checkBox.setSelected(prefs.getBoolean(option.preferencesKey, Boolean.TRUE == option.defaultValue));
            prefs.putBoolean(option.preferencesKey, checkBox.isSelected());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 2;
            constraints.gridx = 0;
            constraints.gridy = this.row++;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            this.add((Component)checkBox, constraints);
            return checkBox;
        }

        private static final class ActionListenerImpl
        implements ActionListener,
        ChangeListener {
            private final String key;
            private final Preferences prefs;

            public ActionListenerImpl(String key, Preferences prefs) {
                this.key = key;
                this.prefs = prefs;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                this.prefs.putBoolean(this.key, checkBox.isSelected());
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer i = (Integer)((JSpinner)e.getSource()).getValue();
                this.prefs.putInt(this.key, i);
            }
        }
    }

    public static final class OptionDescriptor {
        public final String preferencesKey;
        public final Object defaultValue;
        public final String displayName;
        public final String tooltip;
        public final Object parameters;

        public OptionDescriptor(String preferencesKey, Object defaultValue, String displayName, String tooltip, Object parameters) {
            this.preferencesKey = preferencesKey;
            this.defaultValue = defaultValue;
            this.displayName = displayName;
            this.tooltip = tooltip;
            this.parameters = parameters;
        }
    }
}

