/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.htmlui;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class JSEmbeddingProvider
extends JavaParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger(JSEmbeddingProvider.class.getName());
    private static final int PRIORITY = 1000;
    private static final String JS_ANNOTATION = "net.java.html.js.JavaScriptBody";
    private static final String BODY = "body";
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private final AtomicBoolean canceled = new AtomicBoolean();

    private JSEmbeddingProvider() {
        super(JavaSource.Phase.ELEMENTS_RESOLVED);
    }

    public int getPriority() {
        return 1000;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(Parser.Result t, SchedulerEvent se) {
        this.canceled.set(false);
        CompilationInfo ci = CompilationInfo.get((Parser.Result)t);
        JSEmbeddingProvider.colorizeJSB(ci);
    }

    public static void colorizeJSB(CompilationInfo ci) {
        CompilationUnitTree cu = ci.getCompilationUnit();
        Trees trees = ci.getTrees();
        SourcePositions sp = trees.getSourcePositions();
        Finder f = new Finder(trees);
        ArrayList result = new ArrayList();
        f.scan(cu, result);
        if (!result.isEmpty()) {
            try {
                TokenSequence seq;
                TokenHierarchy tk = TokenHierarchy.get((Document)ci.getDocument());
                Language java = Language.find((String)JAVA_MIME_TYPE);
                Language javaScript = Language.find((String)JAVASCRIPT_MIME_TYPE);
                if (java != null && javaScript != null && (seq = tk.tokenSequence(java)) != null) {
                    for (LiteralTree lt : result) {
                        int start = (int)sp.getStartPosition(cu, lt);
                        int end = (int)sp.getEndPosition(cu, lt);
                        seq.move(start);
                        while (seq.moveNext() && seq.offset() < end) {
                            if (seq.embedded() != null && seq.embedded().language() != null && "text/x-java-string".equals(seq.embedded().language().mimeType())) {
                                seq.removeEmbedding(seq.embedded().language());
                            }
                            seq.createEmbedding(javaScript, 1, 1, true);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }

    private static final class Finder
    extends TreePathScanner<Void, List<? super LiteralTree>> {
        private final Trees trees;
        private CompilationUnitTree cu;
        private boolean inEmbedding;

        Finder(Trees trees) {
            this.trees = trees;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree unit, List<? super LiteralTree> p) {
            this.cu = unit;
            return (Void)super.visitCompilationUnit(unit, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree m, List<? super LiteralTree> p) {
            for (AnnotationTree annotationTree : m.getModifiers().getAnnotations()) {
                TypeElement ae = (TypeElement)this.trees.getElement(TreePath.getPath(this.cu, annotationTree.getAnnotationType()));
                if (ae == null || !JSEmbeddingProvider.JS_ANNOTATION.contentEquals(ae.getQualifiedName())) continue;
                List<? extends ExpressionTree> args = annotationTree.getArguments();
                for (ExpressionTree expressionTree : args) {
                    AssignmentTree assignemt;
                    if (!(expressionTree instanceof AssignmentTree) || !JSEmbeddingProvider.BODY.equals((assignemt = (AssignmentTree)expressionTree).getVariable().toString())) continue;
                    this.inEmbedding = true;
                    try {
                        this.scan(assignemt.getExpression(), p);
                    }
                    finally {
                        this.inEmbedding = false;
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree node, List<? super LiteralTree> p) {
            if (this.inEmbedding) {
                p.add(node);
            }
            return (Void)super.visitLiteral(node, p);
        }
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snpsht) {
            return Collections.singleton(new JSEmbeddingProvider());
        }
    }
}

