/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.HolderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.holders.Holder;

public class Holders {
    private static final Map boxedTypes = new HashMap();

    public static Object getValue(Holder holder) {
        Class<?> holderClass = holder.getClass();
        try {
            Field valueField = holderClass.getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            throw Holders.fieldExtractionException(e);
        }
    }

    public static void setValue(Holder holder, Object value) {
        Class<?> holderClass = holder.getClass();
        try {
            Field valueField = holderClass.getField("value");
            valueField.set(holder, value);
        }
        catch (Exception e) {
            throw Holders.fieldExtractionException(e);
        }
    }

    public static Class stripHolderClass(Class aClass) {
        if (aClass == null || !Holder.class.isAssignableFrom(aClass)) {
            return aClass;
        }
        try {
            Field valueField = aClass.getField("value");
            Class<?> valueClass = valueField.getType();
            return Holders.boxClassIfPrimitive(valueClass);
        }
        catch (Exception e) {
            throw Holders.fieldExtractionException(e);
        }
    }

    private static Class boxClassIfPrimitive(Class aClass) {
        Class boxedType = (Class)boxedTypes.get(aClass);
        if (boxedType != null) {
            return boxedType;
        }
        return aClass;
    }

    private static HolderException fieldExtractionException(Exception e) {
        return new HolderException("holder.valuefield.not.found", new LocalizableExceptionAdapter(e));
    }

    static {
        boxedTypes.put(Boolean.TYPE, Boolean.class);
        boxedTypes.put(Byte.TYPE, Byte.class);
        boxedTypes.put(Character.TYPE, Character.class);
        boxedTypes.put(Short.TYPE, Short.class);
        boxedTypes.put(Integer.TYPE, Integer.class);
        boxedTypes.put(Long.TYPE, Long.class);
        boxedTypes.put(Float.TYPE, Float.class);
        boxedTypes.put(Double.TYPE, Double.class);
    }
}

