/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.io.InputOutput;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.VisualDebuggerListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class RemoteServices {
    private static final Logger logger = Logger.getLogger(RemoteServices.class.getName());
    private static final String REMOTE_CLASSES_ZIPFILE = "/org/netbeans/modules/debugger/jpda/visual/resources/debugger-remote.zip";
    private static final Map<JPDADebugger, Map<ServiceType, ClassObjectReference>> remoteServiceClasses = new WeakHashMap<JPDADebugger, Map<ServiceType, ClassObjectReference>>();
    private static final Map<JPDADebugger, Boolean> remoteServiceAccess = new WeakHashMap<JPDADebugger, Boolean>();
    private static final RequestProcessor AUTORESUME_AFTER_SUSPEND_RP = new RequestProcessor("Autoresume after suspend", 1);
    private static final Set<PropertyChangeListener> serviceListeners = new WeakSet();
    private static final Map<JPDAThread, RequestProcessor.Task> tasksByThreads = new WeakHashMap<JPDAThread, RequestProcessor.Task>();
    private static final Map<JPDADebugger, LoggingListeners> loggingListeners = new WeakHashMap<JPDADebugger, LoggingListeners>();

    private RemoteServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireServiceClass(JPDADebugger debugger) {
        PropertyChangeEvent pche = new PropertyChangeEvent(RemoteServices.class, "serviceClass", null, debugger);
        PropertyChangeListener[] propertyChangeListenerArray = serviceListeners;
        synchronized (serviceListeners) {
            PropertyChangeListener[] listeners = serviceListeners.toArray(new PropertyChangeListener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PropertyChangeListener l : listeners) {
                l.propertyChange(pche);
            }
            return;
        }
    }

    private static ObjectReference getBootstrapClassLoader(ThreadReference tawt, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ObjectReference bcl;
        ClassType classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
        Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getSystemClassLoader", (String)"()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)classLoaderClass, (ThreadReference)tawt, (Method)getSystemClassLoader, Collections.emptyList(), (int)1);
        Method getParent = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getParent", (String)"()Ljava/lang/ClassLoader;");
        do {
            bcl = cl;
        } while (!"sun.misc.Launcher$AppClassLoader".equals(cl.referenceType().name()) && (cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)cl, (ThreadReference)tawt, (Method)getParent, Collections.emptyList(), (int)1)) != null);
        return bcl;
    }

    private static ObjectReference getContextClassLoader(ThreadReference tawt, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ReferenceType threadType = tawt.referenceType();
        Method getContextCl = ClassTypeWrapper.concreteMethodByName((ClassType)((ClassType)threadType), (String)"getContextClassLoader", (String)"()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)tawt, (ThreadReference)tawt, (Method)getContextCl, Collections.emptyList(), (int)1);
        ClassType classLoaderClass = null;
        if (cl == null) {
            classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
            Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getSystemClassLoader", (String)"()Ljava/lang/ClassLoader;");
            cl = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)classLoaderClass, (ThreadReference)tawt, (Method)getSystemClassLoader, Collections.emptyList(), (int)1);
        }
        return cl;
    }

    private static ObjectReference getQuantumTookitClassLoader(VirtualMachine vm) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        ClassType classQuantumToolkit = RemoteServices.getClass(vm, "com.sun.javafx.tk.quantum.QuantumToolkit");
        if (classQuantumToolkit == null) {
            return null;
        }
        ClassLoaderReference cl = ReferenceTypeWrapper.classLoader((ReferenceType)classQuantumToolkit);
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference uploadBasicClasses(JPDAThreadImpl t, ServiceType sType) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ThreadReference tawt = t.getThreadReference();
        VirtualMachine vm = tawt.virtualMachine();
        t.notifyMethodInvoking();
        try {
            Object object;
            ClassObjectReference basicClass = null;
            t.accessLock.writeLock().lock();
            try {
                ClassType bc;
                List<RemoteClass> remoteClasses = RemoteServices.getRemoteClasses();
                for (RemoteClass rc : remoteClasses) {
                    List classesByName;
                    String className = rc.name;
                    if (basicClass != null || className.indexOf(36) >= 0 || !className.endsWith("Service")) continue;
                    if ((sType != ServiceType.AWT || !className.contains("AWT")) && (sType != ServiceType.FX || !className.contains("FX")) || (classesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)className)).isEmpty()) break;
                    basicClass = ReferenceTypeWrapper.classObject((ReferenceType)((ReferenceType)classesByName.get(0)));
                    break;
                }
                if (basicClass == null) {
                    ObjectReference cl;
                    if (sType == ServiceType.AWT) {
                        cl = RemoteServices.getBootstrapClassLoader(tawt, vm);
                    } else {
                        cl = RemoteServices.getQuantumTookitClassLoader(vm);
                        if (cl == null) {
                            cl = RemoteServices.getContextClassLoader(tawt, vm);
                        }
                    }
                    ClassType classLoaderClass = (ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)cl);
                    ByteValue[] mirrorBytesCache = new ByteValue[256];
                    for (RemoteClass rc : remoteClasses) {
                        String className = rc.name;
                        if ((sType != ServiceType.AWT || !className.contains("AWT")) && (sType != ServiceType.FX || !className.contains("FX"))) continue;
                        ArrayReference byteArray = RemoteServices.createTargetBytes(vm, rc.bytes, mirrorBytesCache);
                        StringReference nameMirror = null;
                        try {
                            Method defineClass = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"defineClass", (String)"(Ljava/lang/String;[BII)Ljava/lang/Class;");
                            boolean uploaded = false;
                            while (!uploaded) {
                                nameMirror = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (String)className);
                                try {
                                    ObjectReferenceWrapper.disableCollection((ObjectReference)nameMirror);
                                    uploaded = true;
                                }
                                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
                            }
                            uploaded = false;
                            while (!uploaded) {
                                ClassObjectReference theUploadedClass = (ClassObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)cl, (ThreadReference)tawt, (Method)defineClass, Arrays.asList(nameMirror, byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), (int)1);
                                if (basicClass == null && rc.name.indexOf(36) < 0 && rc.name.endsWith("Service")) {
                                    try {
                                        ObjectReferenceWrapper.disableCollection((ObjectReference)theUploadedClass);
                                        basicClass = theUploadedClass;
                                        uploaded = true;
                                    }
                                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
                                    continue;
                                }
                                uploaded = true;
                            }
                        }
                        catch (Throwable throwable) {
                            ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                            if (nameMirror != null) {
                                ObjectReferenceWrapper.enableCollection(nameMirror);
                            }
                            throw throwable;
                        }
                        ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                        if (nameMirror == null) continue;
                        ObjectReferenceWrapper.enableCollection((ObjectReference)nameMirror);
                    }
                }
                if (basicClass != null && !(bc = (ClassType)basicClass.reflectedType()).isInitialized()) {
                    ClassType theClass = RemoteServices.getClass(vm, Class.class.getName());
                    Method aMethod = ClassTypeWrapper.concreteMethodByName((ClassType)theClass, (String)"getConstructors", (String)"()[Ljava/lang/reflect/Constructor;");
                    ObjectReferenceWrapper.invokeMethod((ObjectReference)basicClass, (ThreadReference)tawt, (Method)aMethod, Collections.emptyList(), (int)1);
                }
            }
            finally {
                t.accessLock.writeLock().unlock();
            }
            if (basicClass != null) {
                object = remoteServiceClasses;
                synchronized (object) {
                    Map<ServiceType, ClassObjectReference> basicClassesByType = remoteServiceClasses.get(t.getDebugger());
                    if (basicClassesByType == null) {
                        basicClassesByType = new EnumMap<ServiceType, ClassObjectReference>(ServiceType.class);
                        remoteServiceClasses.put((JPDADebugger)t.getDebugger(), basicClassesByType);
                    }
                    basicClassesByType.put(sType, basicClass);
                    t.getDebugger().addPropertyChangeListener((PropertyChangeListener)new RemoteServiceDebuggerListener());
                }
                RemoteServices.fireServiceClass((JPDADebugger)t.getDebugger());
            }
            object = basicClass;
            return object;
        }
        finally {
            t.notifyMethodInvokeDone();
        }
    }

    static Pair<ClassType, Field> setPreferredEQThread(JPDAThread t, ServiceType sType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ClassType serviceClass;
        ClassObjectReference serviceClassObject = RemoteServices.getServiceClass((JPDADebugger)((JPDAThreadImpl)t).getDebugger(), sType);
        if (serviceClassObject == null) {
            return null;
        }
        try {
            serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        Field preferredEventThreadField = null;
        try {
            preferredEventThreadField = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass, (String)"preferredEventThread");
        }
        catch (ClassNotPreparedExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (preferredEventThreadField != null) {
            try {
                ClassTypeWrapper.setValue((ClassType)serviceClass, (Field)preferredEventThreadField, (Value)((JPDAThreadImpl)t).getThreadReference());
            }
            catch (ClassNotLoadedException | InvalidTypeException | ClassNotPreparedExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return Pair.of((Object)serviceClass, (Object)preferredEventThreadField);
        }
        return null;
    }

    static void clearPreferredEQThread(JPDADebugger dbg, Pair<ClassType, Field> preferredEventThreadFieldAndServiceClass) {
        if (preferredEventThreadFieldAndServiceClass != null) {
            ClassType serviceClass = (ClassType)preferredEventThreadFieldAndServiceClass.first();
            Field preferredEventThreadField = (Field)preferredEventThreadFieldAndServiceClass.second();
            try {
                ClassTypeWrapper.setValue((ClassType)serviceClass, (Field)preferredEventThreadField, null);
            }
            catch (ClassNotLoadedException | InvalidTypeException | ClassNotPreparedExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
                // empty catch block
            }
        }
    }

    private static void runOnBreakpoint(JPDAThread awtThread, String bpClass, String bpMethod, Runnable runnable, CountDownLatch latch) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)bpClass, (String)bpMethod);
        JPDADebuggerImpl dbg = ((JPDAThreadImpl)awtThread).getDebugger();
        PropertyChangeListener[] listenerPtr = new PropertyChangeListener[]{null};
        mb.setBreakpointType(1);
        mb.setSuspend(1);
        mb.setHidden(true);
        mb.setThreadFilters((JPDADebugger)dbg, new JPDAThread[]{awtThread});
        mb.addJPDABreakpointListener(new JPDABreakpointListener(){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            final /* synthetic */ JPDAThread val$awtThread;
            final /* synthetic */ Runnable val$runnable;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
                this.val$awtThread = jPDAThread;
                this.val$runnable = runnable;
                this.val$latch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void breakpointReached(JPDABreakpointEvent event) {
                block8: {
                    if (this.val$dbg.equals(event.getDebugger())) {
                        try {
                            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                            PropertyChangeListener listener = this.val$listenerPtr[0];
                            if (listener != null) {
                                this.val$dbg.removePropertyChangeListener("state", listener);
                                this.val$listenerPtr[0] = null;
                            }
                            try {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvoking();
                                this.val$runnable.run();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                                break block8;
                            }
                            catch (Throwable throwable) {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                                throw throwable;
                            }
                            ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                        }
                        finally {
                            event.resume();
                            this.val$latch.countDown();
                        }
                    }
                }
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener(){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
                this.val$latch = countDownLatch;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.val$dbg.getState() == 4) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                    this.val$dbg.removePropertyChangeListener("state", (PropertyChangeListener)this);
                    this.val$listenerPtr[0] = null;
                    this.val$latch.countDown();
                }
            }
        };
        dbg.addPropertyChangeListener("state", listener);
        listenerPtr[0] = listener;
        if (dbg.getState() != 4) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        } else {
            dbg.removePropertyChangeListener("state", listener);
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnStoppedThread(JPDAThread thread, Runnable run, ServiceType sType) throws PropertyVetoException {
        block39: {
            Pair<ClassType, Field> setPreferredEQThreadField;
            JPDAThreadImpl t = (JPDAThreadImpl)thread;
            Lock lock = t.accessLock.writeLock();
            lock.lock();
            try {
                setPreferredEQThreadField = RemoteServices.setPreferredEQThread(thread, sType);
            }
            catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                return;
            }
            try {
                RequestProcessor.Task autoresumeTask;
                ThreadReference threadReference = t.getThreadReference();
                boolean wasSuspended = t.isSuspended();
                if (!t.isSuspended() || !threadReference.isAtBreakpoint()) {
                    // empty if block
                }
                if (!t.isSuspended()) {
                    ClassObjectReference serviceClassObject;
                    CountDownLatch latch = new CountDownLatch(1);
                    lock.unlock();
                    lock = null;
                    VirtualMachine vm = ((JPDAThreadImpl)thread).getThreadReference().virtualMachine();
                    Map<JPDADebugger, Map<ServiceType, ClassObjectReference>> map = remoteServiceClasses;
                    synchronized (map) {
                        Map<ServiceType, ClassObjectReference> sc = remoteServiceClasses.get(((JPDAThreadImpl)thread).getDebugger());
                        serviceClassObject = sc != null ? sc.get((Object)sType) : null;
                    }
                    if (serviceClassObject == null) {
                        return;
                    }
                    switch (sType) {
                        case AWT: {
                            ClassType serviceClass2;
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", "calledInAWT", run, latch);
                            try {
                                serviceClass2 = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                                Field awtAccess = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass2, (String)"awtAccess");
                                ClassTypeWrapper.setValue((ClassType)serviceClass2, (Field)awtAccess, (Value)VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
                            }
                            catch (InternalExceptionWrapper serviceClass2) {
                            }
                            catch (VMDisconnectedExceptionWrapper serviceClass2) {
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            break;
                        }
                        case FX: {
                            ClassType serviceClass2;
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteFXService", "access", run, latch);
                            try {
                                serviceClass2 = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                                Field fxAccess = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass2, (String)"fxAccess");
                                ClassTypeWrapper.setValue((ClassType)serviceClass2, (Field)fxAccess, (Value)VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
                                break;
                            }
                            catch (InternalExceptionWrapper serviceClass) {
                                break;
                            }
                            catch (VMDisconnectedExceptionWrapper serviceClass) {
                                break;
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break block39;
                }
                if (!wasSuspended) {
                    AutoresumeTask resumeTask = new AutoresumeTask(t);
                    autoresumeTask = AUTORESUME_AFTER_SUSPEND_RP.create((Runnable)resumeTask);
                    Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                    synchronized (map) {
                        tasksByThreads.put(thread, autoresumeTask);
                    }
                }
                Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                synchronized (map) {
                    autoresumeTask = tasksByThreads.get(thread);
                }
                t.notifyMethodInvoking();
                if (autoresumeTask != null) {
                    autoresumeTask.schedule(Integer.MAX_VALUE);
                }
                try {
                    run.run();
                }
                finally {
                    t.notifyMethodInvokeDone();
                    if (autoresumeTask != null) {
                        autoresumeTask.schedule(500);
                    }
                }
            }
            finally {
                RemoteServices.clearPreferredEQThread((JPDADebugger)t.getDebugger(), setPreferredEQThreadField);
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RemoteListener> getAttachedListeners(final JavaComponentInfo ci, final boolean combineAllTypes) throws PropertyVetoException {
        Pair<ClassType, Field> setPreferredEQThreadField;
        final ArrayList<RemoteListener> rlisteners = new ArrayList<RemoteListener>();
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference component = ci.getComponent();
        try {
            setPreferredEQThreadField = RemoteServices.setPreferredEQThread((JPDAThread)thread, ServiceType.AWT);
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return rlisteners;
        }
        try {
            RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

                @Override
                public void run() {
                    if (ci instanceof RemoteAWTScreenshot.AWTComponentInfo) {
                        RemoteServices.retrieveAttachedListeners(thread, component, rlisteners, combineAllTypes);
                    } else {
                        RemoteServices.retrieveAttachedFXListeners(thread, component, rlisteners);
                    }
                }
            }, ci instanceof RemoteAWTScreenshot.AWTComponentInfo ? ServiceType.AWT : ServiceType.FX);
        }
        finally {
            RemoteServices.clearPreferredEQThread((JPDADebugger)thread.getDebugger(), setPreferredEQThreadField);
        }
        return rlisteners;
    }

    private static void retrieveAttachedListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners, boolean combineAllTypes) {
        ThreadReference t = thread.getThreadReference();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            HashMap<ObjectReference, RemoteListener> listenersByInstance = null;
            if (combineAllTypes) {
                listenersByInstance = new HashMap<ObjectReference, RemoteListener>();
            }
            for (Method m : visibleMethods) {
                String listenerType;
                Value result;
                block17: {
                    String name = TypeComponentWrapper.name((TypeComponent)m);
                    if (!name.startsWith("get") || !name.endsWith("Listeners") || MethodWrapper.argumentTypeNames((Method)m).size() > 0) continue;
                    try {
                        result = ObjectReferenceWrapper.invokeMethod((ObjectReference)component, (ThreadReference)t, (Method)m, Collections.emptyList(), (int)1);
                    }
                    catch (ClassNotLoadedException cnlex) {
                        continue;
                    }
                    catch (InvocationException iex) {
                        Exceptions.printStackTrace((Throwable)iex);
                        continue;
                    }
                    listenerType = null;
                    try {
                        Type returnType = MethodWrapper.returnType((Method)m);
                        if (!(returnType instanceof ArrayType)) break block17;
                        ArrayType art = (ArrayType)returnType;
                        listenerType = ArrayTypeWrapper.componentTypeName((ArrayType)art);
                    }
                    catch (ClassNotLoadedException ex) {
                        continue;
                    }
                }
                if (listenerType == null) continue;
                ArrayReference array = (ArrayReference)result;
                List listeners = ArrayReferenceWrapper.getValues((ArrayReference)array);
                for (Value v : listeners) {
                    RemoteListener rl;
                    if (combineAllTypes && (rl = (RemoteListener)listenersByInstance.get((ObjectReference)v)) != null) {
                        rl.addType(listenerType);
                        continue;
                    }
                    rl = new RemoteListener(listenerType, (ObjectReference)v);
                    if (combineAllTypes) {
                        listenersByInstance.put((ObjectReference)v, rl);
                    }
                    rlisteners.add(rl);
                }
            }
        }
        catch (ClassNotPreparedExceptionWrapper clazz) {
        }
        catch (ObjectCollectedExceptionWrapper clazz) {
        }
        catch (InternalExceptionWrapper clazz) {
        }
        catch (VMDisconnectedExceptionWrapper clazz) {
        }
        catch (IncompatibleThreadStateException itsex) {
            Exceptions.printStackTrace((Throwable)itsex);
        }
        catch (InvalidTypeException itex) {
            Exceptions.printStackTrace((Throwable)itex);
        }
    }

    private static void retrieveAttachedFXListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners) {
        ThreadReference t = thread.getThreadReference();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            for (Method m : visibleMethods) {
                String listenerType;
                Value result;
                block15: {
                    String name;
                    block14: {
                        name = TypeComponentWrapper.name((TypeComponent)m);
                        if (!name.startsWith("getOn") || MethodWrapper.argumentTypeNames((Method)m).size() > 0) continue;
                        try {
                            result = ObjectReferenceWrapper.invokeMethod((ObjectReference)component, (ThreadReference)t, (Method)m, Collections.emptyList(), (int)1);
                            if (result == null) {
                            }
                            break block14;
                        }
                        catch (ClassNotLoadedException cnlex) {
                        }
                        catch (InvocationException iex) {
                            Exceptions.printStackTrace((Throwable)iex);
                        }
                        continue;
                    }
                    listenerType = null;
                    try {
                        Type returnType = MethodWrapper.returnType((Method)m);
                        if (!TypeWrapper.name((Type)returnType).equals("javafx.event.EventHandler")) break block15;
                        listenerType = name.substring(5);
                    }
                    catch (ClassNotLoadedException ex) {
                        continue;
                    }
                }
                if (listenerType == null) continue;
                RemoteListener rl = new RemoteListener(listenerType, (ObjectReference)result);
                rlisteners.add(rl);
            }
        }
        catch (ClassNotPreparedExceptionWrapper clazz) {
        }
        catch (ObjectCollectedExceptionWrapper clazz) {
        }
        catch (InternalExceptionWrapper clazz) {
        }
        catch (VMDisconnectedExceptionWrapper clazz) {
        }
        catch (IncompatibleThreadStateException itsex) {
            Exceptions.printStackTrace((Throwable)itsex);
        }
        catch (InvalidTypeException itex) {
            Exceptions.printStackTrace((Throwable)itex);
        }
    }

    public static List<ReferenceType> getAttachableListeners(JavaComponentInfo ci) {
        ObjectReference component = ci.getComponent();
        ArrayList<ReferenceType> listenerClasses = new ArrayList<ReferenceType>();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            for (Method m : visibleMethods) {
                Type t;
                List argTypes;
                String name = TypeComponentWrapper.name((TypeComponent)m);
                if (!name.startsWith("add") || !name.endsWith("Listener")) continue;
                try {
                    argTypes = MethodWrapper.argumentTypes((Method)m);
                }
                catch (ClassNotLoadedException ex) {
                    continue;
                }
                if (argTypes.size() != 1 || !((t = (Type)argTypes.get(0)) instanceof ReferenceType)) continue;
                ReferenceType rt = (ReferenceType)t;
                String lname = ReferenceTypeWrapper.name((ReferenceType)rt);
                int i = lname.lastIndexOf(46);
                i = i < 0 ? 0 : ++i;
                int ii = lname.lastIndexOf(36, i);
                if (ii > i) {
                    i = ii + 1;
                }
                if (!name.substring(3).equals(lname.substring(i))) continue;
                listenerClasses.add(rt);
            }
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return listenerClasses;
    }

    private static void addEventsLoggingBreakpoint(final JPDADebugger dbg) {
        final MethodBreakpoint mb = MethodBreakpoint.create((String)"org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", (String)"calledWithEventsData");
        mb.setBreakpointType(1);
        mb.setSuspend(1);
        mb.setHidden(true);
        mb.addJPDABreakpointListener(new JPDABreakpointListener(){

            /*
             * Exception decompiling
             */
            public void breakpointReached(JPDABreakpointEvent event) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (dbg.getState() == 4) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb);
                    dbg.removePropertyChangeListener("state", (PropertyChangeListener)this);
                }
            }
        };
        dbg.addPropertyChangeListener("state", listener);
        if (dbg.getState() != 4) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        } else {
            dbg.removePropertyChangeListener("state", listener);
        }
    }

    public static ObjectReference attachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final LoggingListenerCallBack listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference[] listenerPtr = new ObjectReference[]{null};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                boolean newLL;
                ThreadReference t = thread.getThreadReference();
                ObjectReference component = ci.getComponent();
                JPDADebuggerImpl dbg = ci.getThread().getDebugger();
                Map map = loggingListeners;
                synchronized (map) {
                    LoggingListeners ll = (LoggingListeners)loggingListeners.get(dbg);
                    boolean bl = newLL = ll == null;
                    if (newLL) {
                        ll = new LoggingListeners();
                        loggingListeners.put(dbg, ll);
                    }
                    ll.add(ci.getComponent(), listenerClass, listener);
                }
                if (newLL) {
                    RemoteServices.addEventsLoggingBreakpoint((JPDADebugger)dbg);
                }
                Map map2 = remoteServiceClasses;
                synchronized (map2) {
                    serviceClassObject = (ClassObjectReference)((Map)remoteServiceClasses.get(thread.getDebugger())).get((Object)ServiceType.AWT);
                }
                try {
                    ObjectReference theListener;
                    ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                    Method addLoggingListener = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"addLoggingListener", (String)"(Ljava/awt/Component;Ljava/lang/Class;)Ljava/lang/Object;");
                    listenerPtr[0] = theListener = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)t, (Method)addLoggingListener, Arrays.asList(component, listenerClass), (int)1);
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    Exceptions.printStackTrace((Throwable)cnpex);
                }
                catch (InternalExceptionWrapper cnpex) {
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
            }
        }, ServiceType.AWT);
        return listenerPtr[0];
    }

    public static boolean detachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final ObjectReference listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final boolean[] retPtr = new boolean[]{false};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                ObjectReference component = ci.getComponent();
                ThreadReference t = thread.getThreadReference();
                Map map = remoteServiceClasses;
                synchronized (map) {
                    serviceClassObject = (ClassObjectReference)((Map)remoteServiceClasses.get(thread.getDebugger())).get((Object)ServiceType.AWT);
                }
                try {
                    ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                    Method removeLoggingListener = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"removeLoggingListener", (String)"(Ljava/awt/Component;Ljava/lang/Class;Ljava/lang/Object;)Z");
                    BooleanValue success = (BooleanValue)ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)t, (Method)removeLoggingListener, Arrays.asList(component, listenerClass, listener), (int)1);
                    retPtr[0] = success.value();
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    Exceptions.printStackTrace((Throwable)cnpex);
                }
                catch (InternalExceptionWrapper cnpex) {
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                }
                catch (VMDisconnectedExceptionWrapper ocex) {
                    // empty catch block
                }
                JPDADebuggerImpl dbg = ci.getThread().getDebugger();
                Map map2 = loggingListeners;
                synchronized (map2) {
                    LoggingListeners ll = (LoggingListeners)loggingListeners.get(dbg);
                    if (ll != null) {
                        Set<LoggingListenerCallBack> listeners = ll.getListeners(component, listenerClass);
                        for (LoggingListenerCallBack llcb : listeners) {
                            if (!listener.equals(llcb.getListenerObject())) continue;
                            ll.remove(component, listenerClass, llcb);
                        }
                    }
                }
            }
        }, ServiceType.AWT);
        return retPtr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void attachHierarchyListeners(final boolean attach, ServiceType sType) {
        HashSet serviceClasses;
        Map<JPDADebugger, Map<ServiceType, ClassObjectReference>> map = remoteServiceClasses;
        synchronized (map) {
            serviceClasses = new HashSet();
            remoteServiceClasses.entrySet().forEach(entry -> {
                ClassObjectReference cor = (ClassObjectReference)((Map)entry.getValue()).get((Object)sType);
                if (cor != null) {
                    serviceClasses.add(new AbstractMap.SimpleEntry<JPDADebugger, ClassObjectReference>((JPDADebugger)entry.getKey(), cor));
                }
            });
        }
        for (Map.Entry serviceEntry : serviceClasses) {
            ClassType serviceClass;
            JPDADebugger debugger = (JPDADebugger)serviceEntry.getKey();
            ClassObjectReference cor = (ClassObjectReference)serviceEntry.getValue();
            try {
                serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)cor);
            }
            catch (InternalExceptionWrapper ex) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                continue;
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                continue;
            }
            List allThreads = debugger.getThreadsCollector().getAllThreads();
            JPDAThread thread = null;
            for (JPDAThread t : allThreads) {
                if (sType != ServiceType.AWT || !t.getName().startsWith("AWT-EventQueue-")) continue;
                thread = t;
            }
            if (thread == null) continue;
            final JPDAThread t = thread;
            final ThreadReference tr = ((JPDAThreadImpl)t).getThreadReference();
            try {
                RemoteServices.runOnStoppedThread(t, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (attach) {
                                Method startHierarchyListenerMethod = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"startHierarchyListener", (String)"()Ljava/lang/String;");
                                Value res = ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)tr, (Method)startHierarchyListenerMethod, Collections.emptyList(), (int)1);
                                if (res instanceof StringReference) {
                                    String reason = ((StringReference)res).value();
                                    InputOutput io = ((JPDAThreadImpl)t).getDebugger().getConsoleIO().getIO();
                                    if (io != null) {
                                        io.getErr().println(NbBundle.getMessage(VisualDebuggerListener.class, (String)"MSG_NoTrackingOfComponentChanges", (Object)reason));
                                    }
                                }
                            } else {
                                Method stopHierarchyListenerMethod = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"stopHierarchyListener", (String)"()V");
                                ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)tr, (Method)stopHierarchyListenerMethod, Collections.emptyList(), (int)1);
                            }
                        }
                        catch (VMDisconnectedExceptionWrapper stopHierarchyListenerMethod) {
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, sType);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAccessLoopStarted(JPDADebugger debugger, boolean success) {
        Map<JPDADebugger, Boolean> map = remoteServiceAccess;
        synchronized (map) {
            remoteServiceAccess.put(debugger, success);
        }
        RemoteServices.fireServiceClass(debugger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasServiceAccess(JPDADebugger debugger) {
        Map<ServiceType, ClassObjectReference> cs;
        Map<JPDADebugger, Map<ServiceType, ClassObjectReference>> map = remoteServiceClasses;
        synchronized (map) {
            cs = remoteServiceClasses.get(debugger);
        }
        if (cs != null) {
            Boolean has;
            Map<JPDADebugger, Boolean> map2 = remoteServiceAccess;
            synchronized (map2) {
                has = remoteServiceAccess.get(debugger);
            }
            return has != null && has != false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference getServiceClass(JPDADebugger debugger, ServiceType sType) {
        Map<JPDADebugger, Map<ServiceType, ClassObjectReference>> map = remoteServiceClasses;
        synchronized (map) {
            Map<ServiceType, ClassObjectReference> cs = remoteServiceClasses.get(debugger);
            if (cs == null) {
                return null;
            }
            return cs.get((Object)sType);
        }
    }

    static ClassType getClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        if (clazz == null && classList.size() > 0) {
            clazz = (ReferenceType)classList.get(0);
        }
        return (ClassType)clazz;
    }

    static ArrayType getArrayClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        return (ArrayType)clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RemoteClass> getRemoteClasses() throws IOException {
        try (InputStream in = RemoteServices.class.getResourceAsStream(REMOTE_CLASSES_ZIPFILE);){
            ZipEntry ze;
            ZipInputStream zin = new ZipInputStream(in);
            ArrayList<RemoteClass> rcl = new ArrayList<RemoteClass>();
            while ((ze = zin.getNextEntry()) != null) {
                int r;
                String name;
                int baseStart;
                String fileName = ze.getName();
                if (!fileName.endsWith(".class") || (baseStart = (name = fileName.substring(0, fileName.length() - ".class".length())).lastIndexOf(47)) < 0) continue;
                RemoteClass rc = new RemoteClass();
                rc.name = name.replace('/', '.');
                int l = (int)ze.getSize();
                byte[] bytes = new byte[l];
                for (int num = 0; num < l; num += r) {
                    r = zin.read(bytes, num, l - num);
                    if (r >= 0) continue;
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Can not read full content of " + name + " entry. Length = " + l + ", read num = " + num));
                    break;
                }
                RemoteClass.access$102(rc, bytes);
                rcl.add(rc);
            }
            ArrayList<RemoteClass> arrayList = rcl;
            return arrayList;
        }
    }

    private static ArrayReference createTargetBytes(VirtualMachine vm, byte[] bytes, ByteValue[] mirrorBytesCache) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        ArrayType bytesArrayClass = RemoteServices.getArrayClass(vm, "byte[]");
        ArrayReference array = null;
        boolean disabledCollection = false;
        while (!disabledCollection) {
            array = ArrayTypeWrapper.newInstance((ArrayType)bytesArrayClass, (int)bytes.length);
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)array);
                disabledCollection = true;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
        }
        ArrayList<ByteValue> values = new ArrayList<ByteValue>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            ByteValue mb = mirrorBytesCache[128 + b];
            if (mb == null) {
                mirrorBytesCache[128 + b] = mb = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (byte)b);
            }
            values.add(mb);
        }
        ArrayReferenceWrapper.setValues((ArrayReference)array, values);
        return array;
    }

    private static class AutoresumeTask
    implements Runnable,
    PropertyChangeListener {
        private static final int WAIT_TIME = 500;
        private volatile JPDAThreadImpl t;

        public AutoresumeTask(JPDAThreadImpl t) {
            this.t = t;
            t.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl thread = this.t;
            if (thread == null) {
                return;
            }
            if ("suspended".equals(evt.getPropertyName()) && !"methodInvoke".equals(evt.getPropagationId())) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                logger.fine("AutoresumeTask: autoresume canceled, thread changed suspended state: suspended = " + thread.isSuspended());
                Map map = tasksByThreads;
                synchronized (map) {
                    tasksByThreads.remove(thread);
                }
                this.t = null;
            }
        }

        @Override
        public void run() {
            JPDAThreadImpl thread = this.t;
            this.t = null;
            if (thread != null) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                thread.resume();
            }
        }
    }

    private static class RemoteClass {
        private String name;
        private byte[] bytes;

        private RemoteClass() {
        }

        static /* synthetic */ byte[] access$102(RemoteClass x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    public static enum ServiceType {
        AWT,
        FX;

    }

    private static class RemoteServiceDebuggerListener
    implements PropertyChangeListener {
        private RemoteServiceDebuggerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDADebugger d;
            if ("state".equals(evt.getPropertyName()) && 4 == (d = (JPDADebugger)evt.getSource()).getState()) {
                d.removePropertyChangeListener((PropertyChangeListener)this);
                Map map = remoteServiceClasses;
                synchronized (map) {
                    remoteServiceClasses.remove(d);
                }
            }
        }
    }

    public static class RemoteListener {
        private String type;
        private List<String> allTypesList;
        private String[] allTypes;
        private ObjectReference l;

        public RemoteListener(String type, ObjectReference l) {
            this.type = type;
            this.l = l;
        }

        public String getType() {
            return this.type;
        }

        public void setAllTypes(String[] allTypes) {
            this.allTypes = allTypes;
        }

        private void addType(String listenerType) {
            if (this.allTypesList == null) {
                this.allTypesList = new ArrayList<String>();
                this.allTypesList.add(this.type);
            }
            this.allTypesList.add(listenerType);
        }

        public String[] getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.allTypesList != null ? this.allTypesList.toArray(new String[0]) : new String[]{this.type};
            }
            return this.allTypes;
        }

        public ObjectReference getListener() {
            return this.l;
        }

        public String toString() {
            return "RemoteListener(" + this.type + ")[" + this.l + "]";
        }
    }

    public static interface LoggingListenerCallBack {
        public void eventsData(String[] var1, String[] var2);

        public ObjectReference getListenerObject();
    }

    private static final class LoggingListeners {
        private final Map<ObjectReference, Map<ClassObjectReference, Set<LoggingListenerCallBack>>> componentListeners = new HashMap<ObjectReference, Map<ClassObjectReference, Set<LoggingListenerCallBack>>>();

        private LoggingListeners() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static LoggingListeners get(JPDADebugger dbg) {
            Map map = loggingListeners;
            synchronized (map) {
                return (LoggingListeners)loggingListeners.get(dbg);
            }
        }

        private synchronized boolean add(ObjectReference component, ClassObjectReference listenerClass, LoggingListenerCallBack listener) {
            Set<LoggingListenerCallBack> lcb;
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                listeners = new HashMap<ClassObjectReference, Set<LoggingListenerCallBack>>();
                this.componentListeners.put(component, listeners);
            }
            if ((lcb = listeners.get(listenerClass)) == null) {
                lcb = new HashSet<LoggingListenerCallBack>();
                listeners.put(listenerClass, lcb);
            }
            return lcb.add(listener);
        }

        private synchronized boolean remove(ObjectReference component, ClassObjectReference listenerClass, LoggingListenerCallBack listener) {
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                return false;
            }
            Set<LoggingListenerCallBack> lcb = listeners.get(listenerClass);
            if (lcb == null) {
                return false;
            }
            boolean removed = lcb.remove(listener);
            if (removed && lcb.isEmpty()) {
                listeners.remove(listenerClass);
                if (listeners.isEmpty()) {
                    this.componentListeners.remove(component);
                }
            }
            return removed;
        }

        synchronized Set<LoggingListenerCallBack> getListeners(ObjectReference component, ClassObjectReference listenerClass) {
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                return null;
            }
            return new HashSet<LoggingListenerCallBack>((Collection)listeners.get(listenerClass));
        }

        private synchronized boolean isEmpty() {
            return this.componentListeners.isEmpty();
        }
    }
}

