/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.api.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.search.api.transport.Transport;

public class Java11HttpClientTransport
implements Transport {
    private final Duration timeout;
    private final HttpClient client;

    public Java11HttpClientTransport() {
        this(Duration.ofSeconds(10L));
    }

    public Java11HttpClientTransport(Duration timeout) {
        this(timeout, HttpClient.newBuilder().connectTimeout(timeout).followRedirects(HttpClient.Redirect.NEVER).build());
    }

    public Java11HttpClientTransport(Duration timeout, HttpClient client) {
        this.timeout = Objects.requireNonNull(timeout);
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public Transport.Response get(String serviceUri, Map<String, String> headers) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(this.timeout).uri(URI.create(serviceUri)).GET();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        HttpRequest request = builder.build();
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return new ResponseImpl(response, response.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public Transport.Response head(String serviceUri, Map<String, String> headers) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(this.timeout).uri(URI.create(serviceUri)).method("HEAD", HttpRequest.BodyPublishers.noBody());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        HttpRequest request = builder.build();
        try {
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            return new ResponseImpl(response, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private static class ResponseImpl
    implements Transport.Response {
        private final HttpResponse<?> response;
        private final InputStream inputStream;

        private ResponseImpl(HttpResponse<?> response, InputStream inputStream) {
            this.response = Objects.requireNonNull(response);
            this.inputStream = inputStream;
        }

        @Override
        public int getCode() {
            return this.response.statusCode();
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.response.headers().map().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), (String)((List)e.getValue()).get(0))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        }

        @Override
        public InputStream getBody() {
            return this.inputStream;
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

