/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class MavenFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private final Project project;
    private static final String ENCODING_PARAM = "encoding";
    private final Map<FileObject, Charset> cache = new HashMap<FileObject, Charset>();
    private final AtomicBoolean listenerAttached = new AtomicBoolean(false);

    public MavenFileEncodingQueryImpl(Project proj) {
        this.project = proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getEncoding(FileObject file) {
        if (this.listenerAttached.compareAndSet(false, true)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        Map map = MavenFileEncodingQueryImpl.this.cache;
                        synchronized (map) {
                            MavenFileEncodingQueryImpl.this.cache.clear();
                        }
                    }
                }
            });
        }
        MavenProject mp = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        Map<FileObject, Charset> map = this.cache;
        synchronized (map) {
            for (Map.Entry<FileObject, Charset> ent : this.cache.entrySet()) {
                if (!ent.getKey().equals(file) && !FileUtil.isParentOf((FileObject)ent.getKey(), (FileObject)file)) continue;
                return ent.getValue();
            }
        }
        try {
            FileObject root;
            String testcompileEnc;
            String compileEnc;
            FileObject src = FileUtilities.convertStringToFileObject(mp.getBuild().getSourceDirectory());
            if (src != null && (src.equals(file) || FileUtil.isParentOf((FileObject)src, (FileObject)file)) && (compileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "compile", "project.build.sourceEncoding")) != null && compileEnc.indexOf("${") == -1) {
                Charset ch = Charset.forName(compileEnc);
                this.addToCache(src, ch);
                return ch;
            }
            FileObject testsrc = FileUtilities.convertStringToFileObject(mp.getBuild().getTestSourceDirectory());
            if (testsrc != null && (testsrc.equals(file) || FileUtil.isParentOf((FileObject)testsrc, (FileObject)file)) && (testcompileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "testCompile", "project.build.sourceEncoding")) != null && testcompileEnc.indexOf("${") == -1) {
                Charset ch = Charset.forName(testcompileEnc);
                this.addToCache(testsrc, ch);
                return ch;
            }
            NbMavenProjectImpl impl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
            try {
                String resourceEnc;
                root = this.isWithin(impl.getResources(false), file);
                if (root != null && (resourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "resources", "project.build.sourceEncoding")) != null && resourceEnc.indexOf("${") == -1) {
                    Charset ch = Charset.forName(resourceEnc);
                    this.addToCache(root, ch);
                    return ch;
                }
            }
            catch (MalformedURLException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            try {
                String testresourceEnc;
                root = this.isWithin(impl.getResources(true), file);
                if (root != null && (testresourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "testResources", "project.build.sourceEncoding")) != null && testresourceEnc.indexOf("${") == -1) {
                    Charset ch = Charset.forName(testresourceEnc);
                    this.addToCache(root, ch);
                    return ch;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            try {
                String siteEnc;
                root = this.isWithin(new URI[]{impl.getSiteDirectory()}, file);
                if (root != null && (siteEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-site-plugin", "inputEncoding", "site", "project.build.sourceEncoding")) != null && siteEnc.indexOf("${") == -1) {
                    Charset ch = Charset.forName(siteEnc);
                    this.addToCache(root, ch);
                    return ch;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            String defEnc = mp.getProperties().getProperty("project.build.sourceEncoding");
            if (defEnc != null) {
                return Charset.forName(defEnc);
            }
        }
        catch (UnsupportedCharsetException uce) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, uce.getMessage(), uce);
        }
        catch (IllegalCharsetNameException icne) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, icne.getMessage(), icne);
        }
        return Charset.defaultCharset();
    }

    private FileObject isWithin(URI[] res, FileObject file) throws MalformedURLException {
        for (URI ur : res) {
            FileObject fo = URLMapper.findFileObject((URL)ur.toURL());
            if (fo == null || !fo.equals(file) && !FileUtil.isParentOf((FileObject)fo, (FileObject)file)) continue;
            return fo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(FileObject src, Charset ch) {
        Map<FileObject, Charset> map = this.cache;
        synchronized (map) {
            this.cache.put(src, ch);
        }
    }
}

