/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.Bundle;
import org.netbeans.modules.maven.options.NetworkProxySettings;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

public final class MavenSettings {
    private static final String PROP_DEFAULT_OPTIONS = "defaultOptions";
    private static final String PROP_SOURCE_DOWNLOAD = "sourceDownload";
    private static final String PROP_JAVADOC_DOWNLOAD = "javadocDownload";
    private static final String PROP_BINARY_DOWNLOAD = "binaryDownload";
    private static final String PROP_LAST_ARCHETYPE_GROUPID = "lastArchetypeGroupId";
    private static final String PROP_LAST_ARCHETYPE_VERSION = "lastArchetypeVersion";
    private static final String PROP_SKIP_TESTS = "skipTests";
    private static final String PROP_MAVEN_RUNTIMES = "mavenRuntimes";
    public static final String PROP_PROJECTNODE_NAME_PATTERN = "project.displayName";
    private static final String PROP_ALWAYS_OUTPUT = "alwaysShowOutput";
    private static final String PROP_SHOW_LOGGING_LEVEL = "showLoggingLevel";
    private static final String PROP_REUSE_OUTPUT = "reuseOutputTabs";
    private static final String PROP_COLLAPSE_FOLDS = "collapseSuccessFolds";
    private static final String PROP_OUTPUT_TAB_CONFIG = "showConfigInOutputTab";
    private static final String PROP_OUTPUT_TAB_NAME = "showOutputTabAs";
    private static final String PROP_VM_OPTIONS_WRAP = "vmOptionsWrap";
    private static final String PROP_DEFAULT_JDK = "defaultJdk";
    private static final String PROP_PREFER_WRAPPER = "preferWrapper";
    private static final String PROP_DEBUG = "showDebug";
    private static final String PROP_ERRORS = "showErrors";
    private static final String PROP_CHECKSUM_POLICY = "checksumPolicy";
    private static final String PROP_PLUGIN_POLICY = "pluginUpdatePolicy";
    private static final String PROP_FAILURE_BEHAVIOUR = "failureBehaviour";
    private static final String PROP_USE_REGISTRY = "usePluginRegistry";
    public static final String PROP_NETWORK_PROXY = "networkProxy";
    private static final Pattern MAVEN_CORE_JAR_PATTERN;
    private static final MavenSettings INSTANCE;
    private final Set<PropertyChangeListener> listeners = new WeakSet();
    private static final String SYSPROP_DEFAULT_PROXY_BEHAVIOUR = "netbeans.networkProxy";
    private static final NetworkProxySettings DEFAULT_PROXY_BEHAVIOUR;

    public static MavenSettings getDefault() {
        return INSTANCE;
    }

    public boolean isInteractive() {
        return !this.hasOption("--batch", "-B");
    }

    public Boolean isOffline() {
        if (this.hasOption("--offline", "-o")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean isShowDebug() {
        return this.hasOption("--debug", "-X");
    }

    public boolean isShowErrors() {
        return this.hasOption("--errors", "-e");
    }

    public boolean isUpdateSnapshots() {
        return this.hasOption("--update-snapshots", "-U");
    }

    private boolean hasOption(String longName, String shortName) {
        String defOpts = this.getDefaultOptions();
        if (defOpts != null) {
            try {
                String[] strs;
                for (String s : strs = CommandLineUtils.translateCommandline((String)defOpts)) {
                    if (!(s = s.trim()).startsWith(shortName) && !s.startsWith(longName)) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MavenSettings.class.getName()).log(Level.FINE, "Error parsing global options:{0}", defOpts);
                return defOpts.contains(longName) || defOpts.contains(shortName);
            }
        }
        return false;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MavenSettings.class);
    }

    private String putProperty(String key, String value) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    private String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    private MavenSettings() {
        String defOpts = this.getPreferences().get(PROP_DEFAULT_OPTIONS, null);
        if (defOpts == null) {
            String registry;
            String pluginUpdate;
            String fail;
            String checksum;
            String error;
            defOpts = this.getDefaultOptions();
            String debug = this.getPreferences().get(PROP_DEBUG, null);
            if (debug != null) {
                boolean val = Boolean.parseBoolean(debug);
                if (val) {
                    defOpts = defOpts + " --debug";
                }
                this.getPreferences().remove(PROP_DEBUG);
            }
            if ((error = this.getPreferences().get(PROP_ERRORS, null)) != null) {
                boolean val = Boolean.parseBoolean(error);
                if (val) {
                    defOpts = defOpts + " --errors";
                }
                this.getPreferences().remove(PROP_ERRORS);
            }
            if ((checksum = this.getPreferences().get(PROP_CHECKSUM_POLICY, null)) != null) {
                if ("fail".equals(checksum)) {
                    defOpts = defOpts + " --strict-checksums";
                } else if ("warn".equals(checksum)) {
                    defOpts = defOpts + " --lax-checksums";
                }
                this.getPreferences().remove(PROP_CHECKSUM_POLICY);
            }
            if ((fail = this.getPreferences().get(PROP_FAILURE_BEHAVIOUR, null)) != null) {
                if ("FAIL_NEVER".equals(fail)) {
                    defOpts = defOpts + " --fail-never";
                } else if ("FAIL_FAST".equals(fail)) {
                    defOpts = defOpts + " --fail-fast";
                } else if ("FAIL_AT_END".equals(fail)) {
                    defOpts = defOpts + " --fail-at-end";
                }
                this.getPreferences().remove(PROP_FAILURE_BEHAVIOUR);
            }
            if ((pluginUpdate = this.getPreferences().get(PROP_PLUGIN_POLICY, null)) != null) {
                defOpts = Boolean.parseBoolean(pluginUpdate) ? defOpts + " --check-plugin-updates" : defOpts + " --no-plugin-updates";
                this.getPreferences().remove(PROP_PLUGIN_POLICY);
            }
            if ((registry = this.getPreferences().get(PROP_USE_REGISTRY, null)) != null) {
                if (!Boolean.parseBoolean(registry)) {
                    defOpts = defOpts + " --no-plugin-registry";
                }
                this.getPreferences().remove(PROP_USE_REGISTRY);
            }
            this.setDefaultOptions(defOpts);
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public String getDefaultOptions() {
        return this.getPreferences().get(PROP_DEFAULT_OPTIONS, "--no-transfer-progress");
    }

    public void setDefaultOptions(String options) {
        String old = this.getDefaultOptions();
        this.putProperty(PROP_DEFAULT_OPTIONS, options);
        if (!old.equals(options)) {
            EmbedderFactory.resetCachedEmbedders();
        }
    }

    public boolean isVMOptionsWrap() {
        return this.getPreferences().getBoolean(PROP_VM_OPTIONS_WRAP, true);
    }

    public void setVMOptionsWrap(boolean b) {
        this.getPreferences().putBoolean(PROP_VM_OPTIONS_WRAP, b);
    }

    public String getDefaultJdk() {
        return this.getPreferences().get(PROP_DEFAULT_JDK, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultJdk(String jdk) {
        this.getPreferences().put(PROP_DEFAULT_JDK, jdk);
        PropertyChangeListener[] propertyChangeListenerArray = this.listeners;
        synchronized (this.listeners) {
            PropertyChangeListener[] arr = this.listeners.toArray(new PropertyChangeListener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PropertyChangeListener l : arr) {
                l.propertyChange(new PropertyChangeEvent(this, PROP_DEFAULT_JDK, null, jdk));
            }
            return;
        }
    }

    public String getLastArchetypeGroupId() {
        return this.getPreferences().get(PROP_LAST_ARCHETYPE_GROUPID, Boolean.getBoolean("netbeans.full.hack") ? "test" : "com.mycompany");
    }

    public void setLastArchetypeGroupId(String groupId) {
        this.putProperty(PROP_LAST_ARCHETYPE_GROUPID, groupId);
    }

    public boolean isSkipTests() {
        return this.getPreferences().getBoolean(PROP_SKIP_TESTS, false);
    }

    public void setSkipTests(boolean skipped) {
        this.getPreferences().putBoolean(PROP_SKIP_TESTS, skipped);
    }

    public boolean isAlwaysShowOutput() {
        return this.getPreferences().getBoolean(PROP_ALWAYS_OUTPUT, true);
    }

    public void setAlwaysShowOutput(boolean show) {
        this.getPreferences().putBoolean(PROP_ALWAYS_OUTPUT, show);
    }

    public boolean isShowLoggingLevel() {
        return this.getPreferences().getBoolean(PROP_SHOW_LOGGING_LEVEL, false);
    }

    public void setShowLoggingLevel(boolean show) {
        this.getPreferences().putBoolean(PROP_SHOW_LOGGING_LEVEL, show);
    }

    public boolean isReuseOutputTabs() {
        String def = Bundle.DEFAULT_REUSE_OUTPUT();
        if ("never".equals(def)) {
            return false;
        }
        return this.getPreferences().getBoolean(PROP_REUSE_OUTPUT, "true".equals(def));
    }

    public void setReuseOutputTabs(boolean reuse) {
        this.getPreferences().putBoolean(PROP_REUSE_OUTPUT, reuse);
    }

    public String getLastArchetypeVersion() {
        return this.getPreferences().get(PROP_LAST_ARCHETYPE_VERSION, "1.0-SNAPSHOT");
    }

    public void setLastArchetypeVersion(String version) {
        this.putProperty(PROP_LAST_ARCHETYPE_VERSION, version);
    }

    public void setProjectNodeNamePattern(String pattern) {
        if (null == pattern) {
            this.getPreferences().remove(PROP_PROJECTNODE_NAME_PATTERN);
        } else {
            this.putProperty(PROP_PROJECTNODE_NAME_PATTERN, pattern);
        }
    }

    public String getProjectNodeNamePattern() {
        return this.getPreferences().get(PROP_PROJECTNODE_NAME_PATTERN, null);
    }

    public boolean isPreferMavenWrapper() {
        return this.getPreferences().getBoolean(PROP_PREFER_WRAPPER, true);
    }

    public void setPreferMavenWrapper(boolean preferWrapper) {
        this.getPreferences().putBoolean(PROP_PREFER_WRAPPER, preferWrapper);
    }

    @Deprecated
    public boolean isUseBestMaven() {
        return false;
    }

    @Deprecated
    public void setUseBestMaven(boolean bestMaven) {
    }

    @Deprecated
    public boolean isUseBestMavenAltLocation() {
        return false;
    }

    @Deprecated
    public void setUseBestMavenAltLocation(boolean bestMavenAltLocation) {
    }

    @Deprecated
    public void setBestMavenAltLocation(String location) {
    }

    @Deprecated
    public String getBestMavenAltLocation() {
        return null;
    }

    public boolean isCollapseSuccessFolds() {
        return this.getPreferences().getBoolean(PROP_COLLAPSE_FOLDS, false);
    }

    public void setCollapseSuccessFolds(boolean collapse) {
        this.getPreferences().putBoolean(PROP_COLLAPSE_FOLDS, collapse);
    }

    public void setOutputTabShowConfig(boolean selected) {
        this.getPreferences().putBoolean(PROP_OUTPUT_TAB_CONFIG, selected);
    }

    public boolean isOutputTabShowConfig() {
        return this.getPreferences().getBoolean(PROP_OUTPUT_TAB_CONFIG, false);
    }

    public OutputTabName getOutputTabName() {
        String val = this.getPreferences().get(PROP_OUTPUT_TAB_NAME, OutputTabName.PROJECT_NAME.name());
        try {
            return OutputTabName.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return OutputTabName.PROJECT_NAME;
        }
    }

    public void setOutputTabName(OutputTabName ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_OUTPUT_TAB_NAME, ds.name());
        } else {
            this.getPreferences().remove(PROP_OUTPUT_TAB_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakPropertyChangeListener(PropertyChangeListener l) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public DownloadStrategy getSourceDownloadStrategy() {
        String val = this.getPreferences().get(PROP_SOURCE_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setSourceDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_SOURCE_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_SOURCE_DOWNLOAD);
        }
    }

    public DownloadStrategy getJavadocDownloadStrategy() {
        String val = this.getPreferences().get(PROP_JAVADOC_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setJavadocDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_JAVADOC_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_JAVADOC_DOWNLOAD);
        }
    }

    public DownloadStrategy getBinaryDownloadStrategy() {
        String val = this.getPreferences().get(PROP_BINARY_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setBinaryDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_BINARY_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_BINARY_DOWNLOAD);
        }
    }

    @CheckForNull
    public static String getCommandLineMavenVersion() {
        return MavenSettings.getCommandLineMavenVersion(EmbedderFactory.getMavenHome());
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public static String getCommandLineMavenVersion(File mavenHome) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isMavenDaemon(Path mavenHome) {
        String mvndExecutableName = Utilities.isWindows() ? "mvnd.exe" : "mvnd";
        return Files.exists(mavenHome.resolve("bin").resolve(mvndExecutableName), new LinkOption[0]);
    }

    private static List<String> searchMavenRuntimes(String[] paths, boolean stopOnFirstValid) {
        ArrayList<String> runtimes = new ArrayList<String>();
        for (String path : paths) {
            File file = new File(path);
            path = FileUtil.normalizeFile((File)file).getAbsolutePath();
            String version = MavenSettings.getCommandLineMavenVersion(file);
            if (version == null) continue;
            runtimes.add(path);
            if (stopOnFirstValid) break;
        }
        return runtimes;
    }

    public static String getDefaultExternalMavenRuntime() {
        List<String> runtimes;
        String paths = System.getenv("PATH");
        String mavenHome = System.getenv("MAVEN_HOME");
        String m2Home = System.getenv("M2_HOME");
        ArrayList<String> mavenEnvDirs = new ArrayList<String>();
        if (mavenHome != null) {
            mavenEnvDirs.add(mavenHome);
        }
        if (m2Home != null) {
            mavenEnvDirs.add(m2Home);
        }
        if (paths != null) {
            for (String path : paths.split(File.pathSeparator)) {
                if (!path.endsWith("bin")) continue;
                if (path.equals("/bin") || path.equals("bin")) {
                    mavenEnvDirs.add(path);
                    continue;
                }
                mavenEnvDirs.add(path.substring(0, path.length() - "bin".length() - File.pathSeparator.length()));
            }
        }
        return !(runtimes = MavenSettings.searchMavenRuntimes(mavenEnvDirs.toArray(new String[0]), true)).isEmpty() ? runtimes.get(0) : null;
    }

    public List<String> getUserDefinedMavenRuntimes() {
        ArrayList<String> runtimes = new ArrayList<String>();
        String defaultRuntimePath = MavenSettings.getDefaultExternalMavenRuntime();
        String runtimesPref = this.getPreferences().get(PROP_MAVEN_RUNTIMES, null);
        if (runtimesPref != null) {
            for (String runtimePath : runtimesPref.split(File.pathSeparator)) {
                if ("".equals(runtimePath) || runtimePath.equals(defaultRuntimePath)) continue;
                runtimes.add(runtimePath);
            }
        }
        return Collections.unmodifiableList(runtimes);
    }

    public void setMavenRuntimes(List<String> runtimes) {
        if (runtimes == null) {
            this.getPreferences().remove(PROP_MAVEN_RUNTIMES);
        } else {
            String runtimesPref = "";
            for (String path : runtimes) {
                runtimesPref = runtimesPref + path + File.pathSeparator;
            }
            if (runtimesPref.endsWith(File.pathSeparator)) {
                runtimesPref = runtimesPref.substring(0, runtimesPref.length() - 1);
            }
            this.putProperty(PROP_MAVEN_RUNTIMES, runtimesPref);
        }
    }

    public NetworkProxySettings getNetworkProxy() {
        String s = this.getPreferences().get(PROP_NETWORK_PROXY, DEFAULT_PROXY_BEHAVIOUR.name());
        try {
            return NetworkProxySettings.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_PROXY_BEHAVIOUR;
        }
    }

    public void setNetworkProxy(NetworkProxySettings s) {
        this.getPreferences().put(PROP_NETWORK_PROXY, s.name());
    }

    private static /* synthetic */ boolean lambda$getCommandLineMavenVersion$5(Path file) {
        return file.toString().endsWith(".jar");
    }

    private static /* synthetic */ String lambda$getCommandLineMavenVersion$4(Matcher matcher) {
        return matcher.group(1);
    }

    private static /* synthetic */ boolean lambda$getCommandLineMavenVersion$3(Matcher matcher) {
        return matcher.matches();
    }

    private static /* synthetic */ Matcher lambda$getCommandLineMavenVersion$2(String file) {
        return MAVEN_CORE_JAR_PATTERN.matcher(file);
    }

    private static /* synthetic */ boolean lambda$getCommandLineMavenVersion$1(String file) {
        return file.startsWith("maven-core");
    }

    private static /* synthetic */ String lambda$getCommandLineMavenVersion$0(Path file) {
        return file.getFileName().toString();
    }

    static {
        NetworkProxySettings def;
        MAVEN_CORE_JAR_PATTERN = Pattern.compile("maven-core-(\\d+\\.\\d+\\.\\d+)\\.jar");
        INSTANCE = new MavenSettings();
        try {
            def = NetworkProxySettings.valueOf(System.getProperty(SYSPROP_DEFAULT_PROXY_BEHAVIOUR, NetworkProxySettings.ASK.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            def = NetworkProxySettings.ASK;
        }
        DEFAULT_PROXY_BEHAVIOUR = def;
    }

    public static enum OutputTabName {
        PROJECT_NAME,
        PROJECT_ID;

    }

    public static enum DownloadStrategy {
        NEVER,
        FIRST_OPEN,
        EVERY_OPEN;

    }
}

