/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;

public class NamedNativeQueryMementoImpl
extends AbstractNamedQueryMemento
implements NamedNativeQueryMemento {
    private final String sqlString;
    private final String originalSqlString;
    private final String resultSetMappingName;
    private final Class<?> resultSetMappingClass;
    private final Set<String> querySpaces;
    private final Integer firstResult;
    private final Integer maxResults;

    public NamedNativeQueryMementoImpl(String name, String sqlString, String originalSqlString, String resultSetMappingName, Class<?> resultSetMappingClass, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, Integer timeout, Integer fetchSize, String comment, Integer firstResult, Integer maxResults, Map<String, Object> hints) {
        super(name, cacheable, cacheRegion, cacheMode, flushMode, readOnly, timeout, fetchSize, comment, hints);
        this.sqlString = sqlString;
        this.originalSqlString = originalSqlString;
        this.resultSetMappingName = resultSetMappingName == null || resultSetMappingName.isEmpty() ? null : resultSetMappingName;
        this.resultSetMappingClass = resultSetMappingClass;
        this.querySpaces = querySpaces;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    public String getResultSetMappingName() {
        return this.resultSetMappingName;
    }

    public Class<?> getResultSetMappingClass() {
        return this.resultSetMappingClass;
    }

    @Override
    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public String getSqlString() {
        return this.sqlString;
    }

    @Override
    public String getOriginalSqlString() {
        return this.originalSqlString;
    }

    @Override
    public String getResultMappingName() {
        return this.resultSetMappingName;
    }

    @Override
    public Class<?> getResultMappingClass() {
        return this.resultSetMappingClass;
    }

    @Override
    public Integer getFirstResult() {
        return this.firstResult;
    }

    @Override
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Override
    public NamedNativeQueryMemento makeCopy(String name) {
        return new NamedNativeQueryMementoImpl(name, this.sqlString, this.originalSqlString, this.resultSetMappingName, this.resultSetMappingClass, this.querySpaces, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getFirstResult(), this.getMaxResults(), this.getHints());
    }

    @Override
    public void validate(QueryEngine queryEngine) {
    }

    @Override
    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor session) {
        return new NativeQueryImpl(this, session);
    }

    @Override
    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> resultType) {
        return new NativeQueryImpl<T>((NamedNativeQueryMemento)this, resultType, session);
    }

    @Override
    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor session, String resultSetMappingName) {
        return new NativeQueryImpl((NamedNativeQueryMemento)this, resultSetMappingName, session);
    }
}

