/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

public class LoaderSqlAstCreationState
implements SqlAstQueryPartProcessingState,
SqlAstCreationState,
DomainResultCreationState,
QueryOptions {
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private final boolean forceIdentifierSelection;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final SqlAstCreationContext sf;
    private final SqlAstQueryPartProcessingStateImpl processingState;
    private final FromClauseAccess fromClauseAccess;
    private final LockOptions lockOptions;
    private final FetchProcessor fetchProcessor;
    private boolean resolvingCircularFetch;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private final Set<AssociationKey> visitedAssociationKeys = new HashSet<AssociationKey>();

    public LoaderSqlAstCreationState(QueryPart queryPart, SqlAliasBaseManager sqlAliasBaseManager, FromClauseAccess fromClauseAccess, LockOptions lockOptions, FetchProcessor fetchProcessor, boolean forceIdentifierSelection, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext sf) {
        this.sqlAliasBaseManager = sqlAliasBaseManager;
        this.fromClauseAccess = fromClauseAccess;
        this.lockOptions = lockOptions;
        this.fetchProcessor = fetchProcessor;
        this.forceIdentifierSelection = forceIdentifierSelection;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.sf = sf;
        this.processingState = new SqlAstQueryPartProcessingStateImpl(queryPart, null, this, () -> Clause.IRRELEVANT, true);
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.sf;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this;
    }

    @Override
    public QueryPart getInflightQueryPart() {
        return this.processingState.getInflightQueryPart();
    }

    @Override
    public void registerTreatedFrom(SqmFrom<?, ?> sqmFrom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerFromUsage(SqmFrom<?, ?> sqmFrom, boolean downgradeTreatUses) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<SqmFrom<?, ?>, Boolean> getFromRegistrations() {
        return Collections.emptyMap();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.processingState;
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public void registerLockMode(String identificationVariable, LockMode explicitLockMode) {
        throw new UnsupportedOperationException("Registering lock modes should only be done for result set mappings");
    }

    @Override
    public ImmutableFetchList visitFetches(FetchParent fetchParent) {
        return this.fetchProcessor.visitFetches(fetchParent, this);
    }

    @Override
    public ImmutableFetchList visitNestedFetches(FetchParent fetchParent) {
        FetchParent nestingFetchParent = this.processingState.getNestingFetchParent();
        this.processingState.setNestingFetchParent(fetchParent);
        ImmutableFetchList fetches = this.fetchProcessor.visitFetches(fetchParent, this);
        this.processingState.setNestingFetchParent(nestingFetchParent);
        return fetches;
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    @Override
    public boolean forceIdentifierSelection() {
        return this.forceIdentifierSelection;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public boolean registerVisitedAssociationKey(AssociationKey associationKey) {
        return this.visitedAssociationKeys.add(associationKey);
    }

    @Override
    public void removeVisitedAssociationKey(AssociationKey associationKey) {
        this.visitedAssociationKeys.remove(associationKey);
    }

    @Override
    public boolean isAssociationKeyVisited(AssociationKey associationKey) {
        return this.visitedAssociationKeys.contains(associationKey);
    }

    @Override
    public boolean isRegisteringVisitedAssociationKeys() {
        return true;
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.fromClauseAccess.findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Integer getTimeout() {
        return null;
    }

    @Override
    public FlushMode getFlushMode() {
        return null;
    }

    @Override
    public Boolean isReadOnly() {
        return null;
    }

    @Override
    public AppliedGraph getAppliedGraph() {
        return null;
    }

    @Override
    public TupleTransformer<?> getTupleTransformer() {
        return null;
    }

    @Override
    public ResultListTransformer<?> getResultListTransformer() {
        return null;
    }

    @Override
    public Boolean isResultCachingEnabled() {
        return false;
    }

    @Override
    public Boolean getQueryPlanCachingEnabled() {
        return null;
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return CacheRetrieveMode.BYPASS;
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return CacheStoreMode.BYPASS;
    }

    @Override
    public String getResultCacheRegionName() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return null;
    }

    @Override
    public Set<String> getEnabledFetchProfiles() {
        return null;
    }

    @Override
    public Set<String> getDisabledFetchProfiles() {
        return null;
    }

    public static interface FetchProcessor {
        public ImmutableFetchList visitFetches(FetchParent var1, LoaderSqlAstCreationState var2);
    }
}

