/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class StripSecretsUtils {
    private static final Pattern VAULT_VALUE = Pattern.compile("^\\$\\{vault\\.(.+?)}$");
    private static final Map<Class<?>, BiConsumer<KeycloakSession, Object>> REPRESENTATION_FORMATTER = new HashMap();

    public static <T> T stripSecrets(KeycloakSession session, T representation) {
        BiConsumer<KeycloakSession, Object> formatter = REPRESENTATION_FORMATTER.get(representation.getClass());
        if (formatter == null) {
            return representation;
        }
        formatter.accept(session, representation);
        return representation;
    }

    private static String maskNonVaultValue(String value) {
        return value == null ? null : (VAULT_VALUE.matcher(value).matches() ? value : "**********");
    }

    private static ComponentRepresentation stripComponent(KeycloakSession session, ComponentRepresentation rep) {
        Map<String, ProviderConfigProperty> configProperties = ComponentUtil.getComponentConfigProperties(session, rep);
        return StripSecretsUtils.stripComponent(configProperties, rep);
    }

    protected static ComponentRepresentation stripComponent(Map<String, ProviderConfigProperty> configProperties, ComponentRepresentation rep) {
        if (rep.getConfig() != null) {
            StripSecretsUtils.stripComponentConfigMap((MultivaluedHashMap<String, String>)rep.getConfig(), configProperties);
        }
        return rep;
    }

    private static void stripComponentConfigMap(MultivaluedHashMap<String, String> configMap, Map<String, ProviderConfigProperty> configProperties) {
        Iterator itr = configMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry next = (Map.Entry)itr.next();
            ProviderConfigProperty configProperty = configProperties.get(next.getKey());
            if (configProperty != null) {
                if (!configProperty.isSecret()) continue;
                if (next.getValue() == null || ((List)next.getValue()).isEmpty()) {
                    next.setValue(Collections.singletonList("**********"));
                    continue;
                }
                next.setValue(((List)next.getValue()).stream().map(StripSecretsUtils::maskNonVaultValue).collect(Collectors.toList()));
                continue;
            }
            itr.remove();
        }
    }

    private static Map<String, String> stripFromMap(Map<String, String> map, String key) {
        if (map != null && map.containsKey(key)) {
            map.put(key, StripSecretsUtils.maskNonVaultValue(map.get(key)));
        }
        return map;
    }

    protected static IdentityProviderRepresentation stripBroker(IdentityProviderRepresentation rep) {
        StripSecretsUtils.stripFromMap(rep.getConfig(), "clientSecret");
        return rep;
    }

    private static RealmRepresentation stripRealm(RealmRepresentation rep) {
        StripSecretsUtils.stripFromMap(rep.getSmtpServer(), "password");
        return rep;
    }

    private static void stripRealm(KeycloakSession session, RealmRepresentation rep) {
        StripSecretsUtils.stripRealm(session, rep, ComponentUtil::getComponentConfigProperties);
    }

    protected static void stripRealm(KeycloakSession session, RealmRepresentation rep, GetComponentPropertiesFn fnGetConfigProperties) {
        StripSecretsUtils.stripRealm(rep);
        Optional.ofNullable(rep.getClients()).ifPresent(clients -> clients.forEach(StripSecretsUtils::stripClient));
        Optional.ofNullable(rep.getIdentityProviders()).ifPresent(providers -> providers.forEach(StripSecretsUtils::stripBroker));
        Optional.ofNullable(rep.getComponents()).ifPresent(components -> components.forEach((providerType, componentList) -> componentList.forEach(component -> StripSecretsUtils.stripComponentExport(session, providerType, component, fnGetConfigProperties))));
        Optional.ofNullable(rep.getUsers()).ifPresent(users -> users.forEach(StripSecretsUtils::stripUser));
        Optional.ofNullable(rep.getFederatedUsers()).ifPresent(users -> users.forEach(StripSecretsUtils::stripUser));
    }

    protected static UserRepresentation stripUser(UserRepresentation user) {
        user.setCredentials(null);
        return user;
    }

    protected static ClientRepresentation stripClient(ClientRepresentation rep) {
        if (rep.getSecret() != null) {
            rep.setSecret(StripSecretsUtils.maskNonVaultValue(rep.getSecret()));
        }
        StripSecretsUtils.stripFromMap(rep.getAttributes(), "client.secret.rotated");
        return rep;
    }

    private static ComponentExportRepresentation stripComponentExport(KeycloakSession session, String providerType, ComponentExportRepresentation rep) {
        return StripSecretsUtils.stripComponentExport(session, providerType, rep, ComponentUtil::getComponentConfigProperties);
    }

    private static ComponentExportRepresentation stripComponentExport(KeycloakSession session, String providerType, ComponentExportRepresentation rep, GetComponentPropertiesFn fnGetConfigProperties) {
        Map<String, ProviderConfigProperty> configProperties = fnGetConfigProperties.getComponentProperties(session, providerType, rep.getProviderId());
        if (rep.getConfig() != null) {
            StripSecretsUtils.stripComponentConfigMap((MultivaluedHashMap<String, String>)rep.getConfig(), configProperties);
        }
        rep.getSubComponents().forEach((subCompProviderType, subCompProviders) -> subCompProviders.forEach(subComp -> StripSecretsUtils.stripComponentExport(session, subCompProviderType, subComp)));
        return rep;
    }

    static {
        REPRESENTATION_FORMATTER.put(RealmRepresentation.class, (session, o) -> StripSecretsUtils.stripRealm(session, (RealmRepresentation)o));
        REPRESENTATION_FORMATTER.put(UserRepresentation.class, (session, o) -> StripSecretsUtils.stripUser((UserRepresentation)o));
        REPRESENTATION_FORMATTER.put(ClientRepresentation.class, (session, o) -> StripSecretsUtils.stripClient((ClientRepresentation)o));
        REPRESENTATION_FORMATTER.put(IdentityProviderRepresentation.class, (session, o) -> StripSecretsUtils.stripBroker((IdentityProviderRepresentation)o));
        REPRESENTATION_FORMATTER.put(ComponentRepresentation.class, (session, o) -> StripSecretsUtils.stripComponent(session, (ComponentRepresentation)o));
    }

    protected static interface GetComponentPropertiesFn {
        public Map<String, ProviderConfigProperty> getComponentProperties(KeycloakSession var1, String var2, String var3);
    }
}

