/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DefaultChangesetCacheEvent;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class ChangesetCache
implements PreferenceChangedListener {
    private static final ChangesetCache INSTANCE = new ChangesetCache();
    private final Map<Integer, Changeset> cache = new HashMap<Integer, Changeset>();
    final CopyOnWriteArrayList<ChangesetCacheListener> listeners = new CopyOnWriteArrayList();

    private ChangesetCache() {
        Config.getPref().addPreferenceChangeListener(this);
    }

    public static ChangesetCache getInstance() {
        return INSTANCE;
    }

    public void addChangesetCacheListener(ChangesetCacheListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeChangesetCacheListener(ChangesetCacheListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireChangesetCacheEvent(ChangesetCacheEvent e) {
        for (ChangesetCacheListener l : this.listeners) {
            l.changesetCacheUpdated(e);
        }
    }

    private void update(Changeset cs, DefaultChangesetCacheEvent e) {
        if (cs == null) {
            return;
        }
        if (cs.isNew()) {
            return;
        }
        Changeset inCache = this.cache.get(cs.getId());
        if (inCache != null) {
            inCache.mergeFrom(cs);
            e.rememberUpdatedChangeset(inCache);
        } else {
            e.rememberAddedChangeset(cs);
            this.cache.put(cs.getId(), cs);
        }
    }

    public void update(Changeset cs) {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        this.update(cs, e);
        this.fireChangesetCacheEvent(e);
    }

    public void update(Collection<Changeset> changesets) {
        if (changesets == null || changesets.isEmpty()) {
            return;
        }
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : changesets) {
            this.update(cs, e);
        }
        this.fireChangesetCacheEvent(e);
    }

    public boolean contains(int id) {
        if (id <= 0) {
            return false;
        }
        return this.cache.get(id) != null;
    }

    public boolean contains(Changeset cs) {
        if (cs == null) {
            return false;
        }
        if (cs.isNew()) {
            return false;
        }
        return this.contains(cs.getId());
    }

    public Changeset get(int id) {
        return this.cache.get(id);
    }

    public Set<Changeset> getChangesets() {
        return new HashSet<Changeset>(this.cache.values());
    }

    private void remove(int id, DefaultChangesetCacheEvent e) {
        if (id <= 0) {
            return;
        }
        Changeset cs = this.cache.get(id);
        if (cs == null) {
            return;
        }
        this.cache.remove(id);
        e.rememberRemovedChangeset(cs);
    }

    public void remove(int id) {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        this.remove(id, e);
        if (!e.isEmpty()) {
            this.fireChangesetCacheEvent(e);
        }
    }

    public void remove(Changeset cs) {
        if (cs == null) {
            return;
        }
        if (cs.isNew()) {
            return;
        }
        this.remove(cs.getId());
    }

    public void remove(Collection<Changeset> changesets) {
        if (changesets == null) {
            return;
        }
        DefaultChangesetCacheEvent evt = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : changesets) {
            if (cs == null || cs.isNew()) continue;
            this.remove(cs.getId(), evt);
        }
        if (!evt.isEmpty()) {
            this.fireChangesetCacheEvent(evt);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : this.cache.values()) {
            e.rememberRemovedChangeset(cs);
        }
        this.cache.clear();
        this.fireChangesetCacheEvent(e);
    }

    public List<Changeset> getOpenChangesets() {
        return this.cache.values().stream().filter(Changeset::isOpen).collect(Collectors.toList());
    }

    public List<Changeset> getOpenChangesetsForCurrentUser() {
        if (UserIdentityManager.getInstance().isAnonymous()) {
            return this.getOpenChangesets();
        }
        return new ArrayList<Changeset>(SubclassFilteredCollection.filter(this.getOpenChangesets(), object -> UserIdentityManager.getInstance().isCurrentUser(object.getUser())));
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey() == null || !"osm-server.url".equals(e.getKey())) {
            return;
        }
        if (e.getOldValue() == null || e.getNewValue() == null || !e.getOldValue().equals(e.getNewValue())) {
            this.clear();
        }
    }
}

