/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ArknavX8ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_1G = new PatternBuilder().expression("(..),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([AV]),").number("(d+)(dd.d+)([NS]),").number("(d+)(dd.d+)([EW]),").number("(d+.d+),").number("(d+),").number("(d+.d+),").number("(d+)").compile();
    private static final Pattern PATTERN_2G = new PatternBuilder().expression("..,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(d+.d+),").number("(d+.d+)").compile();

    public ArknavX8ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.charAt(2) != ',') {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(0, 15));
            return null;
        }
        switch (sentence.substring(0, 2)) {
            case "1G": 
            case "1R": 
            case "1M": {
                return this.decode1G(channel, remoteAddress, sentence);
            }
            case "2G": {
                return this.decode2G(channel, remoteAddress, sentence);
            }
        }
        return null;
    }

    private Position decode1G(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_1G, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", parser.next());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("hdop", parser.nextDouble(0.0));
        position.set("status", parser.next());
        return position;
    }

    private Position decode2G(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_2G, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime());
        position.set("sat", parser.nextInt());
        position.setAltitude(parser.nextDouble());
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        position.set("odometer", parser.nextDouble() * 1852.0 / 3600.0);
        return position;
    }
}

