/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Position;

@Singleton
@ChannelHandler.Sharable
public class MediaEventHandler
extends BaseEventHandler {
    @Inject
    public MediaEventHandler() {
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        return Stream.of("image", "video", "audio").filter(position::hasAttribute).map(type -> {
            Event event = new Event("media", position);
            event.set("media", (String)type);
            event.set("file", position.getString((String)type));
            return event;
        }).collect(Collectors.toMap(event -> event, event -> position));
    }
}

