/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.core.DerbyDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.StandardLockService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomInitializeDatabaseChangeLogLockTableStatement;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomLockDatabaseChangeLogStatement;
import org.keycloak.connections.jpa.updater.liquibase.lock.LockRetryException;
import org.keycloak.models.dblock.DBLockProvider;

public class CustomLockService
extends StandardLockService {
    private static final Logger log = Logger.getLogger(CustomLockService.class);

    protected boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        boolean originalReturnValue = super.hasDatabaseChangeLogLockTable();
        if (originalReturnValue && this.database.getConnection().getDatabaseProductName().equals("H2")) {
            Table lockTable = (Table)new Table().setName(this.database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName()));
            SnapshotGeneratorFactory instance = SnapshotGeneratorFactory.getInstance();
            try {
                DatabaseSnapshot snapshot = instance.createSnapshot(lockTable.getSchema().toCatalogAndSchema(), this.database, new SnapshotControl(this.database, false, new Class[]{Table.class, PrimaryKey.class}).setWarnIfObjectNotFound(false));
                Table lockTableFromSnapshot = (Table)snapshot.get((DatabaseObject)lockTable);
                if (lockTableFromSnapshot == null) {
                    throw new RuntimeException("DATABASECHANGELOGLOCK not found, although Liquibase claims it exists.");
                }
                if (lockTableFromSnapshot.getPrimaryKey() == null) {
                    log.warn((Object)"Primary key not found - table creation not complete yet.");
                    return false;
                }
            }
            catch (InvalidExampleException e) {
                throw new RuntimeException(e);
            }
        }
        return originalReturnValue;
    }

    public void init() throws DatabaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        if (!this.hasDatabaseChangeLogLockTable()) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Create Database Lock Table");
                }
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                this.database.commit();
            }
            catch (DatabaseException de) {
                log.warn((Object)"Failed to create lock table. Maybe other transaction created in the meantime. Retrying...", (Throwable)de);
                if (log.isTraceEnabled()) {
                    log.trace((Object)de.getMessage(), (Throwable)de);
                }
                this.database.rollback();
                throw new LockRetryException(de);
            }
            log.debugf("Created database lock table with name: %s", (Object)this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            try {
                Field field = Reflections.findDeclaredField(StandardLockService.class, (String)"hasDatabaseChangeLogLockTable");
                Reflections.setAccessible((AccessibleObject)field);
                field.set((Object)this, true);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
        try {
            Set<Integer> currentIds = this.currentIdsInDatabaseChangeLogLockTable();
            if (!currentIds.containsAll(Arrays.asList(DBLockProvider.Namespace.values()))) {
                if (log.isTraceEnabled()) {
                    log.tracef("Initialize Database Lock Table, current locks %s", currentIds);
                }
                executor.execute((SqlStatement)new CustomInitializeDatabaseChangeLogLockTableStatement(currentIds));
                this.database.commit();
                log.debug((Object)"Initialized record in the database lock table");
            }
        }
        catch (DatabaseException de) {
            log.warn((Object)"Failed to insert first record to the lock table. Maybe other transaction inserted in the meantime. Retrying...", (Throwable)de);
            if (log.isTraceEnabled()) {
                log.trace((Object)de.getMessage(), (Throwable)de);
            }
            this.database.rollback();
            throw new LockRetryException(de);
        }
        if (executor.updatesDatabase() && this.database instanceof DerbyDatabase && ((DerbyDatabase)this.database).supportsBooleanDataType()) {
            String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            Object obj = executor.queryForObject((SqlStatement)new RawSqlStatement("select min(locked) as test from " + lockTable + " fetch first row only"), Object.class);
            if (!(obj instanceof Boolean)) {
                executor.execute((SqlStatement)new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                executor.execute((SqlStatement)new InitializeDatabaseChangeLogLockTableStatement());
            }
        }
    }

    private Set<Integer> currentIdsInDatabaseChangeLogLockTable() throws DatabaseException {
        try {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            String idColumnName = this.database.escapeColumnName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), "ID");
            String lockTableName = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            RawSqlStatement sqlStatement = new RawSqlStatement("SELECT " + idColumnName + " FROM " + lockTableName);
            List rows = executor.queryForList((SqlStatement)sqlStatement);
            Set<Integer> ids = rows.stream().map(columnMap -> ((Number)columnMap.get("ID")).intValue()).collect(Collectors.toSet());
            this.database.commit();
            return ids;
        }
        catch (UnexpectedLiquibaseException ulie) {
            if (ulie.getCause() != null && ulie.getCause() instanceof DatabaseException) {
                throw (DatabaseException)ulie.getCause();
            }
            throw ulie;
        }
    }

    public void waitForLock() {
        this.waitForLock(new LockDatabaseChangeLogStatement());
    }

    public void waitForLock(DBLockProvider.Namespace lock) {
        this.waitForLock(new CustomLockDatabaseChangeLogStatement(lock.getId()));
    }

    private void waitForLock(LockDatabaseChangeLogStatement lockStmt) {
        boolean locked = false;
        long startTime = Time.toMillis((long)Time.currentTime());
        long timeToGiveUp = startTime + this.getChangeLogLockWaitTime();
        boolean nextAttempt = true;
        while (nextAttempt) {
            locked = this.acquireLock(lockStmt);
            if (!locked) {
                int remainingTime = (int)(timeToGiveUp / 1000L) - Time.currentTime();
                if (remainingTime > 0) {
                    log.debugf("Will try to acquire log another time. Remaining time: %d seconds", remainingTime);
                    continue;
                }
                nextAttempt = false;
                continue;
            }
            nextAttempt = false;
        }
        if (!locked) {
            int timeout = (int)(this.getChangeLogLockWaitTime() / 1000L);
            throw new IllegalStateException("Could not acquire change log lock within specified timeout " + timeout + " seconds.  Currently locked by other transaction");
        }
    }

    public boolean acquireLock() {
        return this.acquireLock(new LockDatabaseChangeLogStatement());
    }

    private boolean acquireLock(LockDatabaseChangeLogStatement lockStmt) {
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            this.database.rollback();
            this.init();
        }
        catch (DatabaseException de) {
            throw new IllegalStateException("Failed to retrieve lock", de);
        }
        try {
            log.debug((Object)"Trying to lock database");
            executor.execute((SqlStatement)lockStmt);
            log.debug((Object)"Successfully acquired database lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            return true;
        }
        catch (DatabaseException de) {
            log.warn((Object)("Lock didn't yet acquired. Will possibly retry to acquire lock. Details: " + de.getMessage()), (Throwable)de);
            if (log.isTraceEnabled()) {
                log.debug((Object)de.getMessage(), (Throwable)de);
            }
            return false;
        }
    }

    public void releaseLock() {
        try {
            if (this.hasChangeLogLock) {
                log.debug((Object)"Going to release database lock");
                this.database.commit();
            } else {
                log.warn((Object)"Attempt to release lock, which is not owned by current transaction");
            }
        }
        catch (Exception e) {
            log.error((Object)"Database error during release lock", (Throwable)e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }
}

