/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.common.annotation.Blocking;
import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.ApplicationPath;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;
import org.keycloak.quarkus.runtime.integration.jaxrs.CloseSessionHandler;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusObjectMapperResolver;
import org.keycloak.quarkus.runtime.services.resources.DebugHostnameSettingsResource;
import org.keycloak.services.resources.KeycloakApplication;

@ApplicationPath(value="/")
@Blocking
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    void onStartupEvent(@Observes StartupEvent event) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        platform.started();
        QuarkusPlatform.exitOnError();
        this.startup();
    }

    void onShutdownEvent(@Observes ShutdownEvent event) {
        this.shutdown();
    }

    public KeycloakSessionFactory createSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        instance.init();
        return instance;
    }

    protected void loadConfig() {
    }

    public Set<Object> getSingletons() {
        return Set.of();
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet(super.getClasses());
        classes.add(QuarkusObjectMapperResolver.class);
        classes.add(CloseSessionHandler.class);
        classes.add(DebugHostnameSettingsResource.class);
        return classes;
    }
}

