/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.config.ProxyOptions;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

final class ProxyPropertyMappers {
    private ProxyPropertyMappers() {
    }

    public static PropertyMapper[] getProxyPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ProxyOptions.PROXY).to("quarkus.http.proxy.proxy-address-forwarding").transformer(ProxyPropertyMappers::isProxyHeadersEnabled).paramLabel("mode").build(), PropertyMapper.fromOption(ProxyOptions.PROXY_FORWARDED_HOST).to("quarkus.http.proxy.enable-forwarded-host").mapFrom("proxy").transformer(ProxyPropertyMappers::isProxyHeadersEnabled).build(), PropertyMapper.fromOption(ProxyOptions.PROXY_FORWARDED_HEADER_ENABLED).to("quarkus.http.proxy.allow-forwarded").mapFrom("proxy").transformer(ProxyPropertyMappers::isProxyHeadersEnabled).build(), PropertyMapper.fromOption(ProxyOptions.PROXY_X_FORWARDED_HEADER_ENABLED).to("quarkus.http.proxy.allow-x-forwarded").mapFrom("proxy").transformer(ProxyPropertyMappers::isProxyHeadersEnabled).build()};
    }

    private static Optional<String> isProxyHeadersEnabled(Optional<String> value, ConfigSourceInterceptorContext context) {
        try {
            return Optional.of(String.valueOf(ProxyOptions.Mode.valueOf((String)value.get()).isProxyHeadersEnabled()));
        }
        catch (IllegalArgumentException iae) {
            QuarkusPlatform.addInitializationException(Messages.invalidProxyMode(value.get()));
            return Optional.of(Boolean.FALSE.toString());
        }
    }
}

