/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class NTFListener
extends Thread
implements Diagnosable {
    private static final String CLASS_NAME = NTFListener.class.getName();
    private ArrayList<NTFConnection> connections;
    private final Monitor connectionsMonitor = Monitor.newInstance();
    private int nbOfConnections = 0;
    private boolean needsToBeClosed = false;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    public Properties socketOptions;
    private Exception[] connectionCreationExceptionArr;

    NTFListener(NTFManager _dcnManager, ServerSocketChannel _ssChannel, int _tcpport, @Blind(value=PropertiesBlinder.class) Properties _socketOptions, Exception[] _connectionCreationExceptionArr) {
        this.dcnManager = _dcnManager;
        this.connections = new ArrayList(10);
        this.ssChannel = _ssChannel;
        this.tcpport = _tcpport;
        this.socketOptions = _socketOptions;
        this.connectionCreationExceptionArr = _connectionCreationExceptionArr;
    }

    @Override
    public void run() {
        try {
            Selector selector = Selector.open();
            this.ssChannel.register(selector, 16);
            block9: while (true) {
                selector.select();
                if (this.needsToBeClosed) break;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (true) {
                    block14: {
                        if (!iterator.hasNext()) continue block9;
                        SelectionKey aKey = iterator.next();
                        if ((aKey.readyOps() & 0x10) != 16) continue;
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "tcpport= {0}, thread=OP_ACCEPT. ", (String)null, (Throwable)null, (Object)this.tcpport);
                        ServerSocketChannel server = (ServerSocketChannel)aKey.channel();
                        SocketChannel connectionChannel = server.accept();
                        try {
                            NTFConnection conn = new NTFConnection(this.dcnManager, connectionChannel, this);
                            try (Monitor.CloseableLock lock = this.connectionsMonitor.acquireCloseableLock();){
                                this.connections.add(conn);
                            }
                            conn.start();
                            if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                                this.connectionCreationExceptionArr[0] = null;
                            }
                        }
                        catch (IOException ioe) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "tcpport={0}. ", (String)null, ioe, (Object)this.tcpport);
                            if (this.connectionCreationExceptionArr == null || this.connectionCreationExceptionArr.length <= 0) break block14;
                            this.connectionCreationExceptionArr[0] = ioe;
                        }
                    }
                    iterator.remove();
                }
                break;
            }
            selector.close();
            this.ssChannel.close();
        }
        catch (IOException ioe) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "tcpport={0}. ", (String)null, ioe, (Object)this.tcpport);
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "tcpport={0}. End of run method. Thread will be closed. ", (String)null, (Throwable)null, (Object)this.tcpport);
    }

    void closeThisListener() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeThisListener", "tcpport={0}. Closing listener. ", (String)null, (Throwable)null, (Object)this.tcpport);
        try (Monitor.CloseableLock lock = this.connectionsMonitor.acquireCloseableLock();){
            for (NTFConnection conn : this.connections) {
                conn.closeThisConnection();
                conn.interrupt();
            }
            this.needsToBeClosed = true;
        }
    }

    void releaseConnection(NTFConnection conn) {
        try (Monitor.CloseableLock lock = this.connectionsMonitor.acquireCloseableLock();){
            this.connections.remove(conn);
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "releaseConnection", "tcpport={0}. Connection released. ", (String)null, (Throwable)null, (Object)this.tcpport);
    }

    Exception getRegistrationException() {
        if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
            return this.connectionCreationExceptionArr[0];
        }
        return null;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

