/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.MultiRootPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import java.nio.file.Path;

public interface ResolvedDependency
extends Dependency {
    public PathCollection getResolvedPaths();

    default public boolean isResolved() {
        PathCollection paths = this.getResolvedPaths();
        return paths != null && !paths.isEmpty();
    }

    default public WorkspaceModule getWorkspaceModule() {
        return null;
    }

    default public ArtifactSources getSources() {
        WorkspaceModule module = this.getWorkspaceModule();
        return module == null ? null : module.getSources(this.getClassifier());
    }

    default public PathTree getContentTree() {
        return this.getContentTree(null);
    }

    default public PathTree getContentTree(PathFilter pathFilter) {
        EmptyPathTree workspaceTree;
        WorkspaceModule module = this.getWorkspaceModule();
        PathTree pathTree = workspaceTree = module == null ? EmptyPathTree.getInstance() : module.getContentTree(this.getClassifier());
        if (!workspaceTree.isEmpty()) {
            return workspaceTree;
        }
        PathCollection paths = this.getResolvedPaths();
        if (paths == null || paths.isEmpty()) {
            return EmptyPathTree.getInstance();
        }
        if (paths.isSinglePath()) {
            Path p = paths.getSinglePath();
            return this.isJar() ? PathTree.ofDirectoryOrArchive(p, pathFilter) : PathTree.ofDirectoryOrFile(p, pathFilter);
        }
        PathTree[] trees = new PathTree[paths.size()];
        int i = 0;
        for (Path p : paths) {
            trees[i++] = PathTree.ofDirectoryOrArchive(p, pathFilter);
        }
        return new MultiRootPathTree(trees);
    }
}

