/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.util;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.keycloak.saml.processing.core.saml.v2.util.DocumentUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Soap {
    public static SoapFaultBuilder createFault() {
        return new SoapFaultBuilder();
    }

    public static SoapMessageBuilder createMessage() {
        return new SoapMessageBuilder();
    }

    public static String toSamlHttpPostMessage(Document document) {
        try {
            return PostBindingUtil.base64Encode((String)DocumentUtil.asString((Document)document));
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding SOAP document to String.", e);
        }
    }

    public static Document extractSoapMessage(InputStream inputStream) {
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage(null, inputStream);
            return Soap.extractSoapMessage(soapMessage);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating fault message.", e);
        }
    }

    public static Document extractSoapMessage(SOAPMessage soapMessage) {
        try {
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Node authnRequestNode = Soap.getFirstChild((Node)soapBody);
            Document document = DocumentUtil.createDocument();
            document.appendChild(document.importNode(authnRequestNode, true));
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating fault message.", e);
        }
    }

    public static Node getFirstChild(Node parent) {
        Node n;
        for (n = parent.getFirstChild(); n != null && !(n instanceof Element); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }

    public static class SoapFaultBuilder {
        private final SOAPFault fault;
        private final SoapMessageBuilder messageBuilder = Soap.createMessage();

        private SoapFaultBuilder() {
            try {
                this.fault = this.messageBuilder.getMessage().getSOAPBody().addFault();
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not create SOAP Fault.", e);
            }
        }

        public SoapFaultBuilder detail(String detail) {
            try {
                this.fault.addDetail().setValue(detail);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public SoapFaultBuilder reason(String reason) {
            try {
                this.fault.setFaultString(reason);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public SoapFaultBuilder code(String code) {
            try {
                this.fault.setFaultCode(code);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public Response build() {
            return this.messageBuilder.build(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public static class SoapMessageBuilder {
        private final SOAPMessage message;
        private final SOAPBody body;
        private final SOAPEnvelope envelope;

        private SoapMessageBuilder() {
            try {
                this.message = MessageFactory.newInstance().createMessage();
                this.envelope = this.message.getSOAPPart().getEnvelope();
                this.body = this.message.getSOAPBody();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
        }

        public SoapMessageBuilder addToBody(Document document) {
            try {
                this.body.addDocument(document);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add document to SOAP body.", e);
            }
            return this;
        }

        public SoapMessageBuilder addNamespace(String prefix, String ns) {
            try {
                this.envelope.addNamespaceDeclaration(prefix, ns);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add namespace to SOAP Envelope.", e);
            }
            return this;
        }

        public SOAPHeaderElement addHeader(String name, String prefix) {
            try {
                return this.envelope.getHeader().addHeaderElement(this.envelope.createQName(name, prefix));
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add SOAP Header.", e);
            }
        }

        public SoapMessageBuilder addMimeHeader(String name, String value) {
            this.message.getMimeHeaders().addHeader(name, value);
            return this;
        }

        public Name createName(String name) {
            try {
                return this.envelope.createName(name);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not create Name.", e);
            }
        }

        public byte[] getBytes() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                this.message.writeTo((OutputStream)outputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while building SOAP Fault.", e);
            }
            return outputStream.toByteArray();
        }

        public Response build() {
            return this.build(Response.Status.OK);
        }

        Response build(Response.Status status) {
            return Response.status((Response.Status)status).entity((Object)this.getBytes()).type(MediaType.TEXT_XML_TYPE).build();
        }

        public HttpPost buildHttpPost(URI uri) {
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new ByteArrayEntity(this.getBytes(), ContentType.TEXT_XML));
            return post;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public SOAPMessage call(String url) throws SOAPException {
            SOAPMessage response;
            try (SOAPConnection soapConnection = null;){
                SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
                soapConnection = soapConnectionFactory.createConnection();
                response = soapConnection.call(this.message, (Object)url);
            }
            return response;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SOAPMessage call(String url, KeycloakSession session) throws SOAPException {
            if (this.message.saveRequired()) {
                this.message.saveChanges();
            }
            SimpleHttp simpleHttp = SimpleHttp.doPost((String)url, (KeycloakSession)session);
            Iterator reqHeaders = this.message.getMimeHeaders().getAllHeaders();
            ContentType contentType = null;
            int length = -1;
            boolean hasCacheControl = false;
            while (reqHeaders.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)reqHeaders.next();
                if ("Content-Type".equalsIgnoreCase(mimeHeader.getName())) {
                    contentType = ContentType.parse((String)mimeHeader.getValue());
                    continue;
                }
                if ("Content-Length".equalsIgnoreCase(mimeHeader.getName())) {
                    length = Integer.parseInt(mimeHeader.getValue());
                    continue;
                }
                if ("Cache-Control".equalsIgnoreCase(mimeHeader.getName())) {
                    hasCacheControl = true;
                }
                String currentValue = simpleHttp.getHeader(mimeHeader.getName());
                simpleHttp.header(mimeHeader.getName(), currentValue == null ? mimeHeader.getValue() : currentValue + "," + mimeHeader.getValue());
            }
            if (!hasCacheControl) {
                simpleHttp.header("Cache-Control", "no-cache, no-store");
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.message.writeTo((OutputStream)out);
                simpleHttp.entity((HttpEntity)new ByteArrayEntity(out.toByteArray(), 0, length, contentType));
                try (SimpleHttp.Response res = simpleHttp.asResponse();){
                    Header[] headers;
                    if (res.getStatus() != 500 && res.getStatus() != 400) {
                        if (res.getStatus() != 200) throw new SOAPException("Bad response (" + res.getStatus() + ") :" + res.asString());
                    }
                    MimeHeaders resHeaders = new MimeHeaders();
                    for (Header header : headers = res.getAllHeaders()) {
                        resHeaders.addHeader(header.getName(), header.getValue());
                    }
                    String responseString = res.asString();
                    if (responseString == null || responseString.isEmpty()) {
                        SOAPMessage sOAPMessage = null;
                        return sOAPMessage;
                    }
                    SOAPMessage sOAPMessage = MessageFactory.newInstance().createMessage(resHeaders, (InputStream)new ByteArrayInputStream(responseString.getBytes(res.getContentTypeCharset())));
                    return sOAPMessage;
                }
            }
            catch (IOException e) {
                throw new SOAPException((Throwable)e);
            }
        }

        public SOAPMessage getMessage() {
            return this.message;
        }
    }
}

