/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public final class CacheHelper {
    private CacheHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, CachedDomainDataAccess cacheAccess) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Object cachedValue = null;
        eventListenerManager.cacheGetStart();
        try {
            cachedValue = cacheAccess.get(session, cacheKey);
            eventListenerManager.cacheGetEnd(cachedValue != null);
        }
        catch (Throwable throwable) {
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        return cachedValue;
    }

    public static void addBasicValueToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, JdbcMapping jdbcMapping, SharedSessionContractImplementor session) {
        int hashCode;
        Serializable disassemble;
        if (value == null) {
            cacheKey.addValue(null);
            cacheKey.addHashCode(0);
            return;
        }
        BasicValueConverter converter = jdbcMapping.getValueConverter();
        if (converter == null) {
            disassemble = jdbcMapping.getJavaTypeDescriptor().getMutabilityPlan().disassemble(value, session);
            hashCode = jdbcMapping.getMappedJavaType().extractHashCode(value);
        } else {
            Object relationalValue = converter.toRelationalValue(value);
            JavaType relationalJavaType = converter.getRelationalJavaType();
            disassemble = relationalJavaType.getMutabilityPlan().disassemble(relationalValue, session);
            hashCode = relationalJavaType.extractHashCode(relationalValue);
        }
        cacheKey.addValue(disassemble);
        cacheKey.addHashCode(hashCode);
    }
}

