/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;

public class AuthenticationSelectionOption {
    private final AuthenticationExecutionModel authExec;
    private final CredentialTypeMetadata credentialTypeMetadata;

    public AuthenticationSelectionOption(KeycloakSession session, AuthenticationExecutionModel authExec) {
        this.authExec = authExec;
        Authenticator authenticator = (Authenticator)session.getProvider(Authenticator.class, authExec.getAuthenticator());
        if (authenticator instanceof CredentialValidator) {
            Object credentialProvider = ((CredentialValidator)((Object)authenticator)).getCredentialProvider(session);
            CredentialTypeMetadataContext ctx = CredentialTypeMetadataContext.builder().build(session);
            this.credentialTypeMetadata = credentialProvider.getCredentialTypeMetadata(ctx);
        } else {
            this.credentialTypeMetadata = null;
        }
    }

    public AuthenticationExecutionModel getAuthenticationExecution() {
        return this.authExec;
    }

    public String getAuthExecId() {
        return this.authExec.getId();
    }

    public String getDisplayName() {
        return this.credentialTypeMetadata == null ? this.authExec.getAuthenticator() + "-display-name" : this.credentialTypeMetadata.getDisplayName();
    }

    public String getHelpText() {
        return this.credentialTypeMetadata == null ? this.authExec.getAuthenticator() + "-help-text" : this.credentialTypeMetadata.getHelpText();
    }

    public String getIconCssClass() {
        return this.credentialTypeMetadata == null ? "kcAuthenticatorDefaultClass" : this.credentialTypeMetadata.getIconCssClass();
    }

    public String toString() {
        return " authSelection - " + this.authExec.getAuthenticator();
    }
}

