/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.StringBufferExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0016J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020 J\u0012\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020$R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jitsi/nlj/stats/NodeStatsBlock;", "", "name", "", "(Ljava/lang/String;)V", "compoundStats", "", "Lkotlin/Function1;", "", "getName", "()Ljava/lang/String;", "stats", "addBlock", "", "otherBlock", "addBoolean", "value", "", "addCompoundValue", "compoundValue", "addJson", "json", "", "addNumber", "addString", "aggregate", "getNumber", "getNumberOrDefault", "default", "getValue", "prettyPrint", "indentLevel", "", "promote", "n", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "jitsi-media-transform"})
public final class NodeStatsBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Object> stats;
    @NotNull
    private final Map<String, Function1<NodeStatsBlock, Number>> compoundStats;
    @NotNull
    private static final String AGGREGATES = "_aggregates";

    public NodeStatsBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.stats = new LinkedHashMap();
        this.compoundStats = new LinkedHashMap();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void addNumber(@NotNull String name, @NotNull Number value2) {
        block0: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value2, "value");
            Number number = this.promote(value2);
            if (number == null) break block0;
            Number it = number;
            boolean bl = false;
            this.stats.put(name, it);
        }
    }

    public final void addString(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.stats.put(name, value2);
    }

    public final void addBoolean(@NotNull String name, boolean value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Boolean bl = value2;
        this.stats.put(name, bl);
    }

    public final void addBlock(@NotNull NodeStatsBlock otherBlock) {
        Intrinsics.checkNotNullParameter(otherBlock, "otherBlock");
        this.stats.put(otherBlock.name, otherBlock);
    }

    public final void addJson(@NotNull String name, @NotNull Map<?, ?> json) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(json, "json");
        this.addBlock(Companion.fromJson(name, json));
    }

    public final void addCompoundValue(@NotNull String name, @NotNull Function1<? super NodeStatsBlock, ? extends Number> compoundValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(compoundValue, "compoundValue");
        this.compoundStats.put(name, compoundValue);
    }

    @Nullable
    public final Object getValue(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.stats.containsKey(name)) {
            object = this.stats.get(name);
        } else if (this.compoundStats.containsKey(name)) {
            Function1<NodeStatsBlock, Number> function1 = this.compoundStats.get(name);
            object = function1 != null ? function1.invoke(this) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final Number getNumber(@NotNull String name) {
        Number number;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.stats.get(name) instanceof Number) {
            Object object = this.stats.get(name);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            number = (Number)object;
        } else if (this.compoundStats.containsKey(name)) {
            Function1<NodeStatsBlock, Number> function1 = this.compoundStats.get(name);
            number = function1 != null ? function1.invoke(this) : null;
        } else {
            number = null;
        }
        return number;
    }

    @NotNull
    public final Number getNumberOrDefault(@NotNull String name, @NotNull Number number) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(number, "default");
        Number number2 = this.getNumber(name);
        if (number2 == null) {
            number2 = number;
        }
        return number2;
    }

    public final void aggregate(@NotNull NodeStatsBlock otherBlock) {
        String name;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        Intrinsics.checkNotNullParameter(otherBlock, "otherBlock");
        Map<String, Object> $this$forEach$iv = otherBlock.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            name = entry.getKey();
            Object value2 = entry.getValue();
            Object existingValue = this.stats.get(name);
            if (existingValue == null && (value2 instanceof Long || value2 instanceof Double)) {
                this.stats.put(name, value2);
                continue;
            }
            if (existingValue instanceof Long && value2 instanceof Long) {
                this.stats.put(name, ((Number)existingValue).longValue() + ((Number)value2).longValue());
                continue;
            }
            if (existingValue instanceof Double && value2 instanceof Double) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            if (existingValue instanceof Long && value2 instanceof Double) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            if (existingValue instanceof Double && value2 instanceof Long) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            this.stats.put(name, value2);
        }
        $this$forEach$iv = otherBlock.compoundStats;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            name = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            this.addCompoundValue(name, function);
        }
        this.stats.put(AGGREGATES, (Long)this.stats.getOrDefault(AGGREGATES, 0L) + 1L);
    }

    private final Number promote(Number n) {
        Number number = n;
        return (((number instanceof Byte ? true : number instanceof Short) ? true : number instanceof Integer) ? true : number instanceof Long) ? (Number)n.longValue() : (Number)((number instanceof Float ? true : number instanceof Double) ? (Number)n.doubleValue() : null);
    }

    @NotNull
    public final String prettyPrint(int indentLevel) {
        String statName;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        StringBuffer $this$prettyPrint_u24lambda_u2d5 = new StringBuffer();
        boolean bl = false;
        StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u2d5, indentLevel, this.name);
        Map<String, Object> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            statName = entry.getKey();
            Object statValue = entry.getValue();
            if (statValue instanceof NodeStatsBlock) {
                Appendable appendable = ((Appendable)$this$prettyPrint_u24lambda_u2d5).append(((NodeStatsBlock)statValue).prettyPrint(indentLevel + 2));
                Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
                continue;
            }
            StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u2d5, indentLevel + 2, statName + ": " + statValue);
        }
        $this$forEach$iv = this.compoundStats;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl3 = false;
            statName = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            Number statValue = (Number)function.invoke(this);
            StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u2d5, indentLevel + 2, statName + ": " + statValue);
        }
        String string = $this$prettyPrint_u24lambda_u2d5.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(StringBuffer()) {\n \u2026     toString()\n        }");
        return string;
    }

    public static /* synthetic */ String prettyPrint$default(NodeStatsBlock nodeStatsBlock, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return nodeStatsBlock.prettyPrint(n);
    }

    @NotNull
    public final OrderedJsonObject toJson() {
        String name;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$toJson_u24lambda_u2d8 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            name = entry.getKey();
            Object value2 = entry.getValue();
            if (value2 instanceof NodeStatsBlock) {
                $this$toJson_u24lambda_u2d8.put(name, ((NodeStatsBlock)value2).toJson());
                continue;
            }
            $this$toJson_u24lambda_u2d8.put(name, value2);
        }
        $this$forEach$iv = this.compoundStats;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl3 = false;
            name = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            $this$toJson_u24lambda_u2d8.put(name, function.invoke(this));
        }
        return orderedJsonObject;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/stats/NodeStatsBlock$Companion;", "", "()V", "AGGREGATES", "", "fromJson", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "name", "json", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeStatsBlock fromJson(@NotNull String name, @NotNull Map<?, ?> json) {
            NodeStatsBlock nodeStatsBlock;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(json, "json");
            NodeStatsBlock $this$fromJson_u24lambda_u2d1 = nodeStatsBlock = new NodeStatsBlock(name);
            boolean bl = false;
            Iterable $this$forEach$iv = json.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                Object v = value2;
                if (v instanceof Map) {
                    $this$fromJson_u24lambda_u2d1.addBlock(Companion.fromJson(String.valueOf(key), (Map)value2));
                    continue;
                }
                if (v instanceof Number) {
                    $this$fromJson_u24lambda_u2d1.addNumber(String.valueOf(key), (Number)value2);
                    continue;
                }
                if (v instanceof Boolean) {
                    $this$fromJson_u24lambda_u2d1.addBoolean(String.valueOf(key), (Boolean)value2);
                    continue;
                }
                $this$fromJson_u24lambda_u2d1.addString(String.valueOf(key), String.valueOf(value2));
            }
            return nodeStatsBlock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

