/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;

public class ServerInfoMessage
extends AttributeMessage {
    private static final String ADDRESS_TAG = "address";
    private static final String CURRENTLY_PLAYING_TAG = "currentlyPlaying";
    private static final String GAME_STATE_TAG = "gameState";
    private static final String IS_GAME_STARTED_TAG = "isGameStarted";
    private static final String NAME_TAG = "name";
    private static final String PORT_TAG = "port";
    private static final String SLOTS_AVAILABLE_TAG = "slotsAvailable";
    private static final String VERSION_TAG = "version";

    protected ServerInfoMessage(String tag, ServerInfo si) {
        super(tag, NAME_TAG, si.getName(), ADDRESS_TAG, si.getAddress(), PORT_TAG, String.valueOf(si.getPort()), SLOTS_AVAILABLE_TAG, String.valueOf(si.getSlotsAvailable()), CURRENTLY_PLAYING_TAG, String.valueOf(si.getCurrentlyPlaying()), IS_GAME_STARTED_TAG, String.valueOf(si.getIsGameStarted()), VERSION_TAG, si.getVersion(), GAME_STATE_TAG, String.valueOf(si.getGameState()));
    }

    public ServerInfoMessage(String tag, Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(tag, xr, NAME_TAG, ADDRESS_TAG, PORT_TAG, SLOTS_AVAILABLE_TAG, CURRENTLY_PLAYING_TAG, IS_GAME_STARTED_TAG, VERSION_TAG, GAME_STATE_TAG);
    }

    public ServerInfo getServerInfo() {
        return new ServerInfo(this.getStringAttribute(NAME_TAG), this.getStringAttribute(ADDRESS_TAG), this.getIntegerAttribute(PORT_TAG, -1), this.getIntegerAttribute(SLOTS_AVAILABLE_TAG, -1), this.getIntegerAttribute(CURRENTLY_PLAYING_TAG, -1), this.getBooleanAttribute(IS_GAME_STARTED_TAG, Boolean.FALSE), this.getStringAttribute(VERSION_TAG), this.getIntegerAttribute(GAME_STATE_TAG, -1));
    }

    public String getAddress() {
        return this.getStringAttribute(ADDRESS_TAG);
    }

    public void setAddress(String address) {
        this.setStringAttribute(ADDRESS_TAG, address);
    }

    public int getPort() {
        return this.getIntegerAttribute(PORT_TAG, -1);
    }
}

